/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.redeem;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.financing.util.GetSubContractNo;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.bank.EBBankQueryFinancingDetailResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RedeemFinancingImpl
extends AbstractFinancingImpl
implements IRedeemFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(RedeemFinancingImpl.class);

    public String pack(BankFinancingRequest bankFinancingRequest) {
        List infos = bankFinancingRequest.getInfos();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        BankAcnt acnt = bankFinancingRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New(this.getBizCode(), Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)info.getCshDraFlag());
        JDomUtils.addChild((Element)corp, (String)"ContractNo", (String)info.getReserved1());
        JDomUtils.addChild((Element)corp, (String)"StartDate");
        JDomUtils.addChild((Element)corp, (String)"EndDate");
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)info.getAccName());
        JDomUtils.addChild((Element)corp, (String)"TotalNum", (String)"1");
        JDomUtils.addChild((Element)corp, (String)"DbBankName", (String)acnt.getBankName());
        JDomUtils.addChild((Element)corp, (String)"TrFlg", (String)"0");
        Element pds = JDomUtils.addChild((Element)root, (String)"Pds");
        JDomUtils.addChild((Element)pds, (String)"Share", (String)info.getNumber());
        JDomUtils.addChild((Element)pds, (String)"PrdNam", (String)info.getProductName());
        JDomUtils.addChild((Element)pds, (String)"PrdNo", (String)info.getProductCode());
        JDomUtils.addChild((Element)pds, (String)"RefPrice");
        JDomUtils.addChild((Element)pds, (String)"PurchasePrice");
        JDomUtils.addChild((Element)pds, (String)"TopFfrShare");
        JDomUtils.addChild((Element)pds, (String)"BuyAmt");
        JDomUtils.addChild((Element)pds, (String)"SHRACT");
        JDomUtils.addChild((Element)pds, (String)"RedeemStatus", (String)"4");
        JDomUtils.addChild((Element)pds, (String)"PrdDueDes");
        JDomUtils.addChild((Element)pds, (String)"ProfitType");
        BankQueryFinancingDetailRequest request = new BankQueryFinancingDetailRequest();
        BankHeader head = new BankHeader();
        head.setAcnt(acnt);
        request.setHeader(head);
        request.setProductCode(info.getReserved1());
        GetSubContractNo query = new GetSubContractNo();
        EBBankQueryFinancingDetailResponse contractNoResponse = query.doBiz(request);
        List contractDetails = contractNoResponse.getDetails();
        String subcontractNo = "";
        String subcontractNoName = "";
        for (FinancingProductDetail detail : contractDetails) {
            subcontractNo = ((FinancingBankField)detail.getBankFields().get(0)).getValue();
            subcontractNoName = ((FinancingBankField)detail.getBankFields().get(0)).getKey();
            JDomUtils.addChild((Element)pds, (String)subcontractNoName, (String)subcontractNo);
        }
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u8d4e\u56de\u8bf7\u6c42\u62a5\u6587");
        return result;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest request, String rspStr) {
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        List infos = request.getInfos();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u8d4e\u56de\u5931\u8d25\u3002", (String)"RedeemFinancingImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RedeemFinancingImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseMessage(), (String)"");
        }
        Element pds = root.getChild("Pds");
        String traceNo = pds.getChildTextTrim("TraceNo");
        for (FinancingInfo message : infos) {
            message.setReserved2(traceNo);
        }
        result.setInfos(infos);
        return result;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CFLC03";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\uff08\u5bf9\u516c\uff09\u3002", (String)"RedeemFinancingImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return true;
    }
}

