/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.util;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.financing.atomic.AbstractQueryFinancingImpl;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.business.financing.bank.EBBankQueryFinancingDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryContractNo
extends AbstractQueryFinancingImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryContractNo.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQLC11";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6301\u6709\u7406\u8d22\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"QueryContractNo_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public EBBankQueryFinancingDetailResponse doBiz(BankQueryFinancingDetailRequest rqst) {
        ArrayList result = new ArrayList(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankQueryFinancingDetailResponse response = super.process(rqst);
            result.addAll(response.getDetails());
        }
        return new EBBankQueryFinancingDetailResponse(result);
    }

    public String pack(BankQueryFinancingDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQLC11", Sequence.genSequence());
        String contFlag = RequestContextUtils.getRunningParam((String)"contFlag");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"ContFlag", (String)(StringUtils.isNotEmpty((String)contFlag) ? contFlag : "0"));
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast");
        Element pds = JDomUtils.addChild((Element)root, (String)"Pds");
        JDomUtils.addChild((Element)pds, (String)"RedSechType");
        JDomUtils.addChild((Element)pds, (String)"ProNo");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"PrdSts", (String)"0");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)"0");
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u5408\u540c\u53f7\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)result);
        return result;
    }

    public EBBankQueryFinancingDetailResponse parse(BankQueryFinancingDetailRequest bankQueryFinancingDetailRequest, String rspStr) {
        ArrayList<FinancingProductDetail> detailList = new ArrayList<FinancingProductDetail>(16);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u5408\u540c\u53f7\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"QueryContractNo_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cmp = root.getChild("Cmp");
        Element cme = root.getChild("Cme");
        String contFlag = cmp.getChildText("ContFlag");
        if (StringUtils.isEmpty((String)contFlag) || "0".equals(contFlag)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            RequestContextUtils.setRunningParam((String)"contFlag", (String)contFlag);
        }
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return new EBBankQueryFinancingDetailResponse(detailList);
        }
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        String[] splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String PrdNo = splits[fieldNum * i];
            FinancingProductDetail detail = new FinancingProductDetail();
            detailList.add(detail);
            detail.setProductCode(PrdNo);
            ArrayList<FinancingBankField> bankFields = new ArrayList<FinancingBankField>(16);
            detail.setBankFields(bankFields);
            bankFields.add(new FinancingBankField("PrdNo", PrdNo, ResManager.loadKDString((String)"\u7406\u8d22\u4ea7\u54c1\u4ee3\u7801\u53f7\u3002", (String)"QueryContractNo_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        }
        return new EBBankQueryFinancingDetailResponse(detailList);
    }

    public boolean match(BankQueryFinancingDetailRequest bankQueryFinancingDetailRequest) {
        return false;
    }
}

