/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.ABCBankResponse;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryPacker;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryDetailHelper {
    public static void queryMidBizDetailResult_CQLT19(PaymentInfo[] paymentInfos, String icsSequence, String bizSeqId) {
        try {
            String queryMsg = null;
            try {
                queryMsg = new SalaryPacker().createMidBizDetailResultRequest_CQLT19(icsSequence);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6784\u9020\u67e5\u8be2\u4e2d\u95f4\u4e1a\u52a1\u660e\u7ec6\u5904\u7406\u7ed3\u679c\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38\u3002", (String)"SalaryDetailHelper_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String recvMsg = SalaryHelper.sendAndRecvMessage(queryMsg);
            SalaryDetailHelper.parseMidBizDetailResultRsp(paymentInfos, recvMsg, bizSeqId);
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static void parseMidBizDetailResultRsp(PaymentInfo[] paymentInfo, String recvMsg, String bizSeqId) {
        Element root = ABC_DC_Parser.parseString2Root(recvMsg);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element cmp = root.getChild("Cmp");
            Element cme = root.getChild("Cme");
            String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            String[] splits = ResponseFileUtils.getDetailRspRecords(batchFileName, bizSeqId);
            Integer recordNum = 0;
            String recordNumsString = JDomUtils.getChildText((Element)cme, (String)"RecordNum");
            if (!StrUtil.isEmpty((String)recordNumsString)) {
                recordNum = Integer.parseInt(recordNumsString);
            }
            int fileNum = 7;
            Map<String, ABCBankResponse> stateMap = SalaryDetailHelper.getStatusMap(splits, fileNum, recordNum);
            if (splits.length > 0) {
                for (PaymentInfo info : paymentInfo) {
                    ABCBankResponse response = stateMap.get(info.getBankDetailSeqId());
                    if (null == response) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"SalaryDetailHelper_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                        continue;
                    }
                    if (response.isSuccess() == 1) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryDetailHelper_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if (response.isSuccess() == -1) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryDetailHelper_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"SalaryDetailHelper_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u4e2d\u8bb0\u5f55\u6570\u4e3a\u7a7a\u3002", (String)"SalaryDetailHelper_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e2d\u95f4\u4e1a\u52a1\u660e\u7ec6\u5904\u7406\u7ed3\u679c\u5f02\u5e38,\u5bf9\u5e94\u6d41\u6c34\u53f7:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"SalaryDetailHelper_8", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paymentInfo[0].getBankDetailSeqId()), (String)(rsp.getResponseCode() + "," + rsp.getResponseMessage()));
        }
    }

    public static Map<String, ABCBankResponse> getStatusMap(String[] content, int fileNum, int recordNum) {
        HashMap<String, ABCBankResponse> resultMap = new HashMap<String, ABCBankResponse>();
        for (int i = 0; i < recordNum; ++i) {
            String custNo = "";
            String status = "";
            String bankCode = "";
            String bankMsg = "";
            ABCBankResponse response = null;
            custNo = content[i * fileNum + 5];
            status = content[i * fileNum + 1];
            bankCode = content[i * fileNum + 1];
            bankMsg = content[i * fileNum + 6];
            String[] successCodes = new String[]{"S"};
            String[] failedCodes = new String[]{"E"};
            response = new ABCBankResponse(successCodes, failedCodes);
            response.setSuccess(status);
            response.setResponseCode(bankCode);
            response.setResponseMessage(bankMsg);
            if (StrUtil.isEmpty((String)custNo)) continue;
            resultMap.put(custNo, response);
        }
        return resultMap;
    }

    public static String getTotalAmount(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }
}

