/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.BatchPayPacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.banks.abc.dc.utils.MessageUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPayImpl.class);

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CFRT03";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6.31 \u4ee3\u53d1\u5de5\u8d44-\u519c\u884c\u8d26\u6237  CFRT03", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_salary".equalsIgnoreCase(info.getSubBizType()) && info.is2SameBank() && info.is2Merge() || "pay".equalsIgnoreCase(info.getSubBizType()) && !BankBusinessConfig.isGroupAcntPoolTransfer(info.getAccNo(), info.getIncomeAccNo()) && UseConvertor.isSalary((PaymentInfo)info) && info.is2SameBank() && info.is2Merge();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String bizSeqId = request.getHeader().getBizSeqID();
        PaymentInfo[] infos = paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]);
        PaymentInfo paymentInfo = infos[0];
        String fileName = paymentInfo.getBankBatchSeqId();
        String fileContent = BatchPayPacker.packUploadFile(infos, "CFRT03");
        try {
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileName + "");
            new ABC_DCFileUtil().uploadFile(fileName, fileContent, bizSeqId);
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.log.info(fileContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6:%1$s\u5931\u8d25\u3002", (String)"SalaryPayImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileName), (Throwable)e);
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT03", paymentInfo.getBankBatchSeqId());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)SalaryPayImpl.getTotalAmount(infos));
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"InterBusFlag", (String)"1");
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"SumNum", (String)(infos.length + ""));
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)fileName);
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)paymentInfo.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        Element tulip = JDomUtils.addChild((Element)root, (String)"Tulip");
        Element batchElement = JDomUtils.addChild((Element)tulip, (String)ResManager.loadKDString((String)"\u6279\u5904\u7406", (String)"SalaryPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)batchElement, (String)ResManager.loadKDString((String)"\u6279\u4ea4\u6613\u603b\u91d1\u989d", (String)"SalaryPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)SalaryPayImpl.getTotalAmount(infos));
        JDomUtils.addChild((Element)batchElement, (String)ResManager.loadKDString((String)"\u6279\u4ea4\u6613\u603b\u7b14\u6570", (String)"SalaryPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)(infos.length + ""));
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)MessageUtil.getFixed30PostScript(paymentInfo.getExplanation()));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo[] infos = paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]);
        new SalaryParser().parsePay(infos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }
}

