/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPacker {
    public String packPay(PaymentInfo[] paymentInfos) {
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT03", paymentInfos[0].getBankBatchSeqId());
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"InterBusFlag", (String)"1");
        BigDecimal totalAmt = this.calcAmt(paymentInfos);
        JDomUtils.addChild((Element)cme, (String)"Amt", (String)("" + totalAmt));
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfos[0], false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfos[0].getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfos[0].getCurrency());
        String salaryFileName = SalaryHelper.getSalaryFileName(paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)salaryFileName);
        Element tulip = JDomUtils.addChild((Element)root, (String)"Tulip");
        Element batch = JDomUtils.addChild((Element)tulip, (String)ResManager.loadKDString((String)"\u6279\u5904\u7406", (String)"SalaryPacker_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)batch, (String)ResManager.loadKDString((String)"\u6279\u4ea4\u6613\u603b\u91d1\u989d", (String)"SalaryPacker_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)("" + totalAmt));
        JDomUtils.addChild((Element)batch, (String)ResManager.loadKDString((String)"\u6279\u4ea4\u6613\u603b\u7b14\u6570", (String)"SalaryPacker_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)("" + paymentInfos.length));
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)PaymentUtil.getBankBatchSeqId(paymentInfos[0], ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryPacker_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo[])paymentInfos);
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private BigDecimal calcAmt(PaymentInfo[] paymentInfos) {
        BigDecimal bigdecimal = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            bigdecimal = bigdecimal.add(paymentInfos[i].getAmount().setScale(2, 4));
        }
        return bigdecimal;
    }

    public String createSalaryTranResultRequest_CQRT01(String date) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT01", ABC_DC_BankBatchSeqIdCreator.createSequence("CQRT01"));
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)date);
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)date);
        JDomUtils.addChild((Element)corp, (String)"PersonalFlag", (String)"1");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public String createMidBizDetailResultRequest_CQLT19(String icsSequence) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQLT19", ABC_DC_BankBatchSeqIdCreator.createSequence("CQLT19"));
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"SerialNo", (String)icsSequence);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }
}

