/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringFormater;

public class ABC_DCFilePacker {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");

    public static String createSubmitWagePaymentMessage(PaymentInfo[] paymentInfos) {
        StringBuilder sb = new StringBuilder();
        try {
            BigDecimal totalAmt = new BigDecimal("0.00");
            for (int i = 0; i < paymentInfos.length; ++i) {
                totalAmt = totalAmt.add(paymentInfos[i].getAmount());
            }
            String encoding = RequestContextUtils.getCharset();
            sb.append("00999991450000");
            sb.append("001");
            sb.append("000000");
            sb.append('0');
            sb.append(StringFormater.formatLen((String)ABC_DCFilePacker.convertYuan2CentStr(totalAmt), (int)19, (boolean)true, (char)'0', (String)encoding));
            sb.append(StringFormater.formatLen((String)("" + paymentInfos.length), (int)6, (boolean)true, (char)'0', (String)encoding));
            sb.append(StringFormater.formatLen((String)"0", (int)19, (boolean)true, (char)'0', (String)encoding));
            sb.append(StringFormater.formatLen((String)"0", (int)6, (boolean)true, (char)'0', (String)encoding));
            sb.append(StringFormater.formatLen((String)paymentInfos[0].getAccName(), (int)70, (boolean)false, (char)' ', (String)encoding));
            sb.append(StringFormater.formatLen((String)paymentInfos[0].getAccNo(), (int)32, (boolean)false, (char)' ', (String)encoding));
            sb.append(DateUtil.formatDate((Date)new Date()));
            sb.append(DateUtil.formatDate((Date)new Date()));
            sb.append("000");
            sb.append(StringFormater.formatLen((String)PaymentUtil.getBankBatchSeqId(paymentInfos[0], ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1", (String)"ABC_DCFilePacker_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])), (int)70, (boolean)false, (char)' ', (String)encoding));
            sb.append(StringFormater.formatLen((String)" ", (int)756, (boolean)false, (char)' ', (String)encoding));
            sb.append("\r\n");
            for (int i = 0; i < paymentInfos.length; ++i) {
                sb.append("00999991450000");
                sb.append("001");
                sb.append(StringFormater.formatLen((String)("" + (i + 1)), (int)6, (boolean)true, (char)'0', (String)encoding));
                sb.append('0');
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getIncomeAccName(), (int)70, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getIncomeAccNo(), (int)32, (boolean)false, (char)' ', (String)encoding));
                sb.append('1');
                sb.append(StringFormater.formatLen((String)ABC_DCFilePacker.convertYuan2CentStr(paymentInfos[i].getAmount()), (int)19, (boolean)true, (char)'0', (String)encoding));
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getCurrency(), (int)2, (boolean)true, (char)'0', (String)encoding));
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getExplanation(), (int)70, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)8, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)4, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)8, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)9, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)6, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)6, (boolean)true, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)40, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getExplanation(), (int)70, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)paymentInfos[i].getExplanation(), (int)97, (boolean)false, (char)' ', (String)encoding));
                sb.append(' ');
                sb.append(StringFormater.formatLen((String)" ", (int)17, (boolean)false, (char)' ', (String)encoding));
                sb.append(StringFormater.formatLen((String)" ", (int)537, (boolean)false, (char)' ', (String)encoding));
                sb.append("\r\n");
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5c01\u88c5\u6279\u91cf\u652f\u4ed8\u6587\u4ef6\u5f02\u5e38\uff1a\u3002", (String)"ABC_DCFilePacker_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return sb.toString();
    }

    private static String convertYuan2CentStr(BigDecimal yuan) {
        yuan = yuan.multiply(ONE_HUNDRED);
        yuan = yuan.setScale(0);
        return yuan.toString();
    }
}

