/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.payment.individual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.czccb.dc.service.Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

final class PayParser {
    PayParser() {
    }

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);
        if (StringUtils.isEmpty((String)rspStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u5f97\u62a5\u6587\u4e3a\u7a7a", (String)"PayParser_0", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]));
        }
        BankResponse rsp = Parser.parseResponse(rspStr);
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode()) && !"CCCCCC".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s; \u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"PayParser_8", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        this.setPaymentState(rspStr, paymentInfos[0], rsp);
    }

    public void setPaymentState(String rspStr, PaymentInfo paymentInfo, BankResponse rsp) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1, rspStr.length());
        try {
            Element bankDate = JDomUtils.string2Root((String)body, (String)"UTF-8");
            Element opRep = bankDate.getChild("opRep");
            Element opResult = opRep.getChild("opResult");
            String str_orderState = opResult.getChildTextTrim("orderState");
            paymentInfo.setBankSerialNo(paymentInfo.getBankRefID());
            if ("F".equalsIgnoreCase(str_orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_6", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (String)str_orderState, (String)rsp.getResponseMessage());
            } else if ("S".equalsIgnoreCase(str_orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_1", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (String)str_orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_1", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]));
            } else if ("L".equalsIgnoreCase(str_orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (String)str_orderState, (String)rsp.getResponseMessage());
            } else if (PropertiesConstants.getValue((String)"WAIT_REAUDIT").equalsIgnoreCase(str_orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (String)str_orderState, (String)rsp.getResponseMessage());
            } else if ("CCCCCC".equalsIgnoreCase(rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)str_orderState, (String)rsp.getResponseMessage());
            }
        }
        catch (Exception e) {
            logger.info("\u6784\u9020\u5b57\u8282\u6d41\u5931\u8d25\uff0c", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u62a5\u6587\u5931\u8d25", (String)"PayParser_7", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

