/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SalaryQueryPayImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay,
HXB_DC_Constants {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymenInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("xhj3002");
        sb.append('#');
        sb.append(paymenInfo.getAccNo());
        sb.append('#');
        sb.append(paymenInfo.getPackageId());
        sb.append('#');
        String testTime = RequestContextUtils.getBankParameterValue((String)"TEST_TIME");
        if (!StringUtils.isEmpty((String)testTime)) {
            sb.append(testTime);
        } else {
            sb.append(paymenInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String responseCode = elements[0];
        if ("000000".equals(responseCode)) {
            paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID());
            bankPayRequest.setPaymentInfos(paymentInfos);
            PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
            Map<String, BankResponseResult> bankResponseMap = this.getBankResult(elements);
            for (PaymentInfo info : paymentInfos) {
                String id = info.getIncomeAccNo() + info.getIncomeAccName() + info.getAmount().toString();
                BankResponseResult result = bankResponseMap.get(id);
                if (null == result) continue;
                this.handlePayStatus(info, result.getResponseCode(), result.getBankMessage());
            }
            this.processingBankItemDataHandler(elements);
            PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private Map<String, BankResponseResult> getBankResult(String[] records) {
        HashMap<String, BankResponseResult> resultMap = new HashMap<String, BankResponseResult>(16);
        for (int i = this.detailIndex(); i < records.length - 1; ++i) {
            String[] details = StringUtils.split((String)records[i], (String)"|");
            String status = details[4];
            String statusMsg = details[5];
            BankResponseResult result = new BankResponseResult(status);
            result.setBankMessage(statusMsg);
            result.setSuccessCodes(new String[]{"1"});
            result.setFailedCodes(new String[]{"0"});
            String key = this.getBankDataKey(details);
            result.setId(key);
            resultMap.put(result.getId(), result);
        }
        return resultMap;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj3002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u3002", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    @Override
    public String getBankDataKey(String[] details) {
        String incomeNO = details[1];
        String incomeName = details[2];
        String incomeAmount = details[3];
        return incomeNO + incomeName + new BigDecimal(incomeAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, String[] details) {
        String status = details[4];
        String statusMsg = details[5];
        this.handlePayStatus(tempInfo, status, statusMsg);
    }

    private void handlePayStatus(PaymentInfo tempInfo, String status, String statusMsg) {
        if ("1".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        } else if ("0".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        }
    }

    @Override
    public int detailSize() {
        return 0;
    }

    @Override
    public int detailIndex() {
        return 9;
    }
}

