/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankPaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2ECrossBankTransfer");
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e", (String)"OtherBankPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("B2ECrossBankTransfer", paymentInfo.getBankBatchSeqId());
        Element Map2 = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
        String trsDate = JDomUtils.getChildText((Element)head, (String)"ERPTrsTimestamp").replace("-", "").substring(0, 8);
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"trsDate", (String)trsDate);
        JDomUtils.addChild((Element)Map2, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Map2, (String)"DrecCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Map2, (String)"UnionDeptId", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)Map2, (String)"Priority", (String)(paymentInfo.is2Urgent() ? "0" : "1"));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element list = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List");
            String status = JDomUtils.getChildText((Element)list.getChild("Map"), (String)"ReturnCode");
            String returnMsg = JDomUtils.getChildText((Element)list.getChild("Map"), (String)"ReturnMsg");
            if ("000000".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"OtherBankPaymentImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"OtherBankPaymentImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankPaymentImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5916\u8f6c\u8d26", (String)"OtherBankPaymentImpl_4", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

