/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.payment.salary;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QryPaymentImpl.class);

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EAgentSalaryEntQry");
    }

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("B2EAgentSalaryEntQry", Sequence.gen18Sequence());
        Element Map2 = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        String batchNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"batchNo");
        if (StringUtils.isEmpty((String)batchNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6279\u6b21\u53f7batchNo\u4e3a\u7a7a\u3002", (String)"QrySalPaymentImpl_4", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)Map2, (String)"BatchNo", (String)batchNo);
        JDomUtils.addChild((Element)Map2, (String)"TranDate", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"transDate").replace("-", ""));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        Element body = root.getChild("Body");
        String returnCode = body.getChildTextTrim("ReturnCode");
        String returnMsg = body.getChildTextTrim("ReturnMsg");
        if (StringUtils.isNotEmpty((String)returnCode) && !"000000".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(1);
        for (PaymentInfo info : paymentInfos) {
            String key = info.getAmount() + info.getIncomeAccNo() + info.getIncomeAccName() + PaymentInfoSysFiled.get((PaymentInfo)info, (String)"SqrNbr");
            paymentInfoMap.put(key, info);
            logger.info("\u540c\u6b65\u6570\u636e\u4ea7\u751f\u7684key:" + key);
        }
        List maps = body.getChild("List").getChildren("Map");
        for (Element mapElement : maps) {
            String tranStat = mapElement.getChildTextTrim("TranState");
            String errMsg = mapElement.getChildTextTrim("ErrMsg");
            if ("0".equals(tranStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)this.getPaymentInfo(mapElement, paymentInfoMap, logger), (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalPaymentImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)tranStat, (String)errMsg);
                continue;
            }
            if ("1".equals(tranStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)this.getPaymentInfo(mapElement, paymentInfoMap, logger), (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QrySalPaymentImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)tranStat, (String)errMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)this.getPaymentInfo(mapElement, paymentInfoMap, logger), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)tranStat, (String)errMsg);
        }
        paymentInfoMap.clear();
        return new EBBankPayResponse(paymentInfos);
    }

    private PaymentInfo getPaymentInfo(Element mapElement, Map<String, PaymentInfo> paymentInfoMap, EBGLogger logger) {
        StringBuilder sb = new StringBuilder(mapElement.getChildTextTrim("Amount"));
        sb.append(mapElement.getChildTextTrim("PayeeAcNo"));
        sb.append(mapElement.getChildTextTrim("PayeeAcName"));
        String sqrNbr = String.format("%012d", Integer.valueOf(mapElement.getChildTextTrim("SqrNbr")));
        sb.append(sqrNbr);
        logger.info("\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4ea7\u751f\u7684key:", (Object)sb.toString());
        return paymentInfoMap.get(sb.toString());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EAgentSalaryEntQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u67e5\u8be2", (String)"QrySalPaymentImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }
}

