/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import java.io.File;
import java.util.List;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.common.framework.handler.AbstractBizHandler;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.AbstractMT940Handler;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.aqap.proxy.oversea.utils.OverseaSFTPUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBizScheduleJob
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractBizScheduleJob.class);

    protected void downLoadFile(String bankVersion) {
        String downloadFileTempPath = OverseaFileStorageUtil.getDownloadFileTempPath(bankVersion);
        OverseaSFTPUtils.getInstance().downloadAllFiles(downloadFileTempPath, "");
    }

    protected void fileSaveAs(String bankVersion, List<AbstractBizHandler> handlers) {
        String downloadFileTempPath = OverseaFileStorageUtil.getDownloadFileTempPath(bankVersion);
        String mt940Dir = OverseaFileStorageUtil.getMT940FilePath(bankVersion);
        String mt942Dir = OverseaFileStorageUtil.getMT942FilePath(bankVersion);
        String paymentXMLAckFileDir = OverseaFileStorageUtil.getXmlAckFilePath(bankVersion);
        File tempFile = FileCommonUtils.getFileByPath((String)downloadFileTempPath);
        File[] downloadFiles = tempFile.listFiles();
        if (downloadFiles != null && downloadFiles.length > 0) {
            AbstractACKHandler abstractACKHandler = null;
            AbstractMT940Handler abstractMT940Handler = null;
            AbstractMT942Handler abstractMT942Handler = null;
            for (AbstractBizHandler handler : handlers) {
                if (AbstractACKHandler.class.isAssignableFrom(handler.getClass())) {
                    abstractACKHandler = (AbstractACKHandler)handler;
                    continue;
                }
                if (AbstractMT940Handler.class.isAssignableFrom(handler.getClass())) {
                    abstractMT940Handler = (AbstractMT940Handler)handler;
                    continue;
                }
                if (!AbstractMT942Handler.class.isAssignableFrom(handler.getClass())) continue;
                abstractMT942Handler = (AbstractMT942Handler)handler;
            }
            for (File f : downloadFiles) {
                if (!f.isFile()) continue;
                String fileName = f.getName();
                String desFileDir = "";
                if (abstractMT940Handler != null && abstractMT940Handler.isNeedToProcessFile(fileName)) {
                    desFileDir = mt940Dir;
                } else if (abstractMT942Handler != null && abstractMT942Handler.isNeedToProcessFile(fileName)) {
                    desFileDir = mt942Dir;
                } else if (abstractACKHandler != null && abstractACKHandler.isNeedToProcessFile(fileName)) {
                    desFileDir = paymentXMLAckFileDir;
                }
                if (StringUtils.isEmpty((String)desFileDir)) continue;
                if (OverseaFileStorageUtil.cutFile(f, desFileDir)) {
                    this.logger.info("\u79fb\u52a8\u6587\u4ef6" + f.getName() + "\u5230\u76ee\u5f55" + desFileDir + "\u6210\u529f");
                    continue;
                }
                this.logger.error("\u79fb\u52a8\u6587\u4ef6" + f.getName() + "\u5931\u8d25");
            }
        }
    }
}

