/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.aqap.proxy.oversea.repository.OverseaDetailRepository;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class OverseaDBHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaDBHelper.class);

    public static void updateDetailAndPayStateAndBalanceFromMT940(List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        try (TXHandle h = TX.requiresNew();){
            OverseaDBHelper.updateDetailFromMT940(detailInfoList);
            OverseaDBHelper.updatePayInfos(payInfoList);
            OverseaDBHelper.updateBalanceMt940(balanceInfoList);
        }
    }

    private static void updateDetailFromMT940(List<OverseaDetail> detailInfoList) {
        if (CollectionUtil.isEmpty(detailInfoList)) {
            if (CollectionUtil.isEmpty(detailInfoList)) {
                logger.info("\u5f85\u66f4\u65b0\u5386\u53f2\u660e\u7ec6\u4e3a\u7a7a");
                return;
            }
            return;
        }
        OverseaDetailRepository overseaDetailRepository = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        overseaDetailRepository.updateDetailFromMT940(detailInfoList);
    }

    public static void updatePayInfos(List<PaymentInfo> payInfoList) {
        if (CollectionUtil.isEmpty(payInfoList)) {
            return;
        }
        for (PaymentInfo paymentInfo : payInfoList) {
            if (PaymentState.SUCCESS.getId() != paymentInfo.getStatus().intValue()) continue;
            paymentInfo.setUpdateOperation(UpdateOpState.DETAIL_SYNC_PAY_SUCCESS.getId());
        }
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        paymentInfoRepository.updateAll(payInfoList);
    }

    private static void updateBalanceMt940(List<OverseaBalance> balanceInfoList) {
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        overseaBalanceRepository.updateBalanceMt940(balanceInfoList);
    }

    public static void updateDetailAndPayStateAndBalanceFromMT942(List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        try (TXHandle h = TX.requiresNew();){
            OverseaDBHelper.updateDetailFromMT942(detailInfoList);
            OverseaDBHelper.updatePayInfos(payInfoList);
            OverseaDBHelper.updateBalanceMt942(balanceInfoList);
        }
    }

    private static void updateBalanceMt942(List<OverseaBalance> balanceInfoList) {
        if (CollectionUtil.isEmpty(balanceInfoList)) {
            logger.info("\u5f85\u66f4\u65b0\u4f59\u989d\u8bb0\u5f55\u4e3a\u7a7a");
            return;
        }
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        overseaBalanceRepository.updateBalanceMt942(balanceInfoList);
    }

    private static void updateDetailFromMT942(List<OverseaDetail> detailInfoList) {
        if (CollectionUtil.isEmpty(detailInfoList)) {
            logger.info("\u5f85\u66f4\u65b0\u5f53\u65e5\u660e\u7ec6\u4e3a\u7a7a");
            return;
        }
        OverseaDetailRepository overseaDetailRepository = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        overseaDetailRepository.updateDetailFromMT942(detailInfoList);
    }

    public static List<PaymentInfo> getPaymentInfoByBatchId(String batchId) {
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        List list = paymentInfoRepository.findByBankBatchSeqID(batchId);
        return list;
    }

    public static PaymentInfo getPaymentInfoByBankDetailSeqId(String bankDetailSeqId) {
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        return paymentInfoRepository.findByBankDetailSeqID(bankDetailSeqId);
    }
}

