/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CCB_DC_Packer {
    public static Element createTransactionHeader(String tx_code, String request_sn) throws EBServiceException {
        Element element = new Element("TX");
        JDomUtils.addChild((Element)element, (String)"REQUEST_SN", (String)request_sn);
        String custid = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        String userid = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String password = RequestContextUtils.getBankParameterValue((String)"PASSWORD");
        JDomUtils.addChild((Element)element, (String)"CUST_ID", (String)custid);
        JDomUtils.addChild((Element)element, (String)"USER_ID", (String)userid);
        JDomUtils.addChild((Element)element, (String)"PASSWORD", (String)password);
        JDomUtils.addChild((Element)element, (String)"TX_CODE", (String)tx_code);
        JDomUtils.addChild((Element)element, (String)"LANGUAGE", (String)"CN");
        return element;
    }

    public static String packAll2XML(Element header, Element txInfo) throws EBServiceException {
        JDomUtils.addChild((Element)header, (Element)txInfo);
        String encoding = EBContext.getContext().getCharsetName();
        String xml = JDomUtils.root2String((Element)header, (String)encoding);
        return xml;
    }

    public static String getExplain(PaymentInfo info) throws EBServiceException {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            return info.getBankDetailSeqId() + "_KD_" + info.getExplanation();
        }
        return info.getExplanation();
    }

    public static void checkCurrency(BankBalanceRequest request, boolean isCheckAccountCurrency) {
        String accountCurrency = request.getAcnt().getCurrency();
        String accountBankCurrency = CurrencyUtils.convert2Bank((String)accountCurrency);
        if (StringUtils.isEmpty((String)accountBankCurrency)) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u7248\u672c\u5e01\u79cd\u8f6c\u5316\u94f6\u884c\u5e01\u79cd\u4e3a\u7a7a", (String)"CCB_DC_Packer_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        if (isCheckAccountCurrency && !accountBankCurrency.equals(request.getBankCurrency())) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u7248\u672c\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u6237\u3002", (String)"CCB_DC_Packer_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
    }
}

