/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.balance.FixedBalancePacker;
import kd.ebg.aqap.banks.ccb.dc.services.balance.FixedBalancePage;
import kd.ebg.aqap.banks.ccb.dc.services.balance.FixedBalanceParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(FixedBalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) throws EBServiceException {
        CCB_DC_Packer.checkCurrency(rqst, false);
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(1);
        ArrayList<String> balanceStrList = new ArrayList<String>(1);
        FixedBalancePage balancePage = new FixedBalancePage();
        FixedBalancePacker packer = new FixedBalancePacker();
        FixedBalanceParser balanceParser = new FixedBalanceParser();
        try {
            int pageTag = balancePage.getFirstPageTag();
            String rspStr = null;
            do {
                String rqstStr = packer.pack(rqst, pageTag);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(conn);){
                        rspStr = this.recv(is);
                        balanceStrList.addAll(balanceParser.parse(rqst, rspStr));
                        pageTag = balancePage.getNextPageTag(pageTag);
                    }
                }
            } while (!balancePage.isLastPage(rspStr, 20));
            BigDecimal balance = new BigDecimal("0.0");
            if (CollectionUtil.isNotEmpty(balanceStrList)) {
                for (String balanceStr : balanceStrList) {
                    balance = balance.add(new BigDecimal(balanceStr));
                }
            }
            this.logger.info("\u5b9a\u671f\u6237{}\u603b\u4f59\u989d\u4e3a{}", new Object[]{rqst.getAcnt().getAccNo(), balance});
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankCurrency(rqst.getBankCurrency());
            balanceInfo.setCurrentBalance(balance);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfo.setBankAcnt(rqst.getAcnt());
            hisBalanceList.add(balanceInfo);
            return new EBBankBalanceResponse(hisBalanceList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public boolean match(BankBalanceRequest request) {
        return BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "6WD401";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d", (String)"FixedBalanceImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }
}

