/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balancereconciliation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    public int getMonthSpan() {
        return 3;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("6WA001", request_sn);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"PAGE_NO", (String)"");
        Element list = JDomUtils.addChild((Element)txInfo, (String)"LIST");
        JDomUtils.addChild((Element)list, (String)"ACCT_NO", (String)bankBalanceStatementRequest.getAccNo());
        JDomUtils.addChild((Element)list, (String)"BEGIN_DATE", (String)bankBalanceStatementRequest.getStartMonth());
        JDomUtils.addChild((Element)list, (String)"END_DATE", (String)bankBalanceStatementRequest.getEndMonth());
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String responseMessage = response.getResponseMessage();
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(5);
        if ("000000".equalsIgnoreCase(rspCode)) {
            Element txInfo = root.getChild("TX_INFO");
            List list = txInfo.getChildren("LIST");
            for (Element element : list) {
                String check_flag = JDomUtils.getChildText((Element)element, (String)"CHECK_FLAG");
                if (!"2".equalsIgnoreCase(check_flag)) continue;
                String bill_no = JDomUtils.getChildText((Element)element, (String)"BILL_NO");
                String bill_date = JDomUtils.getChildText((Element)element, (String)"BILL_DATE");
                String coin_type = JDomUtils.getChildText((Element)element, (String)"COIN_TYPE");
                String curr_bal = JDomUtils.getChildText((Element)element, (String)"CURR_BAL");
                BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
                detail.setAccNo(bankBalanceStatementRequest.getAccNo());
                detail.setCurrency(coin_type);
                detail.setMonth(bill_date.substring(0, 6));
                detail.setBalance(curr_bal);
                detail.setStatementNo(bill_no);
                detailList.add(detail);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"BalanceStatementImpl_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), rspCode, responseMessage));
        }
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WA001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u6237\u5bf9\u8d26\u5355\u67e5\u8be2\u4ea4\u6613", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

