/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Constants;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.CCB_DCFileUtil;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelper;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelperFactory;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class QueryPayParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        if ("000000".equalsIgnoreCase(rspCode)) {
            Element txInfo = root.getChild("TX_INFO");
            String fStatus = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"F_STATUS");
            String fMsg = txInfo.getChildTextTrim("F_MSG");
            if (StringUtils.isEmpty((String)fMsg)) {
                fMsg = CCB_DC_Constants.Status_OF_6W2104.get(fStatus);
            }
            if ("0".equalsIgnoreCase(fStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u5931\u8d25", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)fStatus, (String)fMsg);
            } else if ("1".equalsIgnoreCase(fStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u5b8c\u6210", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)fStatus, (String)fMsg);
            } else if ("2".equalsIgnoreCase(fStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)fStatus, (String)fMsg);
            } else if ("3".equalsIgnoreCase(fStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u7f51\u94f6\u5ba1\u6279\u4e2d", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)fStatus, (String)fMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u94f6\u884c\u72b6\u6001\u7801:%s\u3002", (String)"QueryPayParser_11", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), fStatus), (String)fStatus, (String)fMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u94f6\u884c\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"QueryPayParser_12", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), rspCode), (String)rspCode, (String)response.getResponseMessage());
        }
    }

    public void parseQueryPay6W0111(PaymentInfo[] paymentInfos, String rspStr6W0111, String rspStr6W2104) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr6W0111);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        if ("000000".equalsIgnoreCase(rspCode)) {
            boolean isUsedXmlParsePayStatus;
            Element rspRoot6W2104 = CCB_DC_Parser.parseString2Root(rspStr6W2104);
            Element rspTxInfo = rspRoot6W2104.getChild("TX_INFO");
            String fileName = ParserUtils.checkUnNullableElement((Element)rspTxInfo, (String)"FILE_A");
            String batchPayFileType = BankBusinessConfig.getBatchPayFileType(paymentInfos[0].getAccNo());
            boolean bl = isUsedXmlParsePayStatus = "sichuan".equalsIgnoreCase(batchPayFileType) && this.parseXmlPayStatus(rspTxInfo, paymentInfos);
            if (!isUsedXmlParsePayStatus) {
                this.logger.info("\u4f7f\u7528\u6587\u4ef6\u89e3\u6790\u4ed8\u6b3e\u72b6\u6001");
                String fileContent = new CCB_DCFileUtil().downloadFile(fileName);
                FileHelper fileHelper = FileHelperFactory.createFileHelper(batchPayFileType);
                RequestContextUtils.setRunningParam((String)"ccb_bank_batch_id", (String)paymentInfos[0].getBankBatchSeqID());
                Map resultMap = fileHelper.parseFileContent(fileContent);
                for (PaymentInfo paymentInfo : paymentInfos) {
                    String id = fileHelper.genKey(paymentInfo);
                    if (resultMap.containsKey(id) || resultMap.containsKey(paymentInfo.getBankBatchSeqID())) {
                        String status = (String)resultMap.get(id);
                        if ("SUCCESS".equalsIgnoreCase(status)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)status);
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u672a\u77e5\u4ea4\u6613\u60c5\u51b5", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)"", (String)"");
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)rspCode, (String)response.getResponseMessage());
        }
    }

    private boolean parseXmlPayStatus(Element rspTxInfo, PaymentInfo[] paymentInfos) {
        boolean isAllUpdate;
        this.logger.info("\u4f7f\u7528\u62a5\u6587\u89e3\u6790\u4ed8\u6b3e\u72b6\u6001");
        List successList = rspTxInfo.getChildren("SUCCESS_LIST");
        List failList = rspTxInfo.getChildren("FAIL_LIST");
        List unKnownList = rspTxInfo.getChildren("UNCERTAIN_LIST");
        boolean bl = isAllUpdate = CollectionUtil.isNotEmpty((Collection)successList) || CollectionUtil.isNotEmpty((Collection)failList) || CollectionUtil.isNotEmpty((Collection)unKnownList);
        if (isAllUpdate) {
            isAllUpdate = this.parseListPayStatus(successList, paymentInfos, PaymentState.SUCCESS);
        }
        if (isAllUpdate) {
            isAllUpdate = this.parseListPayStatus(failList, paymentInfos, PaymentState.FAIL);
        }
        if (isAllUpdate) {
            isAllUpdate = this.parseListPayStatus(unKnownList, paymentInfos, PaymentState.UNKNOWN);
        }
        return isAllUpdate;
    }

    private boolean parseListPayStatus(List<Element> nodeList, PaymentInfo[] paymentInfos, PaymentState toUpdate) {
        for (Element node : nodeList) {
            String memo1 = node.getChildTextTrim("FILE_MEMO1");
            String memo2 = node.getChildTextTrim("FILE_MEMO2");
            String status = node.getChildTextTrim("STATUS");
            String remark = node.getChildTextTrim("REMARK");
            PaymentInfo paymentInfo = this.getPaymentInfoByID(paymentInfos, memo1, memo2);
            if (paymentInfo != null) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)toUpdate, (String)"", (String)status, (String)remark);
                continue;
            }
            return false;
        }
        return true;
    }

    private PaymentInfo getPaymentInfoByID(PaymentInfo[] paymentInfos, String memo1, String memo2) {
        for (PaymentInfo paymentInfo : paymentInfos) {
            if (paymentInfo.getId().equalsIgnoreCase(memo1) || paymentInfo.getBankDetailSeqID().equalsIgnoreCase(memo1)) {
                return paymentInfo;
            }
            if (!paymentInfo.getId().equalsIgnoreCase(memo2) && !paymentInfo.getBankDetailSeqID().equalsIgnoreCase(memo2)) continue;
            return paymentInfo;
        }
        return null;
    }
}

