/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("NW3402", request_sn);
        Element txInfo = JDomUtils.addChild((Element)header, (String)"TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"CstPty_TxnSrlNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)txInfo, (String)"Btch_Dtl_ID", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)header, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equalsIgnoreCase(response.getResponseCode())) {
            Element txInfo = root.getChild("TX_INFO");
            String CshMgt_Txn_Rslt_Cd = txInfo.getChildTextTrim("CshMgt_Txn_Rslt_Cd");
            String Err_Inf = txInfo.getChildTextTrim("CshMgt_Txn_Rslt_Cd");
            if ("1".equals(CshMgt_Txn_Rslt_Cd)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentParser_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)CshMgt_Txn_Rslt_Cd, (String)Err_Inf);
            } else if ("2".equals(CshMgt_Txn_Rslt_Cd)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentParser_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)CshMgt_Txn_Rslt_Cd, (String)Err_Inf);
            } else if ("3".equals(CshMgt_Txn_Rslt_Cd)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)Err_Inf);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"PayParser_95", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), response.getResponseCode()), (String)response.getResponseCode(), (String)Err_Inf);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"PayParser_95", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), response.getResponseCode()), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "NW3402";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5916\u6c47\u6c47\u6b3e\u5355\u7b14\u660e\u7ec6\u67e5\u8be2", (String)"QueryPaymentImpl_100", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }
}

