/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services;

import java.util.Date;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static final String entrustSeqNoKey = "entrustSeqNo";

    public static String packToReqMsg(String txCode, String signature) {
        Element packet = new Element("packet");
        Element head = JDomUtils.addChild((Element)packet, (String)"head");
        JDomUtils.addChild((Element)head, (String)"transCode", (String)txCode);
        JDomUtils.addChild((Element)head, (String)"signFlag", (String)"1");
        JDomUtils.addChild((Element)head, (String)"masterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        JDomUtils.addChild((Element)head, (String)"packetID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"timeStamp", (String)DateUtil.formatDate4Persion((Date)new Date()));
        Element body = JDomUtils.addChild((Element)packet, (String)"body");
        JDomUtils.addChild((Element)body, (String)"signature", (String)signature);
        String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)RequestContextUtils.getCharset());
        String encoding = RequestContextUtils.getCharset();
        String length = "" + (StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6);
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringLength.fixedLength((String)length, (String)" ", (int)6));
        buffer.append(msg);
        return buffer.toString();
    }

    public static void setEntrustSeqNo(PaymentInfo[] payInfos, String entrustSeqNo) {
        int len = payInfos.length;
        for (int i = 0; i < len; ++i) {
            payInfos[i].setBankRefID(entrustSeqNo);
        }
    }

    public static String getEntrustSeqNo(PaymentInfo payInfo) {
        return payInfo.getBankRefID();
    }
}

