/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.batch;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.Constants;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.batch.QueryPayPage;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBatchPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBatchPayImpl.class);

    public int getBatchSize() {
        return 400;
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String pageTag = QueryPayPage.getFirstPageTag();
        this.setCurrentPage(pageTag);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            this.doBiz(request);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getAccNo());
        LocalDateTime submitSuccessTime = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime();
        if (submitSuccessTime == null) {
            submitSuccessTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)submitSuccessTime.minusDays(15L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String acceptNo = ((PaymentInfo)paymentInfos.get(0)).getBankRefID();
        if (StringUtils.isEmpty((String)acceptNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u53d7\u7406\u7f16\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u3002", (String)"QueryBatchPayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"acceptNo", (String)acceptNo);
        JDomUtils.addChild((Element)body, (String)"serialNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)Constants.QUERY_8805_PAGE_COUNT.toString());
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"singleOrBatchFlag", (String)"1");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("8805", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String pageTag = this.getCurrentPage();
        String nextPageTag = QueryPayPage.getNextPageTag(pageTag);
        this.setCurrentPage(nextPageTag);
        boolean lastPage = QueryPayPage.isLastPage(rspStr, pageTag);
        this.setLastPage(lastPage);
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String totalCount = body.getChildText("totalCount");
            String count = body.getChildText("count");
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u7b14\u6570:" + totalCount);
            if (!totalCount.equals("0") && !count.equals("0")) {
                Element listsElement = body.getChild("lists");
                if (null == listsElement) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7b14\u6570\u4e3a0\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002\u53ef\u80fd\u662f\u63d0\u4ea4\u4ed8\u6b3e\u5931\u8d25\uff0c\u5efa\u8bae\u8fc7\u4e00\u6bb5\u65f6\u95f4\u67e5\u7f51\u94f6\u8bb0\u5f55\u6765\u786e\u5b9a\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                } else {
                    List lists = listsElement.getChildren("list");
                    int length = lists.size();
                    if (0 == length) {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7b14\u6570\u4e3a0\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002\u53ef\u80fd\u662f\u63d0\u4ea4\u4ed8\u6b3e\u5931\u8d25\uff0c\u5efa\u8bae\u8fc7\u4e00\u6bb5\u65f6\u95f4\u67e5\u7f51\u94f6\u8bb0\u5f55\u6765\u786e\u5b9a\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    } else {
                        this.logger.info("\u542b\u6709\u5faa\u73af\u8282\u70b9");
                    }
                    for (int i = 0; i < length; ++i) {
                        Element element = (Element)lists.get(i);
                        String detailedContent = element.getChildText("detailedContent");
                        String[] detaile = detailedContent.split("\\|");
                        String bankDeatilSeqId = detaile[0];
                        String incomeAccno = detaile[8];
                        PaymentInfo payment = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankDeatilSeqId);
                        if (payment == null) {
                            this.logger.info("\u6839\u636e\u6d41\u6c34\u53f7{}\u672a\u627e\u5230\u4ed8\u6b3e\u8bb0\u5f55", (Object)bankDeatilSeqId);
                            continue;
                        }
                        String transStatus = detaile[16];
                        this.logger.info("\u5faa\u73af\u6570\uff1a" + i + "----" + transStatus + "--------" + incomeAccno);
                        String note = detaile[15];
                        if ("0".equalsIgnoreCase(transStatus) || "1".equalsIgnoreCase(transStatus) || "2".equalsIgnoreCase(transStatus) || "3".equalsIgnoreCase(transStatus)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)(StringUtils.isEmpty((String)note) ? ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]) : note));
                            continue;
                        }
                        if ("4".equalsIgnoreCase(transStatus)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryBatchPayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)note);
                            continue;
                        }
                        if ("8".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryBatchPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)(StringUtils.isEmpty((String)note) ? ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryBatchPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]) : note));
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5'\u4ea4\u6613\u72b6\u6001'\u7801'%s',\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryBatchPayImpl_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transStatus), (String)transStatus, (String)(StringUtils.isEmpty((String)note) ? ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryBatchPayImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]) : note));
                    }
                }
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "8805";
    }

    public String getBizDesc() {
        return null;
    }
}

