/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.PayTimeUtils;
import kd.ebg.aqap.banks.spdb.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8801";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8, \u5355\u7b14\u652f\u4ed8", (String)"CompanyPaymentImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay".equalsIgnoreCase(info.getSubBizType()) && !info.is2Individual() && !UseConvertor.isTransfer((PaymentInfo)info) || UseConvertor.isTransfer((PaymentInfo)info) && BankBusinessConfig.isTransferToCompany() != false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"acctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"bespeakDate", (String)"");
        JDomUtils.addChild((Element)body, (String)"payeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"payeeType", (String)"0");
        JDomUtils.addChild((Element)body, (String)"payeeBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"payeeAddress", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        String remitLocation = "";
        String sysFlag = "";
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"sysFlag", (String)"0");
            sysFlag = "0";
            if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("3")) {
                remitLocation = "1";
            }
            JDomUtils.addChild((Element)body, (String)"remitLocation", (String)remitLocation);
        } else {
            sysFlag = "1";
            JDomUtils.addChild((Element)body, (String)"sysFlag", (String)"1");
            if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("1")) {
                if (paymentInfo.is2SameCity() && PayTimeUtils.isSameCityPayTime()) {
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"0");
                    remitLocation = "0";
                } else {
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
                    remitLocation = "1";
                }
            } else if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("2")) {
                if (paymentInfo.is2SameCity()) {
                    remitLocation = "0";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"0");
                } else {
                    remitLocation = "1";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
                }
            } else {
                remitLocation = "1";
                JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
            }
            if ("1".equals(remitLocation) && "1".equals(sysFlag)) {
                String payeeBankSelectFlag = "1";
                String payeeBankNo = paymentInfo.getIncomeCnaps();
                JDomUtils.addChild((Element)body, (String)"payeeBankNo", (String)payeeBankNo);
                JDomUtils.addChild((Element)body, (String)"payeeBankSelectFlag", (String)payeeBankSelectFlag);
            }
        }
        JDomUtils.addChild((Element)body, (String)"note", (String)CommonUtils.getExplanation(paymentInfo));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("8801", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if ("EYY8968".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEYY8968\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"CompanyPaymentImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EGG0044".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEGG0044\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"CompanyPaymentImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EYY8804".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEYY8804\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"CompanyPaymentImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EGG0982".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEGG0982\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"CompanyPaymentImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String transStatus = ParserUtils.getUnNullElementTextValue((Element)body, (String)"transStatus", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"CompanyPaymentImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            String acceptNo = ParserUtils.getUnNullElementTextValue((Element)body, (String)"acceptNo", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u53d7\u7406\u7f16\u53f7", (String)"CompanyPaymentImpl_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            if ("0".equalsIgnoreCase(transStatus) || "1".equalsIgnoreCase(transStatus) || "2".equalsIgnoreCase(transStatus) || "3".equalsIgnoreCase(transStatus) || "8".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPaymentImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)"");
            } else if ("4".equalsIgnoreCase(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPaymentImpl_9", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPaymentImpl_9", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u4ea4\u6613\u72b6\u6001\u7801%s\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"CompanyPaymentImpl_13", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transStatus), (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"CompanyPaymentImpl_12", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

