/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.utils;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.DateUtil;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.HeaderUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PackerUtil {
    public static final String getPackedStr(String transCode, Element root) throws EBServiceException {
        String charsetName = RequestContextUtils.getCharset();
        String requestXML = JDomUtils.element2StringPlain((Element)root, (String)charsetName);
        String frontHeader = HeaderUtil.createFrontHead(transCode, requestXML, charsetName);
        StringBuilder builder = new StringBuilder();
        builder.append(frontHeader).append(requestXML);
        return builder.toString();
    }

    public static final void setSignPlainText(Element body, String str) throws EBServiceException {
        Element signNode = JDomUtils.getChildElement((Element)body, (String)"SIGDAT");
        if (null == signNode) {
            signNode = JDomUtils.addChild((Element)body, (String)"SIGDAT");
        }
        signNode.setText(str);
    }

    public static final Element buildRoot(Element body, String sequnce) throws EBServiceException {
        Element root = JDomUtils.createRoot((String)"msg");
        JDomUtils.addChild((Element)root, (Element)PackerUtil.createTransHeader(sequnce));
        JDomUtils.addChild((Element)root, (Element)body);
        JDomUtils.addChild((Element)root, (String)"rmk_data");
        return root;
    }

    public static final Element buildRoot(Element body) throws EBServiceException {
        return PackerUtil.buildRoot(body, null);
    }

    public static final Element createTransHeader(String sequnce) throws EBServiceException {
        Element head = JDomUtils.createRoot((String)"comm_head");
        JDomUtils.addChild((Element)head, (String)"ver_no", (String)"1.0");
        JDomUtils.addChild((Element)head, (String)"reserve", (String)"");
        JDomUtils.addChild((Element)head, (String)"reserve1", (String)"");
        JDomUtils.addChild((Element)head, (String)"reserve2", (String)"");
        JDomUtils.addChild((Element)head, (String)"ext_txn_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"chnl_dt", (String)DateUtil.formatDate(new Date()));
        JDomUtils.addChild((Element)head, (String)"host_dt", (String)DateUtil.formatDate(new Date()));
        JDomUtils.addChild((Element)head, (String)"chnl_tm", (String)DateUtil.formatTime(new Date()));
        JDomUtils.addChild((Element)head, (String)"host_tm", (String)DateUtil.formatTime(new Date()));
        if (StringUtils.isEmpty((String)sequnce)) {
            JDomUtils.addChild((Element)head, (String)"chnl_seq", (String)Sequence.genSequence());
        } else {
            JDomUtils.addChild((Element)head, (String)"chnl_seq", (String)sequnce);
        }
        JDomUtils.addChild((Element)head, (String)"host_seq", (String)"");
        JDomUtils.addChild((Element)head, (String)"rsp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"rsp_msg", (String)"");
        return head;
    }

    public static final Element buildBody() throws EBServiceException {
        Element body = JDomUtils.createRoot((String)"main_data");
        JDomUtils.addChild((Element)body, (String)"USERID", (String)RequestContextUtils.getBankParameterValue((String)"userNo"));
        JDomUtils.addChild((Element)body, (String)"SIGDAT");
        return body;
    }

    public static String getQueryPaymentStr(PaymentInfo[] paymentInfos) throws EBServiceException {
        PaymentInfo info = paymentInfos[0];
        String queryDateStr = RequestContextUtils.getBankParameterValue((String)"test_transDate");
        if (StringUtils.isEmpty((String)queryDateStr)) {
            if (info.getSubmitSuccessTime() == null) {
                throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671fJIOYRQ\u4e3a\u7a7a\u3002", (String)"PackerUtil_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]));
            }
            queryDateStr = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        Element body = PackerUtil.buildBody();
        JDomUtils.addChild((Element)body, (String)"JIOYRQ", (String)queryDateStr);
        JDomUtils.addChild((Element)body, (String)"QANTLS", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"BEIY01", (String)"");
        JDomUtils.addChild((Element)body, (String)"BEIY02", (String)"");
        StringBuilder builder = new StringBuilder();
        builder.append(RequestContextUtils.getBankParameterValue((String)"userNo")).append("|").append(queryDateStr).append("|").append(info.getBankBatchSeqId());
        PackerUtil.setSignPlainText(body, builder.toString());
        return PackerUtil.getPackedStr("YQ267", PackerUtil.buildRoot(body));
    }
}

