/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.balance;

import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.aqap.proxy.oversea.utils.FileContentWriterUtil;
import kd.ebg.aqap.proxy.oversea.utils.GetKeyStoreHelper;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.aqap.proxy.oversea.utils.OverseaSFTPUtils;
import kd.ebg.aqap.proxy.oversea.utils.PgpHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.sdk.ebg.trd.proxy.pgp.SDKPrivateKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKPublicKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKey;
import org.apache.commons.io.IOUtils;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String key = "scb_balance_" + request.getBankCurrency() + "_" + acnt.getAccNo();
        if (!CachePayStorage.checkSubmitLock((String)key)) {
            this.uploadQueryBalanceFile(request);
        }
        EBContext context = EBContext.getContext();
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        OverseaBalance balance = overseaBalanceRepository.getLastestBalance(acnt.getAccNo(), context.getCustomID(), context.getBankVersionID(), request.getBankCurrency());
        if (balance == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u786e\u8ba4\u94f6\u884c\u662f\u5426\u63a8\u9001\u4e86\u5bf9\u5e94\u7684\u6587\u4ef6\u6570\u636e\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setCurrentBalance(balance.getCurrentBalance());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setAvailableBalance(balance.getAvailableBalance());
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setBalanceDateTime(balance.getBalanceDate());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    private void uploadQueryBalanceFile(BankBalanceRequest request) {
        String filePath;
        block30: {
            StringBuilder sb = new StringBuilder();
            sb.append(Sequence.gen8Sequence()).append(",");
            BankAcnt acnt = request.getAcnt();
            String country = acnt.getCountry();
            CountryISOCode countryISOCode = ISOCountryUtils.getInstance().getCountryInfoByName(country);
            if (countryISOCode == null) {
                this.logger.info("\u6839\u636e\u8d26\u6237\u7684country:" + country + "\u672a\u627e\u5230\u5bf9\u5e94\u56fd\u5bb6\u4ee3\u7801");
                return;
            }
            sb.append(countryISOCode.geteChart2()).append(",").append(acnt.getAccNo()).append(",").append(request.getBankCurrency()).append(",").append(LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))).append(",").append(LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))).append(",").append("N");
            String originalFilePath = OverseaFileStorageUtil.getOverseaIgnoreFilePath((String)EBContext.getContext().getBankVersionID());
            String prefix = RequestContextUtils.getBankParameterValue((String)"ftp_user_name");
            String filename = prefix + "." + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "_" + Sequence.gen8Sequence() + ".H2H-501-AERQ";
            filePath = originalFilePath + File.separator + filename;
            this.logger.info("\u6e23\u6253\u4f59\u989d\u8bf7\u6c42\u6587\u4ef6\u540d:" + filename);
            String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
            try {
                if ("true".equalsIgnoreCase(needPgp)) {
                    this.encryBalanceFile(sb.toString(), filename);
                    break block30;
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(FileCommonUtils.checkPath((String)filePath));
                     OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOutputStream, RequestContextUtils.getCharset());){
                    out.write(sb.toString());
                    out.flush();
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f59\u989d\u8bf7\u6c42\u6587\u4ef6\u751f\u6210\u5f02\u5e38", (Throwable)e);
                return;
            }
        }
        try {
            ChannelSftp sftp = OverseaSFTPUtils.getInstance().connect();
            this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u4f59\u989d\u8bf7\u6c42\u6587\u4ef6\uff1a" + filePath);
            OverseaSFTPUtils.getInstance().upload(filePath, sftp);
        }
        catch (Throwable e) {
            this.logger.error("\u4e0a\u4f20\u4f59\u989d\u8bf7\u6c42\u6587\u4ef6\u5f02\u5e38", e);
        }
    }

    private void encryBalanceFile(String content, String filename) throws Exception {
        String originPath;
        File originFile;
        String pgpPublicKey = GetKeyStoreHelper.getPgpPublicKey((String)"bank_pgp_public_key");
        String pgpPrivateKey = GetKeyStoreHelper.getPgpPrivateKey((String)"custom_pgp_private_key");
        char[] password = RequestContextUtils.getBankParameterValue((String)"custom_pgp_private_key_ciper").toCharArray();
        PgpHelper pgp = PgpHelper.getInstance();
        SDKSecretKey secretKey = pgp.readSecretKey(IOUtils.toInputStream((String)pgpPrivateKey, (String)RequestContextUtils.getCharset()));
        SDKPrivateKey prKey = pgp.findSecretKey(secretKey, password);
        SDKPublicKey puKey = pgp.readPublicKey(IOUtils.toInputStream((String)pgpPublicKey, (String)RequestContextUtils.getCharset()));
        EBContext context = EBContext.getContext();
        String dir = OverseaFileStorageUtil.getOverseaIgnoreFilePath((String)context.getBankVersionID());
        File file = FileCommonUtils.getFileByPath((String)dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(originFile = FileCommonUtils.getFileByPath((String)(originPath = dir + File.separator + "origin_" + filename))).exists()) {
            boolean newFile = originFile.createNewFile();
            this.logger.info("createNewFile:{}", (Object)newFile);
        }
        String filePath = dir + File.separator + filename;
        this.logger.info("\u5f00\u59cb\u751f\u6210\u539f\u59cb\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u6587\u4ef6\uff1a" + originPath);
        FileContentWriterUtil.writeUTF8FileContent((String)originPath, (String)content);
        this.logger.info("\u751f\u6210\u539f\u59cb\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u6587\u4ef6\u6210\u529f\u3002");
        this.logger.info("\u5f00\u59cb\u52a0\u5bc6\u539f\u59cb\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u6587\u4ef6\uff1a" + filePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(FileCommonUtils.getFileByPath((String)filePath));
             FileInputStream fileInputStream = new FileInputStream(FileCommonUtils.getFileByPath((String)originPath));){
            pgp.encryptAndSign((OutputStream)fileOutputStream, (InputStream)fileInputStream, puKey, prKey);
        }
        this.logger.info("\u751f\u6210\u52a0\u5bc6\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u6587\u4ef6\u6210\u529f\u3002");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

