/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.payment.tt;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbsg.h2h.services.payment.SCB_CommonPacker;
import kd.ebg.aqap.banks.scbsg.h2h.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.scbsg.h2h.services.utils.SCB_H2H_Utils;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    protected String getPayFileName(BankPayRequest bankPayRequest) {
        return "GCNA9940.TT_" + ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID() + ".P001-001-003";
    }

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = SCB_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn);
        Element PmtInf = SCB_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)info.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(info.getActualAmount());
            InstdAmt.setAttribute("Ccy", info.getPayCurrency());
            if (info.getPayerFeeType().equalsIgnoreCase("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)info.getIncomeBankName()).setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)SCB_H2H_Utils.formatStringByLength(info.getIncomeAccName(), 140)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            if (StringUtils.isNotEmpty((String)info.getIncomeAddress())) {
                JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"AdrLine", (String)info.getIncomeAddress()).setNamespace(ns1);
            }
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct, (String)"Nm", (String)info.getIncomeAccName()).setNamespace(ns1);
            if (StringUtils.isNotEmpty((String)info.getBusinessTypeCode())) {
                Element Purp = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Purp").setNamespace(ns1);
                JDomUtils.addChild((Element)Purp, (String)"Prtry", (String)info.getBusinessTypeCode()).setNamespace(ns1);
            }
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)info.getExplanation()).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "TT";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && "TT".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

