/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.detail.DetailParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.utils.DetailConstants;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(HisDetailImpl.class);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("1");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = super.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest request) {
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Result, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)Result, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)Result, (String)"PageNo", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)Result, (String)"Reserve", (String)"");
        JDomUtils.addChild((Element)Result, (String)"OrderMode", (String)"002");
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4013", xmlStr);
    }

    private boolean isLastPage(Element root) {
        String endFlag = root.getChildTextTrim("EndFlag");
        String pageRecCount = root.getChildTextTrim("PageRecCount");
        if ("Y".equalsIgnoreCase(endFlag)) {
            return true;
        }
        if ("N".equalsIgnoreCase(endFlag)) {
            return false;
        }
        if (0 == Integer.parseInt(pageRecCount)) {
            return true;
        }
        List list = root.getChildren("list");
        return null == list || list.size() <= 0;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        LinkedList<DetailInfo> details = new LinkedList<DetailInfo>();
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (DetailConstants.NO_RECORDS_CODES.contains(bankRsp.getResponseCode())) {
            this.log.info("\u8fd4\u56de\u65e0\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u7801:" + bankRsp.getResponseCode());
            this.setLastPage(true);
            return new EBBankDetailResponse(details);
        }
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25 :%s\u3002", (String)"HisDetailImpl_6", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        this.setLastPage(this.isLastPage(root));
        String acctNo = root.getChildTextTrim("AcctNo");
        String ccyCode = root.getChildTextTrim("CcyCode");
        String endFlag = root.getChildTextTrim("EndFlag");
        String pageRecCount = root.getChildTextTrim("PageRecCount");
        if (0 == Integer.parseInt(pageRecCount)) {
            return new EBBankDetailResponse(details);
        }
        List list = root.getChildren("list");
        if (null == list || list.size() <= 0) {
            return new EBBankDetailResponse(details);
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element listElement = (Element)list.get(i);
            String AcctDate = listElement.getChildTextTrim("AcctDate");
            String txTime = listElement.getChildTextTrim("TxTime");
            String HostTrace = listElement.getChildTextTrim("HostTrace");
            String DetailSerialNo = listElement.getChildTextTrim("DetailSerialNo");
            String OutNode = listElement.getChildTextTrim("OutNode");
            String OutBankNo = listElement.getChildTextTrim("OutBankNo");
            String OutBankName = listElement.getChildTextTrim("OutBankName");
            String OutAcctNo = listElement.getChildTextTrim("OutAcctNo");
            String OutAcctName = listElement.getChildTextTrim("OutAcctName");
            String tranCcyCode = listElement.getChildTextTrim("CcyCode");
            String TranAmount = listElement.getChildTextTrim("TranAmount");
            String InNode = listElement.getChildTextTrim("InNode");
            String InBankNo = listElement.getChildTextTrim("InBankNo");
            String InBankName = listElement.getChildTextTrim("InBankName");
            String InAcctNo = listElement.getChildTextTrim("InAcctNo");
            String InAcctName = listElement.getChildTextTrim("InAcctName");
            String DcFlag = listElement.getChildTextTrim("DcFlag");
            String AbstractStr = listElement.getChildTextTrim("AbstractStr");
            String VoucherNo = listElement.getChildTextTrim("VoucherNo");
            String TranFee = listElement.getChildTextTrim("TranFee");
            String PostFee = listElement.getChildTextTrim("PostFee");
            String AcctBalance = listElement.getChildTextTrim("AcctBalance");
            String Purpose = listElement.getChildTextTrim("Purpose");
            String AbstractStr_Desc = listElement.getChildTextTrim("AbstractStr_Desc");
            String CstInnerFlowNo = listElement.getChildTextTrim("CstInnerFlowNo");
            String merge = Purpose.concat("/" + AbstractStr_Desc);
            String tranCode = listElement.getChildTextTrim("TranCode");
            String HostDate = listElement.getChildTextTrim("HostDate");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(tranCcyCode);
            detail.setBankDetailNo(DetailSerialNo);
            if (("DIS".equalsIgnoreCase(AbstractStr) || "COL".equalsIgnoreCase(AbstractStr)) && "X0006".equalsIgnoreCase(tranCode)) {
                detail.setTransType("normal");
            } else if ("DIS".equalsIgnoreCase(AbstractStr)) {
                detail.setTransType("autotransdown");
            } else if ("COL".equalsIgnoreCase(AbstractStr)) {
                detail.setTransType("autotransup");
            } else {
                detail.setTransType("normal");
            }
            detail.setBizRefNo(HostTrace);
            if (Purpose != null && Purpose.length() > 11 && Purpose.contains("_KD_") && "D".equalsIgnoreCase(DcFlag)) {
                String bankDetailSeqId = BizNoUtil.getId((String)Purpose);
                if (bankDetailSeqId.length() > 13) {
                    bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                detail.setKdFlag(bankDetailSeqId);
                detail.setPayBankDetailSeqID(bankDetailSeqId);
                Purpose = BizNoUtil.getMsg((String)Purpose);
            }
            detail.setUseCn(Purpose);
            if (BankBusinessConfig.isPurposeAsAbstract()) {
                detail.setExplanation(Purpose);
            } else if (BankBusinessConfig.isMergeAsAbstract()) {
                detail.setExplanation(merge);
            } else {
                detail.setExplanation(AbstractStr_Desc);
            }
            detail.setAccNo(request.getAcnt().getAccNo());
            detail.setAccName(request.getAcnt().getAccName());
            detail.setBankName(request.getAcnt().getBankName());
            if ("C".equalsIgnoreCase(DcFlag)) {
                detail.setOppAccNo(OutAcctNo);
                detail.setOppAccName(OutAcctName);
                detail.setOppBankName(OutBankName);
                detail.setCreditAmount(new BigDecimal(TranAmount));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equalsIgnoreCase(DcFlag)) {
                detail.setOppAccNo(InAcctNo);
                detail.setOppAccName(InAcctName);
                detail.setOppBankName(InBankName);
                detail.setDebitAmount(new BigDecimal(TranAmount));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684DcFlag[\u501f\u8d37\u6807\u5fd7]\u4e0d\u53ef\u77e5,\u671f\u671b\u503c\u662fC\u6216D.\u5f53\u524d\u8fd4\u56de\u503cDcFlag=%s", (String)"HisDetailImpl_7", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), DcFlag));
            }
            String time = null;
            if (StringUtils.isEmpty((String)HostDate)) {
                if (StringUtils.isEmpty((String)AcctDate)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u94f6\u884c\u54a8\u8be2\u5904\u7406\uff0c\u56e0\u4e3a'\u4e3b\u673a\u8bb0\u8d26\u65e5\u671fAcctDate'\u548c'\u4e3b\u673a\u65e5\u671fHostDate'\u5747\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u660e\u7ec6\u7684\u4ea4\u6613\u65f6\u95f4\u3002", (String)"HisDetailImpl_2", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
                }
                time = AcctDate;
            } else {
                time = HostDate;
            }
            if (StringUtils.isEmpty((String)AcctDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7684\u4ea4\u6613\u65f6\u95f4\u65e0\u6cd5\u786e\u5b9a\uff0c\u56e0\u4e3a\u94f6\u884c\u8fd4\u56de\u7684\u4e3b\u673a\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"HisDetailImpl_3", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
            }
            try {
                LocalDateTime transDateTime;
                if (!StringUtils.isEmpty((String)txTime)) {
                    txTime = StringFormater.formatLen((String)txTime, (int)6, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
                    transDateTime = LocalDateTime.parse(AcctDate + txTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                    detail.setTransDate(transDateTime.toLocalDate());
                } else {
                    transDateTime = LocalDateTime.parse(AcctDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                    detail.setTransDate(transDateTime.toLocalDate());
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5f02\u5e38\u3002", (String)"HisDetailImpl_4", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)AcctBalance)) {
                detail.setBalance(new BigDecimal(AcctBalance));
            }
            String receiptNo = "";
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(listElement);
            detail.setJsonMap(jsonStr);
            String accNo = request.getAcnt().getAccNo();
            String transDate = time;
            receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)HostTrace);
            details.add(detail);
            String billNo = DetailParserHelper.getBillNo(Purpose);
            String aceptorAccName = DetailParserHelper.getBillAccName(Purpose);
            if (!StringUtils.isEmpty((String)billNo)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"VouhNo", (String)billNo);
            }
            if (StringUtils.isEmpty((String)aceptorAccName)) continue;
            DetailSysFiled.set((DetailInfo)detail, (String)"AceptorName", (String)aceptorAccName);
        }
        return new EBBankDetailResponse(details);
    }

    private String preTreated(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "4013";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2", (String)"HisDetailImpl_5", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }
}

