/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.payment.allocation;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.SzdbNewParser;
import kd.ebg.aqap.banks.pab.dc.services.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"4052", (String)"PayImpl_0", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5212\u62e8", (String)"PayImpl_1", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isAllocation(info);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u624b\u5de5\u5f52\u96c6\u4e0b\u62e8 (4052)\u4e0d\u652f\u6301\u6279\u91cf", (String)"PayImpl_2", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element Result = new Element("Result");
        String upperAccNo = paymentInfo.getAccNo();
        String lowerAccNo = paymentInfo.getIncomeAccNo();
        if (UseConvertor.isTransUp((PaymentInfo)paymentInfo)) {
            upperAccNo = paymentInfo.getIncomeAccNo();
            lowerAccNo = paymentInfo.getAccNo();
        }
        JDomUtils.addChild((Element)Result, (String)"ThirdVoucher", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)upperAccNo);
        JDomUtils.addChild((Element)Result, (String)"guiJiAreaOption", (String)"2");
        JDomUtils.addChild((Element)Result, (String)"subAccountNo", (String)lowerAccNo);
        JDomUtils.addChild((Element)Result, (String)"guiJiType", (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? "1" : "2"));
        JDomUtils.addChild((Element)Result, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(Sequence.genSequence(), "4052", xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        SzdbNewParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

