/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("accountNo", request.getAcnt().getAccNo());
        map.put("currencyType", request.getBankCurrency());
        map.put("currIden", "0");
        return PackerHelper.packXML(map, this.getBizCode());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr.substring(56), (String)EBContext.getContext().getCharsetName());
        Element opRep = root.getChild("opRep");
        Element repBody = opRep.getChild("RepParam");
        if (repBody == null || repBody.getContent().isEmpty()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
        }
        String balance = repBody.getChildText("balance");
        String balanceAvailable = repBody.getChildText("balanceAvailable");
        String currencyType = repBody.getChildText("currencyType");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, balanceAvailable);
        this.setBankAcnt(balanceInfo, request.getAcnt());
        this.setBankCurrency(balanceInfo, currencyType);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "enterpriseQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u67e5\u8be2\u60c5\u51b5", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }
}

