/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.payment.salary;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 2000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String serial = PackerHelper.getSeq();
        PackerHelper.setThreadSeq(serial);
        Element bodyEelement = PackerHelper.createRequestBody("agencyPayQry", serial);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        String serialNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"pay_serial");
        if (StringUtils.isEmpty((String)serialNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7orderFlowNo\u4e3a\u7a7a\u3002", (String)"PaymentQuery_1", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
        }
        map.put("orderFlowNo", serialNo);
        JDomUtils.addChild((Element)bodyEelement, (Element)PackerHelper.crateParamElement(map));
        Element rootElement = PackerHelper.createRequestHander(bodyEelement);
        JDomUtils.addChild((Element)rootElement, (Element)bodyEelement);
        StringBuilder stringBuilder = PackerHelper.createReportHander(rootElement, "agencyPayQry", serial);
        String xml = JDomUtils.root2StringNoIndentLineNoSeparator((Element)rootElement, (String)RequestContextUtils.getCharset());
        return stringBuilder.append(xml).toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String bankBatchSeqID = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID();
        Element root = JDomUtils.string2Root((String)rspStr.substring(56), (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        String returnCode = opRep.getChildTextTrim("hostReturnCode");
        String errMsg = opRep.getChildTextTrim("hostErrorMessage");
        if (Pattern.matches("0+", returnCode)) {
            Element repParam = opRep.getChild("RepParam");
            String state = repParam.getChildTextTrim("state");
            String errorMessage = repParam.getChildTextTrim("errorMessage");
            logger.info("\u72b6\u6001state\uff1a" + state);
            if ("1".equals(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)state, (String)"");
            } else if ("0".equals(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)state, (String)errorMessage);
            } else if ("3".equals(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)state, (String)errorMessage);
            } else if ("2".equals(state)) {
                List list = repParam.getChild("tranDetail").getChildren("row");
                for (Element element : list) {
                    String id = element.getChildText("SalaryId");
                    PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankBatchSeqID, (String)id);
                    if (paymentInfo != null) {
                        String detailState = element.getChildText("DetailState");
                        if ("COMPLETE".equals(detailState)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)detailState, (String)"");
                            continue;
                        }
                        if ("FAIL".equals(detailState)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)detailState, (String)element.getChildText("DetailErrMsg"));
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)detailState, (String)element.getChildText("DetailErrMsg"));
                        continue;
                    }
                    logger.info("\u6839\u636e\u5e8f\u53f7\u5339\u914d\u4ed8\u6b3e\u5931\u8d25\uff1a" + id);
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)errMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

