/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        Element root = Packer.createReqRootElement("2100");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element Head = DomHelper.getChildElementNotNull(root, "Head");
        String OpRetCode = DomHelper.getChildTextNotNull(Head, "OpRetCode", ResManager.loadKDString((String)"\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u7801", (String)"HisBalanceImpl_9", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        String OpRetMsg = DomHelper.getChildTextNullAsBlank(Head, "OpRetMsg");
        if (!"00".equals(OpRetCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)OpRetCode, (String)OpRetMsg));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String Usable_Balance = Param.getChildTextTrim("Usable_Balance");
        String currentBal = Param.getChildTextTrim("Balance");
        BalanceInfo balance = new BalanceInfo();
        if (StringUtils.isNotEmpty((String)Usable_Balance)) {
            balance.setAvailableBalance(BigDecimalHelper.div((String)Usable_Balance, (String)"100.00"));
        }
        balance.setBankAcnt(request.getAcnt());
        String date = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        balance.setBalanceDateTime(LocalDateTime.parse(date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        this.setCurrentBalance(balance, currentBal, 100);
        balance.setBankCurrency(request.getBankCurrency());
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(1);
        resultList.add(balance);
        return new EBBankBalanceResponse(resultList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CQRC17";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CQRC17(\u5386\u53f2\u4f59\u989d)", (String)"HisBalanceImpl_7", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 1;
    }
}

