/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment;

import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayPack {
    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String queryPayTransCode = this.getQueryPayTransCode();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2(%s)\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u3002", (String)"QueryPayPack_2", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), queryPayTransCode));
        }
        Element root = Packer.createReqRootElement(queryPayTransCode);
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"TransDate", (String)paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"EnterpriseID", (String)paymentInfos[0].getBankDetailSeqId());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    private String getQueryPayTransCode() {
        boolean isVersion3 = BankBusinessConfig.isVersion3();
        if (isVersion3) {
            return "2040";
        }
        return "1040";
    }
}

