/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IBatchBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBatchBalance;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchDepositBalBalance;
import kd.ebg.aqap.business.balance.atomic.ITodayDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.balance.utils.BalanceConvert;
import kd.ebg.aqap.business.balance.utils.QueryBalSplitDaysUnit;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.util.BalanceCurrencyModelUtil;
import kd.ebg.aqap.business.util.CurrencyPreCheckUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.balance.Balance;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequest;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponse;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.task.BizTaskTool;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BalanceMethod
implements EBServiceMethod<BatchBalanceRequest, BatchBalanceResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BalanceMethod.class);

    public BatchBalanceResponse mappingCurrency(BatchBalanceResponse response) {
        if (response.getBody() != null) {
            List balanceList = response.getBody().getBalances();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)balanceList)) {
                balanceList.stream().forEach(balance -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(balance.getCurrency(), currencyMap);
                    balance.setCurrency(currency);
                });
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchBalanceResponse executeClientRequest(BatchBalanceRequest request, EBContext context) {
        String taskID = BizTaskTool.getInstance().createBizTask(context);
        try {
            BizTaskTool.getInstance().setTaskProcessing(taskID);
            BatchBalanceResponse batchBalanceResponse = this.doBiz(request, context);
            return batchBalanceResponse;
        }
        finally {
            BizTaskTool.getInstance().setTaskFinish(taskID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchBalanceResponse doBiz(BatchBalanceRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        String bankVersionID = context.getBankVersionID();
        String subBizType = request.getHeader().getSubBizType();
        MDC.put((String)"clientName", (String)request.getHeader().getClientName());
        List accNos = request.getBody().getAccNos();
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        ArrayList<BankAcnt> errorBankAcnts = new ArrayList<BankAcnt>(1);
        List swiftCodes = request.getBody().getSwiftCode();
        List prdSeqs = request.getBody().getPrdSeqs();
        for (int i = 0; i < accNos.size(); ++i) {
            String accNo = (String)accNos.get(i);
            BankAcnt acnt = BankAcntService.getInstance().selectEnableByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            if (null == acnt) {
                acnt = new BankAcnt();
                acnt.setAccNo(accNo);
                errorBankAcnts.add(acnt);
                log.info("\u68c0\u67e5\u5230\u672a\u7ef4\u62a4\u7684\u94f6\u884c\u8d26\u53f7\uff1a" + accNo);
                continue;
            }
            String swiftCode = "";
            if (!Objects.isNull(swiftCodes)) {
                swiftCode = (String)swiftCodes.get(i);
            }
            String prdSeq = "";
            if (!Objects.isNull(prdSeqs)) {
                prdSeq = (String)prdSeqs.get(i);
            }
            acnt.setSwiftCode(swiftCode);
            acnt.setPrdSeq(prdSeq);
            bankAcnts.add(acnt);
        }
        if (bankAcnts.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8d26\u53f7\u5217\u8868\u5728\u94f6\u4f01\u4e91\u91cc\u4e0d\u5b58\u5728\u3002", (String)"BalanceMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse(new ArrayList<BalanceInfo>(1));
        if (!bankAcnts.isEmpty()) {
            FEPAccess access;
            block20: {
                BankBalanceRequest bankBalanceRequest = BalanceConvert.convert(request);
                bankBalanceRequest.setBankAcntList(bankAcnts);
                EBContext.initParameter();
                access = null;
                try {
                    MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                    access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                    AccessUtils.checkQueryAllowed(context);
                    if (BizName.Balance.TODAY_BALANCE.name().equalsIgnoreCase(subBizType)) {
                        IBalance balance = (IBalance)BankBundleManager.getInstance().getImpl(bankVersionID, IBalance.class, (Object)bankBalanceRequest);
                        CurrencyPreCheckUtil.checkBalanceCurrency(balance, bankBalanceRequest.getAcnt(), bankBalanceRequest.getBankCurrency());
                        bankBalanceResponse = balance.balance(bankBalanceRequest);
                        this.executeDepositBalance(bankBalanceRequest, bankBalanceResponse, bankVersionID);
                        break block20;
                    }
                    if (BizName.Balance.HISTORY_BALANCE.name().equalsIgnoreCase(subBizType)) {
                        IHisBalance hisBalance = (IHisBalance)BankBundleManager.getInstance().getImpl(bankVersionID, IHisBalance.class, (Object)bankBalanceRequest);
                        CurrencyPreCheckUtil.checkBalanceCurrency(hisBalance, bankBalanceRequest.getAcnt(), bankBalanceRequest.getBankCurrency());
                        bankBalanceResponse = hisBalance.hisBalance(bankBalanceRequest);
                        break block20;
                    }
                    if (BizName.Balance.BATCH_BALANCE.name().equalsIgnoreCase(subBizType)) {
                        try {
                            LocalDate endDate = bankBalanceRequest.getEndDate();
                            LocalDate startDate = bankBalanceRequest.getStartDate();
                            boolean splitFlag = Objects.nonNull(endDate) && endDate.isEqual(LocalDate.now());
                            if (splitFlag &= Objects.nonNull(startDate) && startDate.isBefore(LocalDate.now())) {
                                bankBalanceRequest.setStartDate(LocalDate.now());
                                bankBalanceResponse = this.executeTodayBatchBalance(bankBalanceRequest, bankVersionID);
                                this.executeBatchDepositBalance(bankBalanceRequest, bankBalanceResponse, bankVersionID);
                                bankBalanceRequest.setStartDate(startDate);
                                bankBalanceRequest.setEndDate(LocalDate.now().minusDays(1L));
                                EBBankBalanceResponse hisResponse = this.executeHisBatchBalance(bankBalanceRequest, bankVersionID);
                                if (bankBalanceResponse != null && hisResponse != null) {
                                    bankBalanceResponse.getBalances().addAll(hisResponse.getBalances());
                                }
                            } else if (endDate != null && endDate.isBefore(LocalDate.now())) {
                                bankBalanceResponse = this.executeHisBatchBalance(bankBalanceRequest, bankVersionID);
                            } else {
                                bankBalanceResponse = this.executeTodayBatchBalance(bankBalanceRequest, bankVersionID);
                                this.executeBatchDepositBalance(bankBalanceRequest, bankBalanceResponse, bankVersionID);
                            }
                            break block20;
                        }
                        catch (EBPreCheckException e) {
                            MDC.put((String)"bussiness_type", (String)"bussiness_process");
                            String errorMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u4e3a%1$s\uff0c\u4f59\u989d\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff1a%2$s\u3002", (String)"BalanceMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, e.getMessage());
                            log.error(errorMsg, (Throwable)e);
                            throw EBExceiptionUtil.preCheckException((String)errorMsg, (Throwable)e);
                        }
                    }
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b50\u4e1a\u52a1\u7c7b\u578b:%s\u3002", (String)"BalanceMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]), subBizType));
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
        if (errorBankAcnts.size() > 0 && bankBalanceResponse != null) {
            List<BalanceInfo> balanceInfos = bankBalanceResponse.getBalances();
            for (BankAcnt bankAcnt : errorBankAcnts) {
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(bankAcnt);
                balanceInfo.setBankCurrency("");
                balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u6ca1\u6709\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\u3002", (String)"BalanceMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
                balanceInfos.add(balanceInfo);
            }
        }
        BatchBalanceResponse response = BalanceConvert.convert(bankBalanceResponse);
        List balances = response.getBody().getBalances();
        response.getBody().setBalances(this.filterRepeatErrorBalances(balances, request.getHeader().getCurrency()));
        return response;
    }

    private List<Balance> filterRepeatErrorBalances(List<Balance> balances, String reqCurrency) {
        ArrayList<Balance> errorBalances = new ArrayList<Balance>(16);
        HashSet<String> resultKeySet = new HashSet<String>(balances.size());
        boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
        ArrayList<Balance> result = new ArrayList<Balance>(16);
        ListIterator<Balance> infoIterator = balances.listIterator();
        while (infoIterator.hasNext()) {
            Balance balance = (Balance)infoIterator.next();
            if (!StringUtils.isEmpty((String)balance.getError()) || !reqCurrency.equals(balance.getCurrency())) continue;
            resultKeySet.add(this.getResultKey(balance));
            result.add(balance);
            infoIterator.remove();
        }
        if (balances.size() > 0) {
            for (Balance balance : balances) {
                if (StringUtils.isEmpty((String)balance.getError()) && !reqCurrency.equals(balance.getCurrency())) {
                    String error = ShowTipUtil.getCurrencyNotEqualTips(reqCurrency, balance.getCurrency());
                    if (isOpenFilter) {
                        balance.setError(error);
                        log.info("\u8d26\u53f7{}\u67e5\u8be2\u4f59\u989d\uff0c{}", new Object[]{balance.getAccNo(), error});
                        errorBalances.add(balance);
                        continue;
                    }
                    balance.setCurrency(reqCurrency);
                    result.add(balance);
                    log.info("\u8d26\u53f7{}\u67e5\u8be2\u4f59\u989d\uff0c{},\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{balance.getAccNo(), error});
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)balance.getError())) continue;
                errorBalances.add(balance);
            }
        }
        if (errorBalances.size() > 0) {
            for (Balance balance : errorBalances) {
                String errorKey = this.getResultKey(balance);
                if (resultKeySet.contains(errorKey)) continue;
                result.add(balance);
                resultKeySet.add(errorKey);
            }
        }
        return result;
    }

    private String getResultKey(Balance balance) {
        StringBuilder sb = new StringBuilder();
        String dateStr = StringUtils.isNotEmpty((String)balance.getBalanceDateTime()) && balance.getBalanceDateTime().length() > 10 ? balance.getBalanceDateTime().substring(0, 10) : balance.getBalanceDateTime();
        sb.append(balance.getAccNo()).append("-").append(dateStr);
        return sb.toString();
    }

    private EBBankBalanceResponse executeTodayBatchBalance(BankBalanceRequest bankBalanceRequest, String bankVersionID) {
        ITodayBatchBalance batchBalance = null;
        try {
            batchBalance = (ITodayBatchBalance)BankBundleManager.getInstance().getImpl(bankVersionID, ITodayBatchBalance.class, (Object)bankBalanceRequest);
            if (batchBalance == null) {
                log.info("\u672a\u5f00\u53d1\u94f6\u884c\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\uff0c\u5c06\u8c03\u7528\u5355\u7b14\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
            } else if (!batchBalance.match((Object)bankBalanceRequest)) {
                log.info("\u672a\u542f\u7528\u94f6\u884c\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\uff08\u68c0\u67e5\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\u9879\u662f\u5426\u542f\u7528\u6279\u91cf\u4f59\u989d\u63a5\u53e3\uff09\uff0c\u5c06\u8c03\u7528\u5355\u7b14\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
                batchBalance = null;
            }
        }
        catch (EBPreCheckException e) {
            RequestContextUtils.setRunningParam((String)"Exception", (String)"");
            log.error(e.getMessage());
        }
        return this.executeBatchBalance(bankBalanceRequest, bankVersionID, batchBalance);
    }

    private EBBankBalanceResponse executeHisBatchBalance(BankBalanceRequest bankBalanceRequest, String bankVersionID) {
        IHisBatchBalance batchBalance = null;
        try {
            batchBalance = (IHisBatchBalance)BankBundleManager.getInstance().getImpl(bankVersionID, IHisBatchBalance.class, (Object)bankBalanceRequest);
            if (batchBalance == null) {
                log.info("\u672a\u5f00\u53d1\u94f6\u884c\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\uff0c\u5c06\u8c03\u7528\u5355\u7b14\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
            } else if (!batchBalance.match((Object)bankBalanceRequest)) {
                log.info("\u672a\u542f\u7528\u94f6\u884c\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\uff08\u68c0\u67e5\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\u9879\u662f\u5426\u542f\u7528\u6279\u91cf\u4f59\u989d\u63a5\u53e3\uff09\uff0c\u5c06\u8c03\u7528\u5355\u7b14\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
                batchBalance = null;
            }
        }
        catch (EBPreCheckException e) {
            RequestContextUtils.setRunningParam((String)"Exception", (String)"");
            log.error(e.getMessage());
        }
        return this.executeBatchBalance(bankBalanceRequest, bankVersionID, batchBalance);
    }

    /*
     * WARNING - void declaration
     */
    private EBBankBalanceResponse executeBatchBalance(BankBalanceRequest bankBalanceRequest, String bankVersionID, IBatchBalance batchBalance) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        ArrayList<Object> bankAcntList = new ArrayList<BankAcnt>(16);
        bankAcntList.addAll(bankBalanceRequest.getBankAcntList());
        if (batchBalance != null) {
            void var11_21;
            String className = batchBalance.getClass().getName();
            String bankIsoCurrency = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getBankCurrency());
            if (BalanceCurrencyModelUtil.isCNYCurrencyModel(className)) {
                if (!"CNY".equals(bankIsoCurrency)) {
                    log.info("\u8be5\u4f59\u989d\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237\uff0c\u68c0\u67e5\u5230\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0eCNY\u4e0d\u4e00\u81f4\uff0c\u4e2d\u65ad\u67e5\u8be2", new Object[]{className, bankIsoCurrency});
                    throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8be5\u4f59\u989d\u63a5\u53e3\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237", (String)"BalanceMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            } else if (BalanceCurrencyModelUtil.isOneCurrencyModel(className)) {
                ArrayList<BankAcnt> arrayList = new ArrayList<BankAcnt>(16);
                for (BankAcnt bankAcnt : bankAcntList) {
                    if (!bankAcnt.getCurrency().equals(bankIsoCurrency)) {
                        log.info("\u8be5\u4f59\u989d\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u53f7\uff0c\u68c0\u67e5\u5230\u8d26\u53f7{}\u7684\u5e01\u79cd{}\u4e0e\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u8df3\u8fc7\u6b64\u8d26\u53f7\u67e5\u8be2", new Object[]{className, bankAcnt.getAccNo(), bankAcnt.getCurrency(), bankIsoCurrency});
                        BalanceInfo balanceInfo = new BalanceInfo();
                        balanceInfo.setBankAcnt(bankAcnt);
                        balanceInfo.setBankCurrency(bankBalanceRequest.getHeader().getBankCurrency());
                        String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4f59\u989d\u63a5\u53e3\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u53f7\uff0c\u68c0\u67e5\u5230\u8d26\u53f7\u5e01\u79cd%1$s\u4e0e\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd%2$s\u4e0d\u4e00\u81f4\uff0c\u8df3\u8fc7\u6b64\u8d26\u53f7\u67e5\u8be2", (String)"BalanceMethod_66", (String)"ebg-aqap-business", (Object[])new Object[0]), bankAcnt.getCurrency(), bankIsoCurrency);
                        balanceInfo.setError(StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c%s\uff0c\u8bf7\u67e5\u770b\u94f6\u4f01\u4e91\u65e5\u5fd7\u3002", (String)"BalanceMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), msg)));
                        balanceInfos.add(balanceInfo);
                        continue;
                    }
                    arrayList.add(bankAcnt);
                }
                bankAcntList = new ArrayList(16);
                if (CollectionUtil.isNotEmpty(arrayList)) {
                    bankAcntList.addAll(arrayList);
                }
            }
            int n = batchBalance.limit();
            int totalNum = bankAcntList.size();
            boolean bl = false;
            while (var11_21 < totalNum) {
                int endIndex = var11_21 + n;
                if (endIndex > totalNum) {
                    endIndex = totalNum;
                }
                List<BankAcnt> bankAcnts = bankAcntList.subList((int)var11_21, endIndex);
                bankBalanceRequest.setBankAcntList(bankAcnts);
                try {
                    EBBankBalanceResponse response = QueryBalSplitDaysUnit.getInstance().batchBalance(bankBalanceRequest, batchBalance);
                    balanceInfos.addAll(response.getBalances());
                    balanceInfos.addAll(this.checkIntegrity(bankBalanceRequest, response));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    String errorMsg = "";
                    errorMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(16);
                    for (BankAcnt bankAcnt : bankAcnts) {
                        BalanceInfo balanceInfo = new BalanceInfo();
                        balanceInfo.setBankAcnt(bankAcnt);
                        balanceInfo.setBankCurrency(bankBalanceRequest.getHeader().getBankCurrency());
                        balanceInfo.setError(StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c%s\uff0c\u8bf7\u67e5\u770b\u94f6\u4f01\u4e91\u65e5\u5fd7\u3002", (String)"BalanceMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), errorMsg)));
                        balanceInfoList.add(balanceInfo);
                    }
                    balanceInfos.addAll(balanceInfoList);
                }
                var11_21 += n;
            }
        } else {
            LocalDate startDate = bankBalanceRequest.getStartDate();
            LocalDate endDate = bankBalanceRequest.getEndDate();
            boolean isToday = Objects.nonNull(startDate) && startDate.isEqual(LocalDate.now()) && Objects.nonNull(endDate) && endDate.isEqual(LocalDate.now());
            int n = bankAcntList.size();
            for (int i = 0; i < n; ++i) {
                try {
                    void var9_11;
                    Object balance;
                    bankBalanceRequest.setBankAcntList(bankAcntList.subList(i, i + 1));
                    bankBalanceRequest.getHeader().setAcnt((BankAcnt)bankAcntList.get(i));
                    if (isToday) {
                        balance = (IBalance)BankBundleManager.getInstance().getImpl(bankVersionID, IBalance.class, (Object)bankBalanceRequest);
                        CurrencyPreCheckUtil.checkBalanceCurrency((IBankService)balance, bankBalanceRequest.getAcnt(), bankBalanceRequest.getBankCurrency());
                        EBBankBalanceResponse eBBankBalanceResponse = balance.balance(bankBalanceRequest);
                    } else {
                        balance = (IHisBalance)BankBundleManager.getInstance().getImpl(bankVersionID, IHisBalance.class, (Object)bankBalanceRequest);
                        CurrencyPreCheckUtil.checkBalanceCurrency((IBankService)balance, bankBalanceRequest.getAcnt(), bankBalanceRequest.getBankCurrency());
                        EBBankBalanceResponse eBBankBalanceResponse = QueryBalSplitDaysUnit.getInstance().hisBalance(bankBalanceRequest, (IHisBalance)balance);
                    }
                    balanceInfos.addAll(var9_11.getBalances());
                    balanceInfos.addAll(this.checkIntegrity(bankBalanceRequest, (EBBankBalanceResponse)var9_11));
                    continue;
                }
                catch (Exception e) {
                    BalanceInfo balanceInfo = new BalanceInfo();
                    balanceInfo.setBankAcnt(bankBalanceRequest.getHeader().getAcnt());
                    balanceInfo.setBankCurrency(bankBalanceRequest.getHeader().getBankCurrency());
                    if (e.getCause() != null) {
                        balanceInfo.setError(StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c%s\uff0c\u8bf7\u67e5\u770b\u94f6\u4f01\u4e91\u65e5\u5fd7\u3002", (String)"BalanceMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getCause().getMessage())));
                    } else {
                        balanceInfo.setError(StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c%s\uff0c\u8bf7\u67e5\u770b\u94f6\u4f01\u4e91\u65e5\u5fd7\u3002", (String)"BalanceMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage())));
                    }
                    balanceInfos.add(balanceInfo);
                }
            }
        }
        bankBalanceRequest.setBankAcntList(bankAcntList);
        ebBankBalanceResponse.setBalances(balanceInfos);
        ArrayList<String> accNoList = new ArrayList<String>(16);
        for (BankAcnt bankAcnt : bankAcntList) {
            accNoList.add(bankAcnt.getAccNo());
        }
        ListIterator infoIterator = balanceInfos.listIterator();
        while (infoIterator.hasNext()) {
            BalanceInfo balanceInfo = (BalanceInfo)infoIterator.next();
            String bankAccount = balanceInfo.getBankAcnt().getAccNo();
            if (accNoList.contains(bankAccount)) continue;
            infoIterator.remove();
        }
        return ebBankBalanceResponse;
    }

    private EBBankBalanceResponse executeBatchDepositBalance(BankBalanceRequest bankBalanceRequest, EBBankBalanceResponse bankBalanceResponse, String bankVersionID) {
        try {
            ITodayBatchDepositBalBalance batchImpl = (ITodayBatchDepositBalBalance)BankBundleManager.getInstance().getImplWithoutException(bankVersionID, ITodayBatchDepositBalBalance.class, (Object)bankBalanceRequest);
            if (batchImpl == null) {
                log.info("\u4e0d\u5b58\u5728\u4e0a\u5b58\u4f59\u989d\u6279\u91cf\u67e5\u8be2\u63a5\u53e3");
                ITodayDepositBalBalance depositBalBalanceImp = (ITodayDepositBalBalance)BankBundleManager.getInstance().getImplWithoutException(bankVersionID, ITodayDepositBalBalance.class, (Object)bankBalanceRequest);
                if (depositBalBalanceImp == null) {
                    log.info("\u4e0d\u5b58\u5728\u4e0a\u5b58\u4f59\u989d\u5355\u7b14\u67e5\u8be2\u63a5\u53e3,\u4e0d\u67e5\u8be2\u4e0a\u5b58\u4f59\u989d");
                    return bankBalanceResponse;
                }
                log.info("\u5f00\u59cb\u8c03\u7528\u5355\u7b14\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
                List<BankAcnt> bankAcntList = bankBalanceRequest.getBankAcntList();
                for (int i = 0; i < bankAcntList.size(); ++i) {
                    try {
                        bankBalanceRequest.setBankAcntList(bankAcntList.subList(i, i + 1));
                        bankBalanceRequest.getHeader().setAcnt(bankAcntList.get(i));
                        if (!depositBalBalanceImp.match((Object)bankBalanceRequest)) {
                            log.info("\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u914d\u7f6e\u672a\u5f00\u542f");
                            return bankBalanceResponse;
                        }
                        depositBalBalanceImp.balance(bankBalanceRequest, bankBalanceResponse);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u8d26\u6237\uff1a" + bankAcntList.get(i).getAccNo() + "\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                    }
                }
            } else if (batchImpl.match((Object)bankBalanceRequest)) {
                batchImpl.batchBalance(bankBalanceRequest, bankBalanceResponse);
            } else {
                log.info("\u8be5\u6279\u6b21\u8d26\u6237\u4e2d\u6240\u6709\u7684\u8d26\u6237\u5747\u672a\u5f00\u542f\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u4e0a\u5b58\u4f59\u989d\u5931\u8d25\uff1a" + e.getMessage());
        }
        return bankBalanceResponse;
    }

    private EBBankBalanceResponse executeDepositBalance(BankBalanceRequest bankBalanceRequest, EBBankBalanceResponse bankBalanceResponse, String bankVersionID) {
        try {
            ITodayDepositBalBalance depositBalBalanceImp = (ITodayDepositBalBalance)BankBundleManager.getInstance().getImplWithoutException(bankVersionID, ITodayDepositBalBalance.class, (Object)bankBalanceRequest);
            if (depositBalBalanceImp == null) {
                log.info("\u4e0d\u5b58\u5728\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u63a5\u53e3");
            } else {
                if (!depositBalBalanceImp.match((Object)bankBalanceRequest)) {
                    log.info("\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u914d\u7f6e\u672a\u5f00\u542f");
                    return bankBalanceResponse;
                }
                bankBalanceResponse = depositBalBalanceImp.balance(bankBalanceRequest, bankBalanceResponse);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return bankBalanceResponse;
    }

    private List<BalanceInfo> checkIntegrity(BankBalanceRequest request, EBBankBalanceResponse response) {
        ArrayList<BalanceInfo> missAcntBalanceList = new ArrayList<BalanceInfo>(1);
        List<BankAcnt> bankAcntList = request.getBankAcntList();
        List<BalanceInfo> balanceInfoList = response.getBalances();
        for (BankAcnt acnt : bankAcntList) {
            BalanceInfo info;
            boolean flag = false;
            Iterator<BalanceInfo> iterator = balanceInfoList.iterator();
            while (iterator.hasNext() && !(flag = (info = iterator.next()).getBankAcnt() != null && acnt.getAccNo().equalsIgnoreCase(info.getBankAcnt().getAccNo()))) {
            }
            if (flag) continue;
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setBankCurrency(request.getHeader().getBankCurrency());
            balanceInfo.setError(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u4f59\u989d\u63a5\u53e3\u672a\u8fd4\u56de\u8be5\u8d26\u53f7\u4f59\u989d\u4fe1\u606f\u3002", (String)"BalanceMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
            missAcntBalanceList.add(balanceInfo);
        }
        return missAcntBalanceList;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "balance";
    }
}

