/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.business.detail.MyThread;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.storage.DetailSyncService;
import kd.ebg.aqap.business.detail.utils.DetailConvert;
import kd.ebg.aqap.business.detail.utils.DetailCurrencyFilterUtils;
import kd.ebg.aqap.business.detail.utils.DetailSyncKit;
import kd.ebg.aqap.business.detail.utils.SyncPeriod;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.util.CurrencyPreCheckUtil;
import kd.ebg.aqap.common.entity.biz.detail.Detail;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponse;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.framework.task.BizTaskTool;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class DetailMethod
implements EBServiceMethod<DetailRequest, DetailResponse> {
    private static final String EB_DETAIL = "eb_detail_";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailMethod.class);
    private static final int PAGE_SIZE = 1000;
    private static final String acnt_iso_currency_key = "ebg_acnt_iso_currency";
    private static final String business_iso_currency_key = "ebg_business_iso_currency";
    DetailSyncService syncService;
    ObjectPropertyService objectPropertyService;

    public DetailResponse mappingCurrency(DetailResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            list.stream().forEach(item -> {
                String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                item.setCurrency(currency);
            });
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetailResponse executeClientRequest(DetailRequest request, EBContext context) {
        String taskID = BizTaskTool.getInstance().createBizTask(context);
        try {
            BizTaskTool.getInstance().setTaskProcessing(taskID);
            DetailResponse detailResponse = this.doBiz(request, context);
            return detailResponse;
        }
        finally {
            BizTaskTool.getInstance().setTaskFinish(taskID);
        }
    }

    public DetailResponse doBiz(DetailRequest request, EBContext context) {
        Page page;
        boolean onlyToday;
        AccessUtils.checkQueryAllowed(context);
        this.syncService = (DetailSyncService)SpringContextUtil.getBean(DetailSyncService.class);
        this.objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
        String bankVersionID = context.getBankVersionID();
        String subBizType = request.getHeader().getSubBizType();
        String customID = context.getCustomID();
        String startDateStr = request.getBody().getStartDate();
        String endDateStr = request.getBody().getEndDate();
        BankAcnt bankAcnt = EBContext.getContext().getBankAcnt();
        bankAcnt.setSwiftCode(request.getBody().getSwiftCode());
        String currency = request.getHeader().getCurrency();
        boolean isFromEbgPage = "COSMIC-EBG".equalsIgnoreCase(request.getHeader().getClientName());
        MDC.put((String)"clientName", (String)request.getHeader().getClientName());
        String detailSerachDateStr = BankPropertyConfig.getBankDetailSearchDate((String)bankVersionID);
        String accnoSearchLimit = BankPropertyConfig.getAccnoSearchLimit((String)bankAcnt.getAccNo());
        if ("receipt".equalsIgnoreCase(subBizType)) {
            return this.queryDetailInfo(bankVersionID, bankAcnt, startDateStr, customID, request);
        }
        int pageNum = request.getBody().getPageNum();
        int pageSize = request.getBody().getPageSize();
        if (pageNum <= 0) {
            pageNum = 1;
            request.getBody().setPageNum(1);
        }
        if (pageSize <= 0) {
            pageSize = 1000;
            request.getBody().setPageSize(1000);
        }
        HashMap<String, String> runningParams = new HashMap<String, String>(1);
        runningParams.put(acnt_iso_currency_key, bankAcnt.getCurrency());
        if (StrUtil.isBlank((CharSequence)currency)) {
            currency = bankAcnt.getCurrency();
            request.getHeader().setCurrency(currency);
        }
        runningParams.put(business_iso_currency_key, currency);
        context.setRunningParams(runningParams);
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        logger.info("\u67e5\u8be2\u5e10\u53f7 : {}, \u5e01\u79cd:{} \u4ece {} \u5230 {} \u7684\u660e\u7ec6", new Object[]{bankAcnt.getAccNo(), currency, startDateStr, endDateStr});
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.plusDays(-1L);
        long n = 3L;
        LocalDate preNMonth = endDate.plusMonths(-n);
        if (startDate.isAfter(endDate)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"DetailMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (BusinessPropertyConfig.isSearchFromFutureDate()) {
            if ((startDate.isBefore(today) || startDate.isEqual(today)) && endDate.isAfter(today)) {
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u67e5\u8be2\u672a\u6765\u65e5\u671f\u548c\u5386\u53f2\uff08\u6216\u5f53\u65e5\uff09\u65e5\u671f\u3002", (String)"DetailMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        } else {
            if (today.isBefore(endDate) && today.isBefore(startDate)) {
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"DetailMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (today.isBefore(endDate)) {
                logger.info("\u4e0d\u5141\u8bb8\u67e5\u8be2\u672a\u6765\u65e5\u671f\uff0c\u6240\u4ee5\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u4eca\u5929,\u4fee\u6539\u7ed3\u675f\u65e5\u671f\u4e3a\u4eca\u5929\u3002");
                endDate = today;
            }
        }
        if (startDate.isBefore(preNMonth)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7 %s\u4e2a\u6708\u3002", (String)"DetailMethod_24", (String)"ebg-aqap-business", (Object[])new Object[0]), n));
        }
        Date monthLater = DateUtil.preMonth((Date)new Date(), (int)3);
        if (DateUtil.isBefore((Date)LocalDateUtil.localDate2Date((LocalDate)startDate), (Date)monthLater)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u67e5\u8be23\u4e2a\u6708\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)detailSerachDateStr) && "false".equals(accnoSearchLimit)) {
            LocalDate detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE);
            if (endDate.isBefore(detailSearchDate)) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5728\u56de\u5355\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f[%s]\u4e4b\u524d\u3002", (String)"DetailMethod_25", (String)"ebg-aqap-business", (Object[])new Object[0]), detailSerachDateStr));
            }
            if (startDate.isBefore(detailSearchDate)) {
                startDate = detailSearchDate;
                logger.info("\u5f00\u59cb\u65e5\u671f\u5728\u56de\u5355\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f{}\u4e4b\u524d\uff0c\u4fee\u6539\u5f00\u59cb\u65e5\u671f\u4e3a\u56de\u5355\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f{}", new Object[]{detailSerachDateStr, detailSerachDateStr});
            }
        }
        boolean bl = onlyToday = today.isEqual(startDate) && today.isEqual(endDate);
        if (request.getBody().isDownloadFromBank() && !onlyToday) {
            int days = (int)(endDate.toEpochDay() - startDate.toEpochDay()) + 1;
            int maxNum = this.getSearchFromBankMaxNum();
            DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
            if (days == detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetween(customID, bankAcnt.getAccNo(), currency, startDate, endDate) && 0 == detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetweenAndSyncCountLessThan(customID, bankAcnt.getAccNo(), currency, startDate, endDate, maxNum)) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u8054\u673a\u67e5\u8be2\u6b21\u6570\u5df2\u8fbe\u5230\u6700\u5927\u6b21\u6570%4$s\uff0c\u8bf7\u5230\u3010\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u3011\u9875\u9762->\u3010\u4ea4\u6613\u660e\u7ec6\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u7684\u6700\u5927\u6b21\u6570\u3011\u914d\u7f6e\u9879\u8c03\u5927\u6216\u8005\u4f7f\u7528\u666e\u901a\u67e5\u8be2\u64cd\u4f5c", (String)"DetailMethod_26", (String)"ebg-aqap-business", (Object[])new Object[0]), bankAcnt.getAccNo(), startDate.toString(), endDate.toString(), maxNum));
            }
            detailSyncRecordRepository.deleteByCustomIDAndAccNoAndSyncDateBetween(customID, bankAcnt.getAccNo(), currency, startDate, endDate);
        }
        Integer isKeyRepeat = request.getBody().getIsKeyRepeat();
        if (!isFromEbgPage) {
            isKeyRepeat = 0;
            request.getBody().setIsKeyRepeat(Integer.valueOf(0));
        }
        this.validTimeScope();
        boolean forceQuery = false;
        Page prePage = null;
        if (today.isEqual(startDate) && today.isEqual(endDate) && !this.syncService.isHavingPagingDetail(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat, pageNum, pageSize)) {
            prePage = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
            forceQuery = prePage.getTotalElements() == 0L;
        }
        this.queryFromBank(prePage, bankAcnt, startDate, endDate, request, customID, forceQuery);
        long totalElements = 0L;
        int totalPages = 0;
        boolean lastPage = true;
        List<Object> detailInfos = new ArrayList(1);
        if (startDate.isBefore(LocalDate.now()) || startDate.isAfter(LocalDate.now())) {
            page = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
            detailInfos = page.getContent();
            totalElements = page.getTotalElements();
            totalPages = page.getTotalPages();
            lastPage = page.isLast();
        } else if (startDate.isEqual(LocalDate.now()) && endDate.isEqual(LocalDate.now())) {
            detailInfos = this.syncService.getPagingDetail(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat, pageNum, pageSize);
            totalElements = this.syncService.getPagingTotalNum(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat).intValue();
            if (CollectionUtil.isEmpty(detailInfos) && totalElements > 0L) {
                page = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
                detailInfos = page.getContent();
                totalElements = page.getTotalElements();
            }
            totalPages = totalElements % (long)pageSize == 0L ? (int)totalElements / pageSize : (int)totalElements / pageSize + 1;
            lastPage = pageNum == totalPages || totalElements == 0L;
        }
        logger.info("\r\n\u9875\u603b\u6570 = {}\r\n\u603b\u4ea4\u6613\u660e\u7ec6\u6570 = {}\r\n\u67e5\u8be2\u5230\u7684\u4ea4\u6613\u660e\u7ec6\u7b14\u6570 = {}\r\n\u6bcf\u9875\u5927\u5c0f = {}\r\n\u672c\u6b21\u67e5\u8be2\u7684\u9875\u7801 = {}\r\n\u662f\u5426\u662f\u6700\u540e\u4e00\u9875 = {}", new Object[]{totalPages, totalElements, detailInfos.size(), pageSize, pageNum, lastPage});
        ArrayList<Detail> details = new ArrayList<Detail>(detailInfos.size());
        for (DetailInfo detailInfo : detailInfos) {
            details.add(DetailConvert.convert(detailInfo));
        }
        DetailResponse detailResponse = new DetailResponse();
        DetailResponseBody detailResponseBody = new DetailResponseBody();
        detailResponse.setBody(detailResponseBody);
        detailResponseBody.setLastPage(lastPage);
        detailResponseBody.setTotalCount((int)totalElements);
        detailResponseBody.setPageNum(pageNum);
        detailResponseBody.setPageSize(pageSize);
        detailResponseBody.setDetails(details);
        detailResponseBody.setProgress(1);
        return detailResponse;
    }

    private boolean validTimeScope() {
        int time = BusinessPropertyConfig.getDetailSearchRestrictScope();
        if (time != 0) {
            Calendar c = Calendar.getInstance();
            Date date = new Date();
            c.setTime(date);
            int hour = c.get(11);
            if (hour > 12) {
                c.set(5, c.get(5) + 1);
            }
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(12, time);
            Date endDate = c.getTime();
            c.set(12, c.get(12) - time * 2);
            Date startDate = c.getTime();
            if (date.after(startDate) && date.before(endDate)) {
                String startDateStr = DateUtil.formatDate((Date)startDate, (String)"HH:mm");
                String endDateStr = DateUtil.formatDate((Date)endDate, (String)"HH:mm");
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e%1$s~%2$s\u65f6\u95f4\u8303\u56f4\u5185\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011-\u3010\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u3011\u7684\u96f6\u70b9\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u63a7\u5236\u53c2\u6570", (String)"DetailMethod_30", (String)"ebg-aqap-business", (Object[])new Object[0]), startDateStr, endDateStr));
            }
        }
        return true;
    }

    public DetailResponse queryDetailInfo(String bankVersion, BankAcnt acnt, String queryDate, String customId, DetailRequest detailRequest) {
        LocalDate date = LocalDate.parse(queryDate, DateTimeFormatter.BASIC_ISO_DATE);
        DetailResponse response = new DetailResponse();
        DetailResponseBody body = new DetailResponseBody();
        List detailInfos = DetailInfoService.getInstance().select(acnt.getAccNo(), bankVersion, date, date);
        if (detailInfos == null || detailInfos.size() == 0) {
            MyThread thread = new MyThread(acnt, date, customId, detailRequest);
            thread.start();
            EBException ebException = new EBException();
            ebException.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u65e0\u8bb0\u5f55\uff0c\u94f6\u4f01\u4e91\u5df2\u53d1\u8d77\u67e5\u8be2\u660e\u7ec6\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"DetailMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
            ebException.setErrorCode("success");
            response.setException(ebException);
        } else {
            ArrayList<Detail> details = new ArrayList<Detail>(1);
            for (DetailInfo detailInfo : detailInfos) {
                Detail detail = new Detail();
                detail.setAccNo(detailInfo.getAccNo());
                detail.setBalance(detailInfo.getBalance().toString());
                detail.setOppAccNo(detailInfo.getOppAccNo());
                detail.setCreditAmount(detailInfo.getCreditAmount().toString());
                detail.setDebitAmount(detailInfo.getDebitAmount().toString());
                detail.setExplanation(detailInfo.getExplanation());
                details.add(detail);
            }
            body.setDetails(details);
        }
        response.setBody(body);
        return response;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "hisDetail";
    }

    private void queryFromBank(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, DetailRequest detailRequest, String customID, boolean forceQuery) {
        LocalDate today = LocalDate.now();
        String date = today.format(DateTimeFormatter.BASIC_ISO_DATE);
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        if (forceQuery) {
            EBContext.getContext().setForceQueryDetail(true);
            logger.info("\u5f3a\u5236\u67e5\u8be2\uff0c\u8df3\u8fc73\u5206\u949f\u9650\u5236");
        }
        boolean isDetailSupportMultiCurrency = BankBundleManager.getInstance().getBankVersionInfo(bankAcnt.getBankVersionId()).isDetailSupportMultiCurrency();
        if (today.isEqual(startDate) && syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID)) {
            int minute = BusinessPropertyConfig.getTodayDetailLimitTime();
            if (forceQuery || this.syncService.isExpire(bankAcnt.getAccNo(), date, customID, minute)) {
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest), detailRequest.getBody().getIsKeyRepeat());
                this.syncService.recordTodayDetailTimestamp(bankAcnt.getAccNo(), date, customID);
            } else {
                logger.info("\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u672a\u8d85\u8fc7\u9650\u5236\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\uff0c\u8df3\u8fc7\u672c\u6b21\u8054\u67e5\u94f6\u884c\uff0c\u76f4\u63a5\u8fd4\u56de\u6570\u636e\u5e93\u8bb0\u5f55");
            }
        } else if (today.isEqual(endDate)) {
            LocalDate yesterday = today.plusDays(-1L);
            if (syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID)) {
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest), detailRequest.getBody().getIsKeyRepeat());
            } else {
                logger.info("\u5e10\u53f7 : {} \u8fd13\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u5728\u67e5\u8be2", (Object)bankAcnt.getAccNo());
            }
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, yesterday, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest), detailRequest.getBody().getIsKeyRepeat());
            }
        } else {
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, endDate, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest), detailRequest.getBody().getIsKeyRepeat());
            }
        }
    }

    public void queryFromBank(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, DetailRequest detailRequest, String customID) {
        EBContext context = EBContext.builder().customID(customID).bankVersionID(bankAcnt.getBankVersionId()).bankLoginID(bankAcnt.getBankLoginId()).build();
        EBContext.setContext((EBContext)context);
        this.queryFromBank(bankAcnt, startDate, endDate, detailRequest, customID, true);
    }

    private void queryFromBank(Page<DetailInfo> page, BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, DetailRequest detailRequest, String customID, boolean forceQuery) {
        LocalDate today = LocalDate.now();
        String date = today.format(DateTimeFormatter.BASIC_ISO_DATE);
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        int minute = BusinessPropertyConfig.getTodayDetailLimitTime();
        if (forceQuery) {
            EBContext.getContext().setForceQueryDetail(true);
            logger.info("\u5f3a\u5236\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6");
        }
        boolean isDetailSupportMultiCurrency = BankBundleManager.getInstance().getBankVersionInfo(bankAcnt.getBankVersionId()).isDetailSupportMultiCurrency();
        if (today.isEqual(startDate) && syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID)) {
            if (forceQuery || this.syncService.isExpire(bankAcnt.getAccNo(), date, customID, minute)) {
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest), detailRequest.getBody().getIsKeyRepeat());
                this.syncService.recordTodayDetailTimestamp(bankAcnt.getAccNo(), date, customID);
            } else {
                logger.info("\u5e10\u53f7: {} \u5728{}\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u518d\u67e5\u8be2", new Object[]{bankAcnt.getAccNo(), minute});
            }
        } else if (today.isEqual(endDate)) {
            LocalDate yesterday = today.plusDays(-1L);
            if (syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID)) {
                if (forceQuery || this.syncService.isExpire(bankAcnt.getAccNo(), date, customID, minute)) {
                    this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest), detailRequest.getBody().getIsKeyRepeat());
                    this.syncService.recordTodayDetailTimestamp(bankAcnt.getAccNo(), date, customID);
                } else {
                    logger.info("\u5e10\u53f7: {} \u5728{}\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u518d\u67e5\u8be2", new Object[]{bankAcnt.getAccNo(), minute});
                }
            }
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, yesterday, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest), detailRequest.getBody().getIsKeyRepeat());
            }
        } else {
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, endDate, isDetailSupportMultiCurrency, detailRequest.getHeader().getCurrency(), customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest), detailRequest.getBody().getIsKeyRepeat());
            }
        }
    }

    private BankDetailRequest buildRequest(BankAcnt acnt, LocalDate startDate, LocalDate endDate, DetailRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomId());
        String isoCurrency = detailRequest.getHeader().getCurrency();
        if (StringUtils.isEmpty((String)isoCurrency)) {
            isoCurrency = acnt.getCurrency();
        }
        String bankCurrency = CurrencyUtils.convert2Bank((String)isoCurrency);
        header.setBankCurrency(bankCurrency);
        request.setPageSize(detailRequest.getBody().getPageSize());
        request.setPageNum(1);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setExtData(detailRequest.getBody().getExtData());
        request.setSerialNo(detailRequest.getBody().getSerialNo());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToday(BankAcnt bankAcnt, LocalDate today, BankDetailRequest request, Integer isKeyRepeat) {
        String isoCurrency = (String)EBContext.getContext().getRunningParams().get(business_iso_currency_key);
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + today.toString() + "_" + isoCurrency + "_" + (isKeyRepeat == null ? "" : isKeyRepeat);
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (StringUtils.isNotEmpty((String)result)) {
            logger.error("\u5f53\u524d\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            throw EBExceiptionUtil.duplicateException((String)ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2\u3002", (String)"DetailMethod_40", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"todayDetail");
        IDetail detail = (IDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IDetail.class, (Object)request);
        CurrencyPreCheckUtil.checkDetailCurrency(detail, bankAcnt.getCurrency(), request.getBankCurrency());
        EBBankDetailResponse response = null;
        FEPAccess access = null;
        long takeUpTime = 0L;
        try {
            long startTime = System.currentTimeMillis();
            access = FEPAccessUtil.access((String)EBContext.getContext().getBankVersionID(), (String)EBContext.getContext().getBankLoginID());
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            response = detail.detail(request);
            takeUpTime = System.currentTimeMillis() - startTime;
        }
        catch (Throwable throwable) {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            FEPAccessUtil.release(access);
            throw throwable;
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        String customID = EBContext.getContext().getCustomID();
        syncKit.insert_sync_detail(bankAcnt.getAccNo(), customID, today, today, takeUpTime);
        if (CollectionUtil.isNotEmpty(response.getDetails()) && !isoCurrency.equals(response.getDetails().get(0).getCurrency())) {
            boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
            if (isOpenFilter) {
                logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u8fc7\u6ee4", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            } else {
                logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            }
        }
        List detailInfoList = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().compareTo(LocalDate.now()) == 0).collect(Collectors.toList());
        response.setDetails(DetailCurrencyFilterUtils.filterCurrency(detailInfoList, isoCurrency));
        if (response.getDetails().size() > detailInfoList.size()) {
            logger.info("\u67e5\u8be2\u94f6\u884c\u8fd4\u56de{}\u6761\u4ea4\u6613\u660e\u7ec6\uff1b\u65e5\u671f\u4e0e\u5e01\u522b\u8fc7\u6ee4\u540e\uff0c\u6709{}\u6761\u660e\u7ec6\u3002", new Object[]{response.getDetails().size(), detailInfoList.size()});
        }
        this.dealResponse(bankAcnt, response, today, today);
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        detailInfoList = detailInfoRepository.findByCustomIDAndAccNoAndCurrencyAndTransDateBetweenAndIsKeyRepeat(customID, bankAcnt.getAccNo(), isoCurrency, today, today, isKeyRepeat);
        this.syncService.removePagingTotalNum(bankAcnt.getAccNo(), today.toString(), isoCurrency, isKeyRepeat);
        this.syncService.savePagingDetail(detailInfoList, bankAcnt.getAccNo(), today.toString(), isoCurrency, request.getPageSize(), isKeyRepeat);
        this.syncService.savePagingTotalNum(bankAcnt.getAccNo(), today.toString(), isoCurrency, detailInfoList.size(), isKeyRepeat);
        CosmicCache.delete((String)key);
    }

    private void syncHistory(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, BankDetailRequest request, Integer isKeyRepeat) {
        EBBankDetailResponse response;
        String isoCurrency = (String)EBContext.getContext().getRunningParams().get(business_iso_currency_key);
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + isoCurrency + "_" + isKeyRepeat;
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (StringUtils.isNotEmpty((String)result)) {
            logger.error("\u5f53\u524d\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            return;
        }
        LocalDate oneYearLater = LocalDateUtil.date2LocalDate((Date)DateUtil.preYear((Date)new Date(), (int)1));
        if (!BusinessPropertyConfig.isSearchFromBankLimit1Year() && (startDate.isBefore(oneYearLater) || endDate.isBefore(oneYearLater))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8bf7\u524d\u5f80[\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e]\u9875\u9762\uff0c\u8bbe\u7f6e[\u4ea4\u6613\u660e\u7ec6\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u4e00\u5e74\u524d\u7684\u8bb0\u5f55]\u914d\u7f6e\u9879\u4e3a\u201c\u662f\u201d\u3002\u5f53\u524d\u65e0\u6cd5\u8054\u673a\u67e5\u8be2\u4e00\u5e74\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"hisDetail");
        IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IHisDetail.class, (Object)request);
        CurrencyPreCheckUtil.checkDetailCurrency(detail, bankAcnt.getCurrency(), request.getBankCurrency());
        FEPAccess access = null;
        long takeUpTime = 0L;
        String customID = EBContext.getContext().getCustomID();
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        try {
            long startTime = System.currentTimeMillis();
            access = FEPAccessUtil.access((String)EBContext.getContext().getBankVersionID(), (String)EBContext.getContext().getBankLoginID());
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            response = detail.hisDetail(request);
            takeUpTime = System.currentTimeMillis() - startTime;
        }
        catch (Exception ex) {
            try {
                syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, false);
                throw EBExceiptionUtil.serviceException((Throwable)ex);
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        syncKit.insert_sync_detail(bankAcnt.getAccNo(), customID, startDate, endDate, takeUpTime);
        if (CollectionUtil.isNotEmpty(response.getDetails()) && !response.getDetails().get(0).getCurrency().equals(isoCurrency)) {
            boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
            if (isOpenFilter) {
                logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u8fc7\u6ee4", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            } else {
                logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            }
        }
        List<DetailInfo> detailInfos = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().isBefore(endDate.plusDays(1L)) && detailInfo.getTransDate().isAfter(startDate.minusDays(1L))).collect(Collectors.toList());
        response.setDetails(DetailCurrencyFilterUtils.filterCurrency(detailInfos, isoCurrency));
        if (response.getDetails().size() > detailInfos.size()) {
            logger.info("\u67e5\u8be2\u94f6\u884c\u8fd4\u56de{}\u6761\u4ea4\u6613\u660e\u7ec6\uff1b\u65e5\u671f\u4e0e\u5e01\u522b\u8fc7\u6ee4\u540e\uff0c\u6709{}\u6761\u660e\u7ec6\u3002", new Object[]{response.getDetails().size(), detailInfos.size()});
        }
        try {
            this.dealResponse(bankAcnt, response, startDate, endDate);
            syncKit.insertSyncDetailRecord(detailInfos, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, true);
        }
        catch (Exception ex) {
            logger.info("\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
            syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, false);
            throw EBExceiptionUtil.serviceException((Throwable)ex);
        }
        CosmicCache.delete((String)key);
    }

    private void dealResponse(BankAcnt bankAcnt, EBBankDetailResponse response, LocalDate startDate, LocalDate endDate) {
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        List<DetailInfo> detailInfos = response.getDetails();
        String accType = BankAcntPropertyConfig.getAccType((String)bankAcnt.getAccNo());
        for (DetailInfo detail : detailInfos) {
            String currency;
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getDebitAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u501f\u6b3e\u91d1\u989d(DebitAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u6536\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6\u3002", (String)"DetailMethod_17", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCreditAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u8d37\u6b3e\u91d1\u989d(CreditAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u4ed8\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6\u3002", (String)"DetailMethod_18", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailMethod_19", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getTransTime()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u4ea4\u6613\u65f6\u95f4(TransTime)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailMethod_20", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setBankLoginID(bankAcnt.getBankLoginId());
            detail.setBankVersionID(bankAcnt.getBankVersionId());
            String bankCurrency = detail.getCurrency();
            if (!currencyMap.containsKey(bankCurrency)) {
                currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
            }
            if (!StringUtils.isEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) {
                detail.setCurrency(currency);
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u8f6c\u6362\u9519\u8bef\uff0c\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailMethod_21", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setCustomID(EBContext.getContext().getCustomID());
            detail.setAccType(accType);
            LocalDateTime transTime = detail.getTransTime();
            if (Objects.isNull(transTime)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"DetailMethod_22", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            LocalDate transDate = detail.getTransDate();
            if (Objects.isNull(transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u8bb0\u8d26\u65e5\u671f\uff08transDate\uff09\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"DetailMethod_23", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)detail.getAccNo())) {
                detail.setAccNo(bankAcnt.getAccNo());
            }
            if (StringUtils.isEmpty((String)detail.getAccName())) {
                detail.setAccName(bankAcnt.getAccName());
            }
            if (StringUtils.isEmpty((String)detail.getBankName())) {
                detail.setBankName(bankAcnt.getBankName());
            }
            detail.setCreditAmount(detail.getCreditAmount().setScale(2, 4));
            detail.setDebitAmount(detail.getDebitAmount().setScale(2, 4));
        }
        DetailInfoService.getInstance().insertOrUpdate(detailInfos, bankAcnt, EBContext.getContext().getCustomID(), startDate, endDate);
        String key = "eb_detailFlag__" + bankAcnt.getCustomID() + "_" + bankAcnt.getBankVersionId() + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString();
        boolean isToday = false;
        LocalDate today = LocalDate.now();
        if (startDate.isEqual(today) && endDate.isEqual(today)) {
            isToday = true;
        }
        if (isToday) {
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)10, (TimeUnit)TimeUnit.MINUTES);
        } else {
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    int getSearchFromBankMaxNum() {
        ObjectProperties objectProperties = ((ObjectPropertiesRepository)SpringContextUtil.getBean(ObjectPropertiesRepository.class)).findByAttrKeyAndObjectNameAndObjectID("search_from_bank_max_num", "ebg", "common_business");
        if (objectProperties == null) {
            return BusinessPropertyConfig.getSearchFromBankMaxNumDefualtValue();
        }
        return Integer.parseInt(objectProperties.getAttrValue());
    }
}

