/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.atomic;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.codeless.packer.PackerUtil;
import kd.ebg.aqap.business.codeless.parser.ParseAqapUtil;
import kd.ebg.aqap.business.detail.atomic.IDetailTransfer;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.framework.reconciliation.KDProcessorFactory;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.codeless.PageUtil.PageLogicUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.service.codeless.CodeLessService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public abstract class AbstractCodelessDetailImpl
extends AbstractBankXmlImpl
implements IDetailTransfer,
IBankService<BankDetailRequest, EBBankDetailResponse, BankDetailRequest> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractCodelessDetailImpl.class);

    public boolean isTodayDetailReverse() {
        return false;
    }

    public boolean isHistoryDetailReverse() {
        return false;
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        EBBankDetailResponse response = this.isSupportPage() ? this.doBizWithPage(request) : this.process(request);
        if (!CollectionUtils.isEmpty(response.getDetails())) {
            if (request.getEndDate().isEqual(request.getStartDate()) && request.getEndDate().isEqual(LocalDate.now())) {
                if (this.isTodayDetailReverse()) {
                    Collections.reverse(response.getDetails());
                    logger.info("\u6b64\u5f53\u65e5\u660e\u7ec6\u63a5\u53e3\u8fd4\u56de\u987a\u5e8f\u4e3a\u5012\u5e8f\uff0c\u7cfb\u7edf\u7edf\u4e00\u98a0\u5012\u6392\u5e8f\uff0c\u4fdd\u6301\u6b63\u5e8f");
                }
            } else if (this.isHistoryDetailReverse()) {
                Collections.reverse(response.getDetails());
                logger.info("\u6b64\u5386\u53f2\u660e\u7ec6\u63a5\u53e3\u8fd4\u56de\u987a\u5e8f\u4e3a\u5012\u5e8f\uff0c\u7cfb\u7edf\u7edf\u4e00\u98a0\u5012\u6392\u5e8f\uff0c\u4fdd\u6301\u6b63\u5e8f");
            }
        }
        return response;
    }

    public EBBankDetailResponse process(BankDetailRequest request) {
        try {
            String requestStr = this.packerUtil(request, null);
            this.setDetailImpl();
            String responseStr = this.doBusiness(requestStr);
            EBContext.getContext().setProcessFlag(PROCESS_PARSE);
            EBBankDetailResponse response = this.parserUtil(request, responseStr);
            if (!EBContext.getContext().isUnitTest()) {
                KDProcessorFactory.getInstance().processDetailInfo(responseStr, response.getDetails());
            }
            return response;
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractDetailImpl_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"AbstractDetailImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    protected void setDetailImpl() {
        HashMap<String, String> runningParams = EBContext.getContext().getRunningParams();
        if (CollectionUtils.isEmpty((Map)runningParams)) {
            runningParams = new HashMap<String, String>(1);
            EBContext.getContext().setRunningParams(runningParams);
        }
        runningParams.put("detail_impl", this.getClass().getName());
    }

    public EBBankDetailResponse doBizWithPage(BankDetailRequest request) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String responseStr = null;
        if (this.canDoIt()) {
            String pageTag = this.getFirstPageTag();
            try {
                do {
                    String requestStr = this.packerUtil(request, pageTag);
                    responseStr = this.doBusiness(requestStr);
                    EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                    EBBankDetailResponse response = this.parse(request, responseStr);
                    pageTag = this.getNextPageTag(responseStr, pageTag);
                    if (!CollectionUtil.isNotEmpty(response.getDetails())) continue;
                    detailList.addAll(response.getDetails());
                } while (!this.isLastPage(responseStr, pageTag));
                return new EBBankDetailResponse(detailList);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)MultiLang.getLimitRateTip(this.getBankInterval()));
    }

    public boolean match(BankDetailRequest request) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isSupportPage() {
        return false;
    }

    public String doBusiness(String requestStr) {
        String responseStr = null;
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
            Preconditions.checkNotNull((Object)requestStr, (Object)MultiLang.getBankRequestDataEmptyTip());
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getConnection(factory);
            this.openConnection(connection);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            try (OutputStream outputStream = this.getOutputStream(connection);){
                this.send(outputStream, requestStr);
                try (InputStream inputStream = this.getInputStream(connection);){
                    responseStr = this.recv(inputStream);
                    EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                }
            }
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractBalanceImpl_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
        return responseStr;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            String nextPage = PageLogicUtil.getNextPage((CodeLess)codeless, (String)rspStr, (String)pageTag);
            return nextPage;
        }
        return "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            return PageLogicUtil.isLastPage((CodeLess)codeless, (String)rspStr, (String)pageTag);
        }
        return true;
    }

    public String getFirstPageTag() {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            return codeless.getFirstPage();
        }
        return "0";
    }

    public String packerUtil(BankDetailRequest request, String pageTag) {
        if (this.isPackerAuto()) {
            String structId = this.getStructIdPacker();
            String rsp = this.packerAuto(request, pageTag, structId);
            return this.getSendMsg(rsp);
        }
        return this.pack(request);
    }

    public String packerAuto(BankDetailRequest request, String pageTag, String structId) {
        Map map = this.getStructMapPacker();
        map.put("pageTag", pageTag);
        String dateStr = this.getDateStr();
        return PackerUtil.packerDetail(request, map, structId, dateStr);
    }

    public EBBankDetailResponse parserUtil(BankDetailRequest request, String responStr) {
        responStr = this.getReceiveMsg(responStr);
        try {
            if (this.isParserAuto()) {
                String structId = this.getStructIdPacker();
                return new EBBankDetailResponse(this.parserAuto(request, structId, responStr));
            }
            return this.parse(request, responStr);
        }
        catch (Exception e) {
            logger.error("codeless parser  error :", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)"codeless parser  error :", (Throwable)e);
        }
    }

    public List<DetailInfo> parserAuto(BankDetailRequest request, String structId, String responStr) throws Exception {
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", structId);
            context.setCodeLess(codeLess);
        }
        String dateStr = this.getDateStr();
        return ParseAqapUtil.parseBalance(request, responStr, dateStr, this.isNeedRequestAccn());
    }

    public boolean isNeedRequestAccn() {
        return false;
    }

    public boolean isPackerAuto() {
        return true;
    }

    public boolean isParserAuto() {
        return true;
    }
}

