/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.task;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.DetailCompletionRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailCompensation;
import kd.ebg.aqap.business.detail.utils.DetailSyncKit;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class DetailCompensationTask
extends AbstractTask {
    private static final String EB_DETAIL = "eb_detail_";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailCompensationTask.class);
    DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
    private DetailCompletionRequest request;
    private EBContext context;

    public DetailCompensationTask(DetailCompletionRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBContext.setContext((EBContext)this.context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        if (SystemPropertyConfig.isScheduleLogOpen()) {
            MDC.put((String)"schedule", (String)"true");
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)this.context.getBankVersionID());
        this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406,{}", (Object)this.context.getBizSeqID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5f00\u59cb\u5904\u7406\u4ea4\u6613\u660e\u7ec6\u81ea\u52a8\u8865\u507f\u5f00\u59cb\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        List<DetailCompensation> detailCompensations = this.request.getDetailCompensations();
        int allCount = 0;
        if (CollectionUtil.isNotEmpty(detailCompensations)) {
            for (DetailCompensation detailCompensation : detailCompensations) {
                String key;
                if (this.checkRepeatSearch(detailCompensation, key = EB_DETAIL + this.request.getHeader().getCustomerID() + "_" + detailCompensation.getBankAcnt().getAccNo() + "_" + detailCompensation.getStartDate() + "_" + detailCompensation.getEndDate().toString() + "_" + detailCompensation.getBankAcnt().getCurrency() + "_0")) continue;
                try {
                    List<DetailInfo> detailInfos = this.syncHistory(detailCompensation, this.request);
                    allCount += detailInfos.size();
                    this.syncKit.insertSyncDetailRecord(detailInfos, detailCompensation.getBankAcnt().getAccNo(), detailCompensation.getBankAcnt().getBankName(), this.context.getCustomID(), detailCompensation.getStartDate(), detailCompensation.getEndDate(), detailCompensation.getBankAcnt().getCurrency(), true, true);
                    this.logger.info("{}\u8865\u507f\u4ea4\u6613\u660e\u7ec6\u8d26\u53f7{}\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {}\u6210\u529f\uff01", new Object[]{this.context.getBankLoginID(), detailCompensation.getBankAcnt().getAccNo(), detailCompensation.getStartDate(), detailCompensation.getEndDate()});
                }
                catch (Exception ex) {
                    this.syncKit.insertSyncDetailRecord(null, detailCompensation.getBankAcnt().getAccNo(), detailCompensation.getBankAcnt().getBankName(), this.context.getCustomID(), detailCompensation.getStartDate(), detailCompensation.getEndDate(), detailCompensation.getBankAcnt().getCurrency(), true, false);
                    this.logger.info("{}\u8865\u507f\u4ea4\u6613\u660e\u7ec6\u8d26\u53f7{}\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {}\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{this.context.getBankLoginID(), detailCompensation.getBankAcnt().getAccNo(), detailCompensation.getStartDate(), detailCompensation.getEndDate(), ex.getMessage()});
                }
                CosmicCache.delete((String)key);
            }
        }
        if (allCount != 0) {
            this.logger.info("{}\u8865\u507f\u4ea4\u6613\u660e\u7ec6\uff0c\u603b\u6570\u91cf{}", new Object[]{this.context.getBankLoginID(), allCount});
        }
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u4ea4\u6613\u660e\u7ec6\u81ea\u52a8\u8865\u507f\u7ed3\u675f\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        return null;
    }

    private boolean checkRepeatSearch(DetailCompensation detailCompensation, String key) {
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)60, (TimeUnit)TimeUnit.SECONDS);
        if (StringUtils.isNotEmpty((String)result)) {
            this.logger.error("{}\u8865\u507f\u4ea4\u6613\u660e\u7ec6\u8d26\u53f7{}\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} \u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8df3\u8fc7\u672c\u6b21\u8bf7\u6c42\uff0c\u8bf7\u7b49\u5f8560s\u540e\u67e5\u8be2", new Object[]{this.context.getBankLoginID(), detailCompensation.getBankAcnt().getAccNo(), detailCompensation.getStartDate().toString(), detailCompensation.getEndDate().toString()});
            return true;
        }
        return false;
    }

    private BankDetailRequest buildRequest(BankAcnt acnt, LocalDate startDate, LocalDate endDate, DetailCompletionRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomerID());
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)this.context.getBankVersionID(), (String)this.context.getCustomID());
        header.setBankCurrency(bankCurrency);
        request.setPageSize(0);
        request.setPageNum(1);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setExtData("");
        request.setSerialNo("");
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DetailInfo> syncHistory(DetailCompensation detailCompensation, DetailCompletionRequest detailCompletionRequest) {
        EBBankDetailResponse response;
        BankAcnt bankAcnt = detailCompensation.getBankAcnt();
        BankDetailRequest request = this.buildRequest(detailCompensation.getBankAcnt(), detailCompensation.getStartDate(), detailCompensation.getEndDate(), detailCompletionRequest);
        this.logger.info("{}\u67e5\u8be2\u8d26\u53f7{}\u5386\u53f2\u660e\u7ec6\u7684\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{this.context.getBankLoginID(), bankAcnt.getAccNo(), detailCompensation.getStartDate().toString(), detailCompensation.getEndDate().toString()});
        EBContext.setContext((EBContext)this.context);
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"hisDetail");
        IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IHisDetail.class, (Object)request);
        FEPAccess access = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = detail.hisDetail(request);
        }
        catch (Throwable throwable) {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            throw throwable;
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.info("\u65e5\u671f\u8fc7\u6ee4\u524d\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)response.getDetails().size());
        List<DetailInfo> detailInfos = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().isBefore(detailCompensation.getEndDate().plusDays(1L)) && detailInfo.getTransDate().isAfter(detailCompensation.getStartDate().minusDays(1L))).collect(Collectors.toList());
        this.dealResponse(detailCompensation, detailInfos);
        return detailInfos;
    }

    private void dealResponse(DetailCompensation detailCompensation, List<DetailInfo> detailInfos) {
        this.logger.info("\u65e5\u671f\u8fc7\u6ee4\u540e\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)detailInfos.size());
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        String accType = BankAcntPropertyConfig.getAccType((String)detailCompensation.getBankAcnt().getAccNo());
        for (DetailInfo detail : detailInfos) {
            String currency;
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getDebitAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u501f\u6b3e\u91d1\u989d(DebitAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u6536\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"DetailCompensationTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCreditAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u8d37\u6b3e\u91d1\u989d(CreditAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u4ed8\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"DetailCompensationTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a", (String)"DetailCompensationTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getTransTime()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u4ea4\u6613\u65f6\u95f4(TransTime)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailCompensationTask_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setBankLoginID(detailCompensation.getBankAcnt().getBankLoginId());
            detail.setBankVersionID(detailCompensation.getBankAcnt().getBankVersionId());
            String bankCurrency = detail.getCurrency();
            if (!currencyMap.containsKey(bankCurrency)) {
                currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
            }
            if (!StringUtils.isEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) {
                detail.setCurrency(currency);
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u8f6c\u6362\u9519\u8bef\uff0c\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailCompensationTask_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setCustomID(EBContext.getContext().getCustomID());
            detail.setAccType(accType);
            LocalDateTime transTime = detail.getTransTime();
            if (Objects.isNull(transTime)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailCompensationTask_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            LocalDate transDate = detail.getTransDate();
            if (Objects.isNull(transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u8bb0\u8d26\u65e5\u671f\uff08transDate\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailCompensationTask_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)detail.getAccNo())) {
                detail.setAccNo(detailCompensation.getBankAcnt().getAccNo());
            }
            if (StringUtils.isEmpty((String)detail.getAccName())) {
                detail.setAccName(detailCompensation.getBankAcnt().getAccName());
            }
            if (StringUtils.isEmpty((String)detail.getBankName())) {
                detail.setBankName(detailCompensation.getBankAcnt().getBankName());
            }
            detail.setCreditAmount(detail.getCreditAmount().setScale(2, 4));
            detail.setDebitAmount(detail.getDebitAmount().setScale(2, 4));
        }
        DetailInfoService.getInstance().insertOrUpdate(detailInfos, detailCompensation.getBankAcnt(), EBContext.getContext().getCustomID(), detailCompensation.getStartDate(), detailCompensation.getEndDate());
    }
}

