/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Callable;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankDetailTask;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class DetailUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailUtil.class);

    public static void async(DetailRequest request, EBContext context) {
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        BankHeader header = new BankHeader();
        bankDetailRequest.setHeader(header);
        BankAcnt acnt = EBContext.getContext().getBankAcnt();
        header.setAcnt(acnt);
        header.setBizType(request.getHeader().getBizType());
        header.setSubBizType(request.getHeader().getSubBizType());
        header.setClientName(request.getHeader().getClientName());
        header.setClientVersion(request.getHeader().getClientVersion());
        header.setExtData(request.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(request.getHeader().getLogBizSeqID());
        header.setCustomerID(request.getHeader().getCustomId());
        String bankCurrency = request.getHeader().getCurrency();
        header.setBankCurrency(bankCurrency);
        bankDetailRequest.setPageSize(request.getBody().getPageSize());
        bankDetailRequest.setPageNum(request.getBody().getPageNum());
        bankDetailRequest.setBankCurrency(bankCurrency);
        LocalDate startDate = LocalDate.parse(request.getBody().getStartDate(), DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(request.getBody().getEndDate(), DateTimeFormatter.BASIC_ISO_DATE);
        bankDetailRequest.setStartDate(startDate);
        bankDetailRequest.setEndDate(endDate);
        bankDetailRequest.setExtData(request.getBody().getExtData());
        bankDetailRequest.setSerialNo(request.getBody().getSerialNo());
        String customerId = context.getCustomID();
        String bankLoginId = bankDetailRequest.getHeader().getBankLoginID();
        String taskID = EBThreadPools.createBizTask(context);
        BankDetailTask bankDetailTask = new BankDetailTask(bankDetailRequest, context);
        bankDetailTask.setTaskId(taskID);
        EBThreadPools.getDetailThreadPool(customerId, bankLoginId).submit((Callable)((Object)bankDetailTask));
    }
}

