/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.file;

import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.AttachmentUploadTask;
import kd.ebg.aqap.common.framework.services.PayAttachmentService;
import kd.ebg.aqap.common.model.PayAttachment;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class AttachmentUploadRunnable
implements Runnable {
    private String bankBatchSeqId;
    private String loggerBatchNo;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadRunnable.class);
    private PayAttachmentService payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);

    public AttachmentUploadRunnable(String bankBatchSeqId, String loggerBatchNo) {
        this.bankBatchSeqId = bankBatchSeqId;
        this.loggerBatchNo = loggerBatchNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List payAttachments = null;
        String key = "eb_attatch_upload_" + this.bankBatchSeqId;
        try {
            if (CachePayStorage.checkSubmitLock(key)) {
                this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4efb\u52a1\u4e0d\u518d\u5904\u7406\u3002", (String)"AttachmentUploadRunnable_0", (String)"ebg-aqap-business", (Object[])new Object[0]), this.bankBatchSeqId));
                return;
            }
            QFilter qFilter = QFilter.of((String)"bank_batch_seq_id = ?", (Object[])new Object[]{this.bankBatchSeqId});
            boolean exists = QueryServiceHelper.exists((String)"aqap_pay_attachment", (QFilter[])qFilter.toArray());
            if (!exists) {
                this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u9644\u4ef6\u9700\u8981\u4e0a\u4f20,bankBatchSeqId=%s", (String)"AttachmentUploadRunnable_1", (String)"ebg-aqap-business", (Object[])new Object[0]), this.bankBatchSeqId));
                return;
            }
            payAttachments = this.payAttachmentService.findByBankBatchSeqId(this.bankBatchSeqId);
            PayAttachment payAttachment = (PayAttachment)payAttachments.get(0);
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(payAttachment.getCustomID()).logRequestSeqID(this.loggerBatchNo).bizName("attachmentUpload").subBizName("attachmentUpload").bankVersionID(payAttachment.getBankVersionID()).bankLoginID(payAttachment.getBankLoginID()).logBizSeqID(this.loggerBatchNo).bizSeqID(Sequence.genSequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(this.loggerBatchNo).loggerDetailNo(Sequence.genSequence()).loggerBankNo(Sequence.genSequence()).build();
            BankAcnt bankAcnt = new BankAcnt();
            context.setBankAcnt(bankAcnt);
            EBContext.setContext((EBContext)context);
            BankAttachmentRequest bankAttachmentRequest = new BankAttachmentRequest();
            bankAttachmentRequest.setPayAttachments(payAttachments);
            String taskID = "";
            try {
                taskID = EBThreadPools.createBizTask(context);
            }
            catch (Throwable e) {
                this.logger.monitorInfo("createBizTask fail :" + e.getMessage());
            }
            AttachmentUploadTask attachmentUploadTask = new AttachmentUploadTask(bankAttachmentRequest, context);
            attachmentUploadTask.setTaskId(taskID);
            EBThreadPools.getAttachmentUploadThreadPool(context.getCustomID(), context.getBankLoginID()).submit((Callable)((Object)attachmentUploadTask));
        }
        finally {
            CachePayStorage.release(key);
        }
    }
}

