/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.file;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.url.UrlService;
import kd.ebg.aqap.common.entity.biz.file.DownloadFileDetail;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.io.FileUtils;

public class DownLoadFileUtil
extends AbstractBankXmlImpl {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadFileUtil.class);

    public static DownLoadFileUtil getInstance() {
        return new DownLoadFileUtil();
    }

    public void doDownloadFileList(List<DownloadFileDetail> downloadFileDetails) {
        this.downloadBySftp(downloadFileDetails);
        this.uploadToServer(downloadFileDetails);
    }

    protected ChannelSftp getChannelSftp() {
        ChannelSftp channelSftp = null;
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String ftpIP = parameter.getBankParameter("upload_sftp_ip");
        String ftpPortStr = parameter.getBankParameter("upload_sftp_port");
        String ftpCertPath = parameter.getBankParameter("upload_sftp_cert_path");
        String ftpUserName = parameter.getBankParameter("upload_sftp_user");
        String ftpPassword = parameter.getBankParameter("upload_sftp_cipher");
        int ftpPort = Integer.parseInt(ftpPortStr);
        try {
            channelSftp = this.startConnect(ftpIP, ftpPort, ftpUserName, ftpPassword, ftpCertPath, "");
        }
        catch (JSchException | IOException e) {
            this.logger.error("sftp\u8fde\u63a5\u5f02\u5e38", e);
        }
        return channelSftp;
    }

    public ChannelSftp startConnect(String host, int port, String username, String ftpPassword, String ftpCertFileName, String ftpCertPassword) throws JSchException, IOException {
        String ftpCert;
        JSch jsch = new JSch();
        this.logger.info("\u51c6\u5907\u5efa\u7acbSFTP\u8fde\u63a5\u3002");
        if (!StringUtils.isEmpty((String)ftpCertFileName) && StringUtils.isNotEmpty((String)(ftpCert = this.getFtpCert()))) {
            File cert = FileCommonUtils.getFileByPath((String)this.getFtpCertPath(), (String)ftpCertFileName);
            String ftpCertPath = this.getFtpCertPath() + File.separator + ftpCertFileName;
            File certFile = new File(CleanPathUtil.cleanString((String)ftpCertPath));
            if (!cert.exists()) {
                this.logger.info("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u4fdd\u5b58\u5230\u5bf9\u5e94\u76ee\u5f55:" + ftpCertPath);
                FileUtils.write((File)certFile, (CharSequence)ftpCert, (Charset)StandardCharsets.UTF_8);
                File fileByPath = FileCommonUtils.getFileByPath((String)ftpCertPath);
                if (fileByPath.exists()) {
                    this.logger.info("\u8bc1\u4e66\u4fdd\u5b58\u6210\u529f");
                }
            }
            if (StringUtils.isEmpty((String)ftpCertPassword)) {
                jsch.addIdentity(ftpCertPath);
            } else {
                jsch.addIdentity(ftpCertPath, ftpCertPassword);
            }
        }
        Session session = jsch.getSession(username, host, port);
        session.setConfig("StrictHostKeyChecking", "no");
        session.setTimeout(600000);
        if (!StringUtils.isEmpty((String)ftpPassword)) {
            session.setPassword(ftpPassword);
        }
        session.connect(30000);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftp = (ChannelSftp)channel;
        this.logger.info("Connected to " + host + ".");
        return sftp;
    }

    private String getFtpCertPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = System.getProperty("user.dir");
        this.checkAndCreatePath(storageRootPath + File.separator + "cert" + File.separator + customID);
        return storageRootPath + File.separator + "cert" + File.separator + customID;
    }

    private void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath((String)path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception var3) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84: %s\u53d1\u751f\u5f02\u5e38\u3002", (String)"AbstractAttachmentImpl_10", (String)"ebg-aqap-business", (Object[])new Object[0]), path), (Throwable)var3);
            }
        }
    }

    private String getFtpCert() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("ftp_cert_path", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            return null;
        }
        CipherInfo cipherInfo = this.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return this.getKey(fileContent);
    }

    private CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    public void downloadBySftp(List<DownloadFileDetail> details) {
        boolean isDownload;
        ChannelSftp channelSftp;
        block5: {
            EBContext context = EBContext.getContext();
            IParameter parameter = context.getParameter();
            String download_sftp_path = parameter.getBankParameter("download_sftp_path");
            this.logger.info("sftp path :" + download_sftp_path);
            channelSftp = this.getChannelSftp();
            isDownload = true;
            try {
                channelSftp.cd(download_sftp_path);
            }
            catch (Throwable t) {
                this.logger.error("cd path error ", t);
                isDownload = false;
                if (channelSftp == null) break block5;
                channelSftp.disconnect();
            }
        }
        if (isDownload) {
            details.forEach(downloadFileDetail -> {
                try {
                    SftpATTRS attrs = channelSftp.lstat(downloadFileDetail.getFileName());
                    downloadFileDetail.setFileSize(attrs.getSize() + "");
                    channelSftp.get(downloadFileDetail.getFileName(), this.getLocalPath());
                    downloadFileDetail.setIsDownLoad(true);
                }
                catch (Throwable t) {
                    downloadFileDetail.setIsDownLoad(false);
                    this.logger.error("download error ", t);
                }
            });
            if (channelSftp != null) {
                channelSftp.disconnect();
            }
        } else {
            details.forEach(downloadFileDetail -> downloadFileDetail.setIsDownLoad(false));
        }
    }

    public void uploadToServer(List<DownloadFileDetail> details) {
        details.forEach(downloadFileDetail -> {
            try {
                if (downloadFileDetail.getIsDownLoad()) {
                    FileService fs = FileServiceFactory.getAttachmentFileService();
                    String filePath = this.getLocalPath(downloadFileDetail.getFileName());
                    FileItem file = new FileItem(downloadFileDetail.getFileName(), CleanPathUtil.cleanString((String)filePath), (InputStream)new FileInputStream(CleanPathUtil.cleanString((String)filePath)));
                    file.setCreateNewFileWhenExists(true);
                    String path = fs.upload(file);
                    String fuilPath = UrlService.getAttachmentFullUrl((String)path);
                    downloadFileDetail.setFileUrl(fuilPath);
                    downloadFileDetail.setIsUpload(true);
                    downloadFileDetail.setFilePath(this.getServerPath());
                } else {
                    downloadFileDetail.setIsUpload(false);
                }
            }
            catch (Throwable t) {
                downloadFileDetail.setIsUpload(false);
            }
        });
    }

    protected String getLocalPath() {
        EBContext context = EBContext.getContext();
        String bankVersionID = context.getBankVersionID();
        return this.getPath(this.getStorageRootPath(), "attachment", bankVersionID);
    }

    private String getPath(String rootPath, String path, String bankVersionID) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootPath).append(File.separator).append(bankVersionID).append(File.separator).append(path);
        String fixedPath = sb.toString();
        this.checkAndCreatePath(fixedPath);
        return fixedPath;
    }

    protected String getLocalPath(String fileName) {
        EBContext context = EBContext.getContext();
        String bankVersionID = context.getBankVersionID();
        return this.getPath(this.getStorageRootPath(), "attachment", bankVersionID) + File.separator + fileName;
    }

    protected String getServerPath() {
        EBContext context = EBContext.getContext();
        String bankVersionID = context.getBankVersionID();
        return this.getPath(this.getStorageRootPath(), "attachment", bankVersionID);
    }

    private String getStorageRootPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        this.checkAndCreatePath(File.separator + "download" + File.separator + customID);
        return File.separator + "download" + File.separator + customID;
    }
}

