/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginConfig;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginRequest;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginRequestBody;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginResponse;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.framework.services.BankLoginConfigOpService;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SyncBankLoginMethod
implements EBServiceMethod<SyncBankLoginRequest, SyncBankLoginResponse> {
    private BankLoginService bankLoginService;
    private BankLoginConfigOpService bankLoginConfigService;
    private UserCertRepository userCertRepository;

    public SyncBankLoginResponse executeClientRequest(SyncBankLoginRequest request, EBContext context) {
        String operation;
        SyncBankLoginResponse response = new SyncBankLoginResponse();
        this.bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
        this.bankLoginConfigService = (BankLoginConfigOpService)SpringContextUtil.getBean(BankLoginConfigOpService.class);
        this.userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        switch (operation = request.getBody().getOperation()) {
            case "new": {
                response.setBody(this.addBankLogin(request.getBody(), context.getCustomID()));
                break;
            }
            case "edit": {
                response.setBody(this.updBankLogin(request.getBody(), context.getCustomID()));
                break;
            }
            default: {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7801:%s\u3002", (String)"SyncBankLoginMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]), operation));
            }
        }
        return response;
    }

    public SyncBankLoginResponseBody addBankLogin(SyncBankLoginRequestBody body, String customID) {
        String bankVersionID = body.getBankVersionID();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankVersionID), (Object)ResManager.loadKDString((String)"\u6240\u5c5e\u94f6\u884c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6240\u5c5e\u94f6\u884c\u3002", (String)"SyncBankLoginMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Collection bankVersions = BankBundleManager.getInstance().getBankVersions();
        String bankVersionName = "";
        if (bankVersionID != null) {
            for (BankVersion b : bankVersions) {
                if (!bankVersionID.equalsIgnoreCase(b.getBankVersionID())) continue;
                bankVersionName = b.getBankVersionName();
                break;
            }
        }
        if (StringUtils.isEmpty((String)bankVersionName)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f53\u524d\u94f6\u884c[%s]\u3002", (String)"SyncBankLoginMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID));
        }
        List<BankLoginConfig> bankLoginConfigs = this.validAndSetVal(body.getConfigs(), bankVersionID);
        SyncBankLoginResponseBody result = this.bankLoginConfigService.addNew(bankLoginConfigs, bankVersionID, bankVersionName, customID);
        return result;
    }

    public SyncBankLoginResponseBody updBankLogin(SyncBankLoginRequestBody body, String customID) {
        String bankLoginID = body.getBankLoginID();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankLoginID), (Object)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u524d\u7f6e\u673a\u3002", (String)"SyncBankLoginMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        this.bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
        BankLogin bankLogin = this.bankLoginService.getByCustomIdAndLoginId(customID, bankLoginID);
        if (bankLogin == null || bankLogin.getKey() == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6b64\u524d\u7f6e\u673a\u4e0d\u5b58\u5728[%s]\u3002", (String)"SyncBankLoginMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]), bankLoginID));
        }
        List<BankLoginConfig> bankLoginConfigs = this.validAndSetVal(body.getConfigs(), bankLogin.getBankVersionId());
        this.bankLoginConfigService.update(bankLoginConfigs, bankLoginID, customID);
        SyncBankLoginResponseBody result = new SyncBankLoginResponseBody();
        result.setBankLoginID(bankLoginID);
        result.setBankLoginName(bankLogin.getBankLoginName());
        return result;
    }

    List<BankLoginConfig> validAndSetVal(List<SyncBankLoginConfig> paramConfigs, String bankVersionID) {
        HashMap configParamsMap = new HashMap(16);
        paramConfigs.forEach(c -> configParamsMap.put(c.getBankConfigID(), c.getBankConfigValue()));
        List bankLoginConfigs = BankBundleManager.getInstance().getBankLoginConfig(bankVersionID);
        ArrayList<BankLoginConfig> result = new ArrayList<BankLoginConfig>(1);
        bankLoginConfigs.stream().forEach(c -> {
            String value = (String)configParamsMap.get(c.getKey().getBankConfigId());
            if (!c.getNullable().booleanValue() && StringUtils.isEmpty((String)c.getBankConfigValue()) && StringUtils.isEmpty((String)value) && !EBContext.getContext().isUnitTest()) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5[%2$s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SyncBankLoginMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]), c.getBankConfigName(), c.getKey().getBankConfigId()));
            }
            BankLoginConfig bankLoginConfig = new BankLoginConfig();
            FieldUtils.fieldsCopy((Object)c, (Object)bankLoginConfig);
            bankLoginConfig.setMlDescs(c.getMlDescs());
            bankLoginConfig.setSourceNames(c.getSourceNames());
            bankLoginConfig.setSourceValues(c.getSourceValues());
            bankLoginConfig.setMlSourceNames(c.getMlSourceNames());
            if (StringUtils.isEmpty((String)bankLoginConfig.getBankConfigValue()) && !StringUtils.isEmpty((String)value)) {
                bankLoginConfig.setBankConfigValue(value);
            }
            bankLoginConfig.getKey().setBankVersionId(bankVersionID);
            result.add(bankLoginConfig);
        });
        return result;
    }

    SyncBankLoginResponseBody updateCert(SyncBankLoginRequestBody body, String customID) {
        String bankVersionID;
        String bankLoginID = body.getBankLoginID();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankLoginID), (Object)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u524d\u7f6e\u673a\u3002", (String)"SyncBankLoginMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        this.bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
        BankLogin bankLogin = this.bankLoginService.getByCustomIdAndLoginId(customID, bankLoginID);
        if (bankLogin == null || bankLogin.getKey() == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6b64\u524d\u7f6e\u673a\u4e0d\u5b58\u5728[%s]\u3002", (String)"SyncBankLoginMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]), bankLoginID));
        }
        switch (bankVersionID = bankLogin.getBankVersionId()) {
            case "CMB_OPA": {
                this.updateCMBCert(bankLogin.getKey().getBankLoginId(), customID, body.getConfigs(), "CMB_OPA");
                break;
            }
            case "CMB_ECNY": {
                this.updateCMBCert(bankLogin.getKey().getBankLoginId(), customID, body.getConfigs(), "CMB_ECNY");
                break;
            }
            default: {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u94f6\u884c\u66f4\u65b0\u5e73\u53f0\u7ea7\u8bc1\u4e66[%s]\u3002", (String)"SyncBankLoginMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID));
            }
        }
        SyncBankLoginResponseBody result = new SyncBankLoginResponseBody();
        result.setBankLoginID(bankLogin.getKey().getBankLoginId());
        result.setBankLoginName(bankLogin.getBankLoginName());
        return result;
    }

    void updateCMBCert(String bankLoginID, String customID, List<SyncBankLoginConfig> paramConfigs, String bankVersion) {
        DynamicObject[] dynamicObjects = this.userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
        String source = CertSource.SYSTEM.getSource() + "";
        String certType = CertTypeEnum.PLATEFORM.getType() + "";
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                map.put(dynamicObject.getString("bank_config_id"), dynamicObject);
            }
            for (SyncBankLoginConfig syncBankLoginConfig : paramConfigs) {
                DynamicObject dynamicObject = (DynamicObject)map.get(syncBankLoginConfig.getBankConfigID());
                String value = syncBankLoginConfig.getBankConfigValue();
                if (dynamicObject == null) {
                    this.userCertRepository.addBankLoginCert(syncBankLoginConfig.getBankConfigID(), "", bankVersion, bankLoginID, customID, value, "", source, certType);
                    continue;
                }
                this.userCertRepository.updateBankLoginCert(dynamicObject, syncBankLoginConfig.getBankConfigID(), "", bankVersion, bankLoginID, customID, value, "", source, certType);
            }
        } else {
            for (SyncBankLoginConfig syncBankLoginConfig : paramConfigs) {
                String value = syncBankLoginConfig.getBankConfigValue();
                this.userCertRepository.addBankLoginCert(syncBankLoginConfig.getBankConfigID(), "", bankVersion, bankLoginID, customID, value, "", source, certType);
            }
        }
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "syncBankLogin";
    }
}

