/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.intercept;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.intercept.IPayControl;
import kd.ebg.aqap.business.payment.intercept.PayControlStrategyEnum;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;

@Component
public class PayControlFactory {
    @Autowired
    private List<IPayControl> controls;

    public static PayControlFactory getInstance() {
        return (PayControlFactory)SpringContextUtil.getBean(PayControlFactory.class);
    }

    public IPayControl getPayControl(PayControlStrategyEnum strategy) {
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)strategy), (Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63a7\u5236\u7b56\u7565\u3002", (String)"PayControlFactory_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        for (IPayControl control : this.controls) {
            if (control.getStrategy() != strategy) continue;
            return control;
        }
        throw new NullPointerException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u63a7\u5236\u7b56\u7565\u7684\u5904\u7406\u7c7b\uff0c\u7b56\u7565\uff1a", (String)"PayControlFactory_1", (String)"ebg-aqap-business", (Object[])new Object[0]), new Object[]{strategy}));
    }
}

