/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.LinkPayStepHelper;
import kd.ebg.aqap.business.payment.utils.QueryPaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import org.slf4j.MDC;

public class BankQueryPayTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryPayTask.class);
    public static final String LINK_PAY = "linkpay";
    private BankPayRequest request;
    private EBContext context;

    public BankQueryPayTask(BankPayRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankPayResponse response = this.submitQueryPay(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankPayResponse submitQueryPay(BankPayRequest request, EBContext context) {
        AccessUtils.checkPaymentAllowed(context);
        String bizSeqID = request.getBankBatchSeqID();
        context.setBizSeqID(bizSeqID);
        EBContext.setContext((EBContext)context);
        try {
            FEPAccess access;
            List<Object> result;
            boolean isUserHandled;
            block23: {
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u540c\u6b65\u4ed8\u6b3e\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                this.logger.info("\u5f00\u59cb\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001");
                isUserHandled = Boolean.parseBoolean(RequestContextUtils.getRunningParam((String)"isUserHandled"));
                List<Object> paymentInfos = request.getPaymentInfos();
                if (!isUserHandled) {
                    if ((paymentInfos = paymentInfos.stream().filter(info -> info.getStatus().intValue() == PaymentState.UNKNOWN.getId() || info.getStatus().intValue() == PaymentState.SUBMITTING.getId() || info.getStatus().intValue() == PaymentState.SUBMITED.getId()).collect(Collectors.toList())).isEmpty()) {
                        this.logger.info("\u5f53\u524d\u6279\u6b21\u4e0d\u5b58\u5728\u53ef\u8fdb\u884c\u67e5\u8be2\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e2d\u65ad\u672c\u6b21\u6267\u884c");
                        EBBankPayResponse eBBankPayResponse = null;
                        return eBBankPayResponse;
                    }
                    LocalDateTime lastQueryTime = ((PaymentInfo)paymentInfos.get(0)).getLastSyncTime();
                    int sec = this.getQueryPayIntervalSec();
                    if (Objects.nonNull(lastQueryTime) && LocalDateTime.now().minusSeconds(sec).isBefore(lastQueryTime)) {
                        this.logger.info(sec + "\u79d2\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2\uff0c\u4e2d\u65ad\u672c\u6b21\u6267\u884c");
                        EBBankPayResponse eBBankPayResponse = null;
                        return eBBankPayResponse;
                    }
                }
                result = null;
                String bankVersionID = context.getBankVersionID();
                String implClassName = paymentInfos.get(0).getQueryImplClassName();
                IQueryPay queryPay = (IQueryPay)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IQueryPay.class, implClassName);
                EBGBusinessUtils.setPaymentUpdateTimeAndStatus(paymentInfos, LocalDateTime.now());
                result = paymentInfos;
                request.setPaymentInfos(paymentInfos);
                access = null;
                try {
                    EBContext.initParameter();
                    MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                    this.logger.info("\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u4efb\u52a1\u51c6\u5907\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c\u4ed8\u6b3e\u6279\u6b21\u53f7{}", (Object)((PaymentInfo)paymentInfos.get(0)).getBatchSeqID());
                    access = FEPAccessUtil.access((String)bankVersionID, (String)context.getBankLoginID());
                    if (!AccessUtils.isPaymentAllowed(context)) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u901a\u9053\u5173\u95ed\uff0c\u7981\u6b62\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"BankQueryPayTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    }
                    this.logger.info("\u4ed8\u6b3e\u6279\u6b21\u53f7{}\u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c", (Object)((PaymentInfo)paymentInfos.get(0)).getBatchSeqID());
                    EBBankPayResponse response = queryPay.queryPay(request);
                    if (EBContext.getContext().getThrowableAfterSend() != null) {
                        Throwable t = EBContext.getContext().getThrowableAfterSend();
                        EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.UNKNOWN, MultiLang.getUnknownStatusTip(), "", t.getMessage());
                        break block23;
                    }
                    if (response == null) {
                        throw new IllegalStateException(MultiLang.getReturnNotEmptyTip());
                    }
                    if (response.getPaymentInfos() == null) {
                        throw new IllegalStateException(ResManager.loadKDString((String)"\u8fd4\u56de\u7684 \u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankQueryPayTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    }
                    result = response.getPaymentInfos();
                }
                catch (Throwable e) {
                    try {
                        if (e instanceof EBPayUnknownException) {
                            EBPayUnknownException payUnknownException = (EBPayUnknownException)e;
                            this.logger.error(payUnknownException.getMessage(), e);
                            EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.UNKNOWN, MultiLang.getUnknownStatusTip(), "", payUnknownException.getMessage());
                        }
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        this.logger.error("\u67e5\u8be2\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    }
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            LocalDateTime queryTime = LocalDateTime.now();
            for (PaymentInfo eBBankPayResponse : result) {
                eBBankPayResponse.setLastSyncTime(queryTime);
                eBBankPayResponse.setUpdateTime(queryTime);
                eBBankPayResponse.setLastSyncRequestReq(context.getRequestSeqID());
                boolean isSchedule = context.isScheduleJob();
                if (isSchedule && !isUserHandled && this.isWorkingTime()) {
                    eBBankPayResponse.addSyncCount();
                }
                if (eBBankPayResponse.getStatus().intValue() != PaymentState.SUCCESS.getId()) continue;
                eBBankPayResponse.setPayFinishDate(LocalDate.now());
            }
            PaymentInfoService.getInstance().save(result);
            QueryPaymentUtil.secondCheckPayStatus(result);
            if ("linkPay".equalsIgnoreCase(context.getSubBizName())) {
                ArrayList<Object> linkPaymentInfos = new ArrayList<Object>(result);
                LinkPayStepHelper.doNextStep(linkPaymentInfos);
            }
            EBBankPayResponse response = new EBBankPayResponse();
            response.setHeader(request.getHeader());
            response.setPaymentInfos(request.getPaymentInfos());
            response.setBankBatchSeqID(request.getBankBatchSeqID());
            EBBankPayResponse eBBankPayResponse = response;
            return eBBankPayResponse;
        }
        catch (Throwable e) {
            this.logger.error("\u67e5\u8be2\u4ed8\u6b3e\u51fa\u6765\u5462\u5f02\u5e38\uff0c\u7ec8\u6b62\u67e5\u8be2\u4ed8\u6b3e\u6d41\u7a0b", e);
            EBBankPayResponse eBBankPayResponse = null;
            return eBBankPayResponse;
        }
        finally {
            CachePayStorage.release(bizSeqID);
        }
    }

    private boolean isWorkingTime() {
        LocalDateTime now = LocalDateTime.now();
        int hour = now.getHour();
        int week = now.getDayOfWeek().getValue();
        return week >= 1 && week <= 5 && hour >= 6 && hour <= 17;
    }

    private int getQueryPayIntervalSec() {
        return SystemPropertyConfig.getQueryPayTimeLimit();
    }
}

