/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.JsonUtil;

public class PayStatusMatchUtil {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(PayStatusMatchUtil.class);
    public static final String HASH_SET_KEYS = "HashSetKeys";
    public static final String BANK_DATA_MAP = "bankDateMap";

    public static void preBatchSameItemCheck(List<PaymentInfo> paymentInfos, boolean isContainSeq, boolean isContainExp) {
        PayStatusMatchUtil.preBatchSameItemCheck(paymentInfos, true, isContainSeq, isContainExp);
    }

    public static void preBatchSameItemCheck(List<PaymentInfo> paymentInfos, boolean isContainIncomeName, boolean isContainSeq, boolean isContainExp) {
        EBContext context = EBContext.getContext();
        HashMap<String, Set<String>> batchQueryPayTempData = (HashMap<String, Set<String>>)context.getResult();
        if (batchQueryPayTempData == null) {
            batchQueryPayTempData = new HashMap<String, Set<String>>(16);
            Set<String> HashSetKeys = PayStatusMatchUtil.getHashSetKeys(paymentInfos, isContainIncomeName, isContainSeq, isContainExp);
            if (HashSetKeys.size() > 0) {
                batchQueryPayTempData.put(HASH_SET_KEYS, HashSetKeys);
                context.setResult(batchQueryPayTempData);
            }
        }
    }

    public static Set<String> getHashSetKeys(List<PaymentInfo> paymentInfos, boolean isContainSeq, boolean isContainExp) {
        return PayStatusMatchUtil.getHashSetKeys(paymentInfos, true, isContainSeq, isContainExp);
    }

    public static Set<String> getHashSetKeys(List<PaymentInfo> paymentInfos, boolean isContainIncomeName, boolean isContainSeq, boolean isContainExp) {
        ArrayList<String> keyList = new ArrayList<String>(16);
        HashSet<String> finalHashSetKeys = new HashSet<String>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            String key = PayStatusMatchUtil.getKeyByPaymentInfo(paymentInfo, isContainIncomeName, isContainSeq, isContainExp);
            if (keyList.contains(key)) {
                finalHashSetKeys.add(key);
            }
            keyList.add(key);
        }
        logger.info("\u5f85\u8865\u507f\u66f4\u65b0\u4ed8\u6b3e\u7684\u4e3b\u952e:{}", (Object)JsonUtil.toJson(finalHashSetKeys));
        return finalHashSetKeys;
    }

    public static String getKeyByPaymentInfo(PaymentInfo info, boolean isContainSeq, boolean isContainExp) {
        return PayStatusMatchUtil.getKeyByPaymentInfo(info, true, isContainSeq, isContainExp);
    }

    private static String getKeyByPaymentInfo(PaymentInfo info, boolean isContainIncomeName, boolean isContainSeq, boolean isContainExp) {
        StringBuilder buffer = new StringBuilder();
        String incomeName = info.getIncomeAccName();
        if (!isContainIncomeName) {
            incomeName = "";
        }
        if (isContainSeq) {
            buffer.append(info.getBankSerialNo());
        }
        buffer.append(info.getIncomeAccNo()).append(incomeName).append(info.getAmount());
        if (isContainExp) {
            buffer.append(info.getExplanation());
        }
        return buffer.toString();
    }

    public static void backBatchSameItemHandler(List<PaymentInfo> paymentInfos, boolean isContainSeq, boolean isContainExp) {
        PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, true, isContainSeq, isContainExp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backBatchSameItemHandler(List<PaymentInfo> paymentInfos, boolean isContainIncomeName, boolean isContainSeq, boolean isContainExp) {
        EBContext context = EBContext.getContext();
        if (context == null) {
            return;
        }
        try {
            Set HashSetKeys;
            logger.info("\u8fdb\u5165\u540e\u7f6e\u6279\u91cf\u72b6\u6001\u5339\u914d\u65b9\u6cd5");
            Map batchQueryPayTempData = (Map)context.getResult();
            if (batchQueryPayTempData != null && (HashSetKeys = (Set)batchQueryPayTempData.get(HASH_SET_KEYS)).size() > 0) {
                Map bankDataMap = (Map)batchQueryPayTempData.get(BANK_DATA_MAP);
                block5: for (PaymentInfo info : paymentInfos) {
                    List list;
                    String key = PayStatusMatchUtil.getKeyByPaymentInfo(info, isContainIncomeName, isContainSeq, isContainExp);
                    if (!HashSetKeys.contains(key)) continue;
                    EBGBusinessUtils.setPaymentState(info, PaymentState.SUBMITED, "", "", "");
                    if (bankDataMap == null || (list = (List)bankDataMap.get(key)) == null || list.size() <= 0) continue;
                    for (PaymentInfo tempInfo : list) {
                        PaymentState paymentState;
                        if (tempInfo.getToGiveUp() != null && tempInfo.getToGiveUp().booleanValue() || (paymentState = PaymentState.getEnumById((int)tempInfo.getStatus())) == PaymentState.ERROR) continue;
                        EBGBusinessUtils.setPaymentState(info, paymentState, tempInfo.getErrorMsg(), tempInfo.getBankStatus(), tempInfo.getBankMsg());
                        tempInfo.setToGiveUp(Boolean.valueOf(true));
                        continue block5;
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u4ed8\u6b3e\u540e\u7f6e\u5904\u7406\u51fa\u73b0\u62a5\u9519\uff1a" + e.getMessage(), e);
        }
        finally {
            context.setResult(null);
        }
    }
}

