/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.service.balance.BalanceImpl;
import kd.ebg.aqap.banks.gdb.dc.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.gdb.dc.service.detail.DetailImpl;
import kd.ebg.aqap.banks.gdb.dc.service.detail.DetailPageImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.authorized.AuthorizedPayImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.authorized.AuthorizedQueryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.otherBank.ForceCompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.otherBank.NoForceCompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.samebank.CompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class GDBDCMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String BANK_VERSION_ID = "GDB_DC";
    public static String PublicKey = "public_key";
    public static final String CST_NO = "cst_no";
    public static String MAC_ADD = "MAC_ADD";
    public static final String CUST_NO = "CUST_NO";
    public static final String OPERATOR = "OPERATOR";
    public static final String CIPH = "PASSWORD";
    public static final String TEST_DATE = "TEST_DATE";
    public static final String APP_ID = "APP_ID";
    public static String CHARSET_NOTE = "CHARSET_NOTE";

    public void baseConfigInit() {
        this.setExchangeProtocol("TCP", false);
        this.setTimeOut(3);
        this.setCharSet("GBK");
        this.builder().ipDesc(new MultiLangEnumBridge("\u5b89\u88c5\u5e7f\u53d1\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\u7684\u670d\u52a1\u5668IP", "GDBDCMetaDataImpl_0", "ebg-aqap-banks-gdb-dc")).portDesc(new MultiLangEnumBridge("\u5e7f\u53d1\u94f6\u884c\u524d\u7f6e\u673a\u8bbe\u7f6e\u7684\u901a\u8baf\u7aef\u53e3\u53f7", "GDBDCMetaDataImpl_1", "ebg-aqap-banks-gdb-dc")).build();
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c", (String)"GDBDCMetaDataImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        this.setBankVersionID(BANK_VERSION_ID);
        this.setBankShortName("GDB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c\u76f4\u8054\u7248", (String)"GDBDCMetaDataImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c", (String)"GDBDCMetaDataImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CUST_NO, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f51\u94f6\u5ba2\u6237\u53f7", "GDBDCMetaDataImpl_4", "ebg-aqap-banks-gdb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6807\u8bc6\u4f01\u4e1a\u8eab\u4efd\uff0c\u4e0e\u7f51\u94f6\u7684\u5ba2\u6237\u53f7\u4e00\u81f4\u3002", "GDBDCMetaDataImpl_5", "ebg-aqap-banks-gdb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)OPERATOR, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5458", "GDBDCMetaDataImpl_6", "ebg-aqap-banks-gdb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5728\u7f51\u4e0a\u94f6\u884c\u7684\u5404\u79cd\u7ea7\u522b\u64cd\u4f5c\u5458\u7684\u767b\u5f55\u540d\uff0c\u8f6c\u8d26\u4ea4\u6613\u9650\u5b9a\u4e3a'\u64cd\u4f5c\u590d\u6838\u5458'", "GDBDCMetaDataImpl_7", "ebg-aqap-banks-gdb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)CIPH, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5458\u5bc6\u7801", "GDBDCMetaDataImpl_8", "ebg-aqap-banks-gdb-dc"), (String)"", (boolean)false, (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)TEST_DATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u6d4b\u8bd5\u7cfb\u7edf\u65e5\u671f", "GDBDCMetaDataImpl_9", "ebg-aqap-banks-gdb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u6d4b\u8bd5\u670d\u52a1\u5668\u65e5\u671f\u975e\u5f53\u524d\u7cfb\u7edf\u65e5\u671f\u65f6\u8bbe\u7f6e\uff0c\u7528\u4e8e\u6d4b\u8bd5\u67e5\u8be2\u4ed8\u6b3e\u7ed3\u679c\uff0c\u6b63\u5f0f\u73af\u5883\u7559\u7a7a\u3002", "GDBDCMetaDataImpl_10", "ebg-aqap-banks-gdb-dc"), (String)"", (boolean)false, (boolean)true).set2Date8()});
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)PublicKey, (String)ResManager.loadKDString((String)"\u5ba2\u6237\u516c\u94a5\u6587\u4ef6", (String)"GDBDCMetaDataImpl_13", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true, (String)"upload"), BankLoginConfigUtil.getBankLoginConfig((String)APP_ID, (String)ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u53f7", (String)"GDBDCMetaDataImpl_17", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)MAC_ADD, (String)ResManager.loadKDString((String)"MAC\u5730\u5740", (String)"GDBDCMetaDataImpl_18", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)CST_NO, (String)ResManager.loadKDString((String)"\u7535\u7968\u4f01\u4e1a\u5ba2\u6237\u53f7", (String)"GDBDCMetaDataImpl_14", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true)});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.NOTE_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.NOTE_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        ArrayList configsNote = Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CHARSET_NOTE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7535\u7968\u5b57\u7b26\u96c6", "GDBDCMetaDataImpl_20", "ebg-aqap-banks-gdb-dc"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5b57\u7b26\u96c6\u9009\u62e9\uff0c\u6839\u636e\u5b9e\u9645\u94f6\u884c\u63d0\u4f9b\u7684\u5b57\u7b26\u96c6\u9009\u62e9:", "GDBDCMetaDataImpl_21", "ebg-aqap-banks-gdb-dc"), new MultiLangEnumBridge("1\uff09GBK\uff0c\u9ed8\u8ba4\u9009\u9879\uff1b", "GDBDCMetaDataImpl_22", "ebg-aqap-banks-gdb-dc"), new MultiLangEnumBridge("2\uff09UTF-8,\u5f53\u7535\u7968\u5b57\u7b26\u96c6\u4e0e\u67e5\u8be2\u652f\u4ed8\u4e0d\u4e00\u81f4\u65f6\u9009\u62e9\uff1b", "GDBDCMetaDataImpl_23", "ebg-aqap-banks-gdb-dc")}), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("GBK", "", ""), new MultiLangEnumBridge("UTF-8", "", "")}), (List)Lists.newArrayList((Object[])new String[]{"GBK", "UTF-8"}), (String)"GBK", (boolean)false, (boolean)false)});
        configsNote.stream().map(b -> {
            b.setType(MetaDataConfigType.NOTE_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configsNote);
        return loginConfigs;
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, HisBalanceImpl.class, DetailImpl.class, AuthorizedPayImpl.class, AuthorizedQueryPayImpl.class, SalaryPayImpl.class, SalaryQueryPayImpl.class, ForceCompanyPaymentImpl.class, CompanyQueryPayImpl.class, DetailPageImpl.class, PretreatmentImpl.class, CompanyPaymentImpl.class, NoForceCompanyPaymentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("dealDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("reserve2", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

