/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.service.payment.authorized.AuthorizedPayImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.otherBank.ForceCompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.otherBank.NoForceCompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.samebank.CompanyPaymentImpl;
import kd.ebg.aqap.banks.gdb.dc.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (this.isIncome(paymentInfo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6279\u6263\u4e1a\u52a1\u3002", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        }
        if (this.isPay_for_salary(paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            if (this.isPaymentByAuthorized()) {
                this.setImplClassName(paymentInfo, AuthorizedPayImpl.class.getName());
            } else if (this.isPaymentByNormal()) {
                this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
            }
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(false));
            this.setCompanyPayment(paymentInfo);
        } else if (this.isPay(paymentInfo) || this.isPay_for_linkPay(paymentInfo)) {
            this.setCompanyPayment(paymentInfo);
        }
        return busiImplInfo;
    }

    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    private void setCompanyPayment(PaymentInfo paymentInfo) {
        if (this.isSameBank(paymentInfo)) {
            this.setImplClassName(paymentInfo, CompanyPaymentImpl.class.getName());
        } else if (this.isForce(paymentInfo)) {
            this.setImplClassName(paymentInfo, ForceCompanyPaymentImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, NoForceCompanyPaymentImpl.class.getName());
        }
    }

    private boolean isPaymentByAuthorized() {
        return this.assertBusinessConfig("gdb_dc_payment_model", "payment_authorized");
    }

    private boolean isPaymentByNormal() {
        return this.assertBusinessConfig("gdb_dc_payment_model", "payment_normal");
    }
}

