/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment.salary;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.banks.gdb.dc.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "1030";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u540c\u6b65", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "1030", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        String businessType = "2";
        businessType = "0".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo())) ? "3" : ("1".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo())) ? "1" : ("2".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo())) ? "2" : ("3".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo())) ? (paymentInfo.getExplanation().indexOf(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0])) != -1 ? "3" : (paymentInfo.getExplanation().indexOf(ResManager.loadKDString((String)"\u62a5\u9500", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0])) != -1 ? "1" : "2")) : "2")));
        JDomUtils.addChild((Element)body, (String)"businessType", (String)businessType);
        JDomUtils.addChild((Element)body, (String)"customerBatchNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"customerSalarySeq", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
            Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
            if (body != null) {
                Element records = JDomUtils.getChildElement((Element)body, (String)"records");
                if (records != null) {
                    List recordList = records.getChildren("record");
                    HashMap<String, String> resultMap = new HashMap<String, String>(16);
                    HashMap<String, String> errorReasonMap = new HashMap<String, String>(16);
                    this.parseMessageFromBank(recordList, resultMap, errorReasonMap);
                    for (PaymentInfo info : paymentInfos) {
                        String flag = (String)resultMap.get(info.getBankDetailSeqId());
                        if (StringUtils.isEmpty((String)flag)) continue;
                        String errorReason = (String)errorReasonMap.get(info.getBankDetailSeqId());
                        if ("1".equalsIgnoreCase(flag)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)flag, (String)errorReason);
                            continue;
                        }
                        if ("0".equalsIgnoreCase(flag)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)flag, (String)errorReason);
                            continue;
                        }
                        if ("4".equalsIgnoreCase(flag)) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)flag, (String)errorReason);
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)flag, (String)errorReason);
                    }
                } else {
                    log.info("\u94f6\u884c\u8fd4\u56de records \u8282\u70b9\u4e3a\u7a7a");
                }
            } else {
                log.info("\u94f6\u884c\u8fd4\u56de body \u8282\u70b9\u4e3a\u7a7a");
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void parseMessageFromBank(List<Element> recordList, Map<String, String> result, Map<String, String> errorReason) {
        for (Element record : recordList) {
            String customerSalarySeq = JDomUtils.getChildTextTrim((Element)record, (String)"customerSalarySeq");
            String flag = JDomUtils.getChildTextTrim((Element)record, (String)"flag");
            String errorMsg = JDomUtils.getChildTextTrim((Element)record, (String)"errorMsg");
            result.put(customerSalarySeq, flag);
            errorReason.put(customerSalarySeq, errorMsg);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

