/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.sign.sign;

import kd.ebg.aqap.banks.pab.opa.sign.sign.ISign;
import kd.ebg.aqap.banks.pab.opa.sign.sign.SignUtil;

public abstract class AbstractSign
implements ISign {
    private String hashAlg = "SHA1";

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public byte[] hashAndSign(byte[] data) throws Exception {
        byte[] hash = SignUtil.digest(data, this.hashAlg);
        return this.sign(hash);
    }

    @Override
    public byte[] hashAndSign(String srcFile) throws Exception {
        byte[] hash = SignUtil.digest(srcFile, this.hashAlg);
        return this.sign(hash);
    }

    @Override
    public boolean hashAndVerify(byte[] src, byte[] signData) throws Exception {
        byte[] hash = SignUtil.digest(src, this.hashAlg);
        return this.verify(hash, signData);
    }

    @Override
    public boolean hashAndVerify(String srcFile, byte[] signData) throws Exception {
        byte[] hash = SignUtil.digest(srcFile, this.hashAlg);
        return this.verify(hash, signData);
    }

    @Override
    public String getHashAlg() {
        return this.hashAlg;
    }

    @Override
    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }
}

