/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.sign.sign.signcfca;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.CertUtil;
import com.cfca.util.pki.api.KeyUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Set;
import kd.ebg.aqap.banks.pab.opa.sign.Exception.CodeAndMsgException;
import kd.ebg.aqap.banks.pab.opa.sign.Exception.ErrorInfo;
import kd.ebg.aqap.banks.pab.opa.sign.sign.AbstractSign;
import kd.ebg.aqap.banks.pab.opa.sign.sign.signcfca.CertDNVerifer;
import kd.ebg.aqap.banks.pab.opa.sign.sign.signcfca.IbpsSigner;
import kd.ebg.aqap.banks.pab.opa.sign.util.StringTool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CfcaSign
extends AbstractSign {
    private static final Log log = LogFactory.getLog(CfcaSign.class);
    private Session pkiSession;
    private CertDNVerifer verifyTool;
    private IbpsSigner signerTool;
    private String caCertPath;
    private byte[] caCertData;
    private String crlPath;
    private String pfxPath;
    private byte[] pfxData;
    private String pfxPwd;
    private boolean checkCert = true;
    private Set<String> verifyCertDNs;

    public void init() throws Exception {
        log.info((Object)"\u9a8c(\u7b7e)\u540d\u5de5\u5177\u521d\u59cb\u5316...");
        Provider bcProvider = Security.getProvider("BC");
        if (bcProvider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            this.pkiSession = jcrypto.openSession("JSOFT_LIB");
        }
        catch (PKIException e) {
            log.error((Object)("\u521d\u59cb\u5316\u5f02\u5e38:" + StringTool.getErrorStack(e)));
            throw e;
        }
        if (this.pfxData != null) {
            X509Cert cert = CertUtil.getCert((byte[])this.pfxData, (String)this.pfxPwd);
            JKey key = KeyUtil.getPriKey((byte[])this.pfxData, (String)this.pfxPwd);
            this.signerTool = new IbpsSigner(this.pkiSession, key, cert);
            log.info((Object)("\u79c1\u6709\u8bc1\u4e66: " + cert.getSubject()));
        } else {
            log.info((Object)"\u672a\u8bbe\u7f6e\u8f6f\u7b7e\u540d\u8bc1\u4e66");
        }
        this.verifyTool = new CertDNVerifer(this.pkiSession);
        this.verifyTool.setCheckCert(this.checkCert);
        if (this.checkCert) {
            if (this.caCertData != null) {
                try {
                    X509Cert[] caCerts = CertUtil.parseP7b((byte[])this.caCertData);
                    for (int i = 0; i < caCerts.length; ++i) {
                        log.info((Object)("Ca\u8bc1\u4e66[" + (i + 1) + "]: " + caCerts[i].getSubject()));
                    }
                    this.verifyTool.setCaCerts(caCerts);
                }
                catch (Exception e) {
                    log.error((Object)("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u5f02\u5e38:" + StringTool.getErrorStack(e)));
                    throw e;
                }
            } else {
                log.error((Object)"\u521d\u59cb\u5316\u5f02\u5e38:\u672a\u8bbe\u7f6e\u8bc1\u4e66\u94fe");
            }
            if (this.crlPath != null) {
                ByteArrayOutputStream bou = null;
                FileInputStream is = null;
                try {
                    is = new FileInputStream(this.crlPath);
                    bou = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int readed = -1;
                    while ((readed = ((InputStream)is).read(buffer)) != -1) {
                        bou.write(buffer, 0, readed);
                    }
                    X509CRL crl = new X509CRL(bou.toByteArray());
                    this.verifyTool.setCrl(crl);
                }
                catch (Exception e) {
                    log.error((Object)("\u521d\u59cb\u5316\u540a\u9500\u5217\u8868\u5931\u8d25\uff1a" + StringTool.getErrorStack(e)));
                    throw e;
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Exception exception) {}
                    }
                    if (bou != null) {
                        try {
                            bou.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            log.info((Object)"\u672a\u8bbe\u7f6eCRL\u8bc1\u4e66.");
            if (this.verifyCertDNs == null || this.verifyCertDNs.size() == 0) {
                log.info((Object)"\u521d\u59cb\u5316\u5f02\u5e38:\u672a\u8bbe\u7f6e\u9a8c\u7b7e\u8bc1\u4e66DN");
            } else {
                log.info((Object)("\u6388\u6743\u8bc1\u4e66\uff1a" + this.verifyCertDNs.toString()));
                this.verifyTool.setDns(this.verifyCertDNs);
            }
        } else {
            log.info((Object)"\u8f6f\u9a8c\u7b7e\u4e0d\u6821\u9a8c\u8bc1\u4e66");
        }
        log.info((Object)"\u9a8c(\u7b7e)\u540d\u5de5\u5177\u521d\u59cb\u5316\u7ed3\u675f.");
    }

    @Override
    public byte[] getCert() throws Exception {
        this.checkSignInit();
        X509Cert cert = this.signerTool.getCert();
        return cert.getEncoded();
    }

    @Override
    public String getSubjectDN() throws Exception {
        this.checkSignInit();
        X509Cert cert = this.signerTool.getCert();
        return cert.getSubject();
    }

    @Override
    public byte[] sign(byte[] hash) throws Exception {
        this.checkSignInit();
        return this.signerTool.signMsg(hash, true);
    }

    @Override
    public boolean verify(byte[] hash, byte[] signData) throws Exception {
        this.checkVerifyInit();
        return this.verifyTool.verifyMsg(hash, signData, null, true);
    }

    private void checkSignInit() {
        if (this.signerTool == null) {
            log.error((Object)"\u8f6f\u7b7e\u540d\u5bf9\u8c61\u672a\u521d\u59cb\u5316");
            CodeAndMsgException exp = new CodeAndMsgException();
            exp.setErrorCode(ErrorInfo.get("Sign_CODE"));
            exp.setErrorMsg(ErrorInfo.get("Sign_NOINIT"));
            throw exp;
        }
    }

    private void checkVerifyInit() {
        if (this.verifyTool == null) {
            log.error((Object)"\u8f6f\u9a8c\u7b7e\u540d\u5bf9\u8c61\u672a\u521d\u59cb\u5316");
            CodeAndMsgException exp = new CodeAndMsgException();
            exp.setErrorCode(ErrorInfo.get("Sign_CODE"));
            exp.setErrorMsg(ErrorInfo.get("Sign_NOINIT"));
            throw exp;
        }
    }

    public String getCaCertPath() {
        return this.caCertPath;
    }

    public void setCaCertPath(String caCertPath) {
        this.caCertPath = caCertPath;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public void setCrlPath(String crlPath) {
        this.crlPath = crlPath;
    }

    public String getPfxPath() {
        return this.pfxPath;
    }

    public void setPfxPath(String pfxPath) {
        this.pfxPath = pfxPath;
    }

    public String getPfxPwd() {
        return this.pfxPwd;
    }

    public void setPfxPwd(String pfxPwd) {
        this.pfxPwd = pfxPwd;
    }

    public boolean isCheckCert() {
        return this.checkCert;
    }

    public void setCheckCert(boolean checkCert) {
        this.checkCert = checkCert;
    }

    public Set<String> getVerifyCertDNs() {
        return this.verifyCertDNs;
    }

    public void setVerifyCertDNs(Set<String> verifyCertDNs) {
        this.verifyCertDNs = verifyCertDNs;
    }

    public byte[] getPfxData() {
        return this.pfxData;
    }

    public void setPfxData(byte[] pfxData) {
        this.pfxData = pfxData;
    }

    public byte[] getCaCertData() {
        return this.caCertData;
    }

    public void setCaCertData(byte[] caCertData) {
        this.caCertData = caCertData;
    }
}

