/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolTodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(CashPoolTodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String crpseq = BankBusinessConfig.getCRPSEQ(accNo);
        String crscod = BankBusinessConfig.getCRSCOD(accNo);
        if (StringUtils.isEmpty((String)crpseq) || StringUtils.isEmpty((String)crscod)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u865a\u62df\u73b0\u91d1\u6c60\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\u4e3a:\u534f\u8bae\u7f16\u53f7[%1$s]\u6216\u5b50\u516c\u53f8\u534f\u8bae\u5e8f\u53f7[%2$s]\u4e3a\u7a7a\u3002", (String)"CashPoolTodayBalanceImpl_10", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), crscod, crpseq);
            EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String branchNo = CMBStore.getInstance().getAreaCode(acnt);
        Element root = CMB_DC_Packer.packRoot("GetAccInfo");
        Element sdkacinfx = JDomUtils.addChild((Element)root, (String)"SDKACINFX");
        JDomUtils.addChild((Element)sdkacinfx, (String)"BBKNBR", (String)branchNo);
        JDomUtils.addChild((Element)sdkacinfx, (String)"ACCNBR", (String)accNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element ntqacinfz = root.getChild("NTQACINFZ");
        String accNo = ntqacinfz.getChildTextTrim("ACCNBR");
        String balance = ntqacinfz.getChildTextTrim("ONLBLV");
        String usableBalance = ntqacinfz.getChildTextTrim("AVLBLV");
        String currType = ntqacinfz.getChildTextTrim("CCYNBR");
        String accBalance = ntqacinfz.getChildTextTrim("ACCBLV");
        String intcod = ntqacinfz.getChildText("INTCOD");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        balanceInfo.setLastDayAvlBalance(new BigDecimal("0.0"));
        this.setCurrentBalance(balanceInfo, accBalance);
        if ("S".equalsIgnoreCase(intcod)) {
            this.setAvailableBalance(balanceInfo, accBalance);
        } else {
            balanceInfo.setAvailableBalance(new BigDecimal(usableBalance).add(new BigDecimal(accBalance)));
        }
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), accNo);
        this.setBankCurrency(balanceInfo, request.getBankCurrency(), currType);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d75\u4fca\u5cf0", (String)"CashPoolTodayBalanceImpl_8", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "GetAccInfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u73b0\u91d1\u6c60\u8d26\u6237\u989d\u5ea6\u79ef\u6570\u67e5\u8be2", (String)"CashPoolTodayBalanceImpl_9", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }
}

