/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.aqap.common.framework.bank.meta.template.BaseMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public abstract class OPAMetaDataTemplate
extends BaseMetaDataTemplate {
    private String uri = "";
    public static String ZBankPD = "z_bank_pwd";
    public static String PrivateKey = "private_key";
    public static String PrivateKeySecret = "private_key_secret";
    public static String PublicKey = "public_key";
    public static String PublicKeySecret = "public_key_secret";

    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String dLockNum = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            if (!StringUtils.isEmpty((String)System.getProperty(dLockNum))) {
                concurrentCount = Integer.parseInt(System.getProperty(dLockNum));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).build();
    }

    @Override
    public List<BankVersionMetaInfo> getBankVersionExtMetaInfos() {
        this.metaDataInit();
        String fileName = this.bankVersionID + "_BankInfoExt.json";
        return this.initBankVersionMetaExtInfo(fileName);
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(1);
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getConcurrencyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginBanksConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BANKS_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankPGPConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PGP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginReceiptBaseConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getDeviceInfo();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.DEVICE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        return bankLoginConfig;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u670d\u52a1\u7f51\u5173\u5730\u5740", "OPAMetaDataTemplate_0", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b\u7684IP", "OPAMetaDataTemplate_1", "ebg-aqap-common"), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7aef\u53e3\u53f7", "OPAMetaDataTemplate_2", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b\u7684\u7aef\u53e3\u53f7", "OPAMetaDataTemplate_3", "ebg-aqap-common"), (String)this.port, (boolean)false, (boolean)false).set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)).set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeUri", (MultiLangEnumBridge)new MultiLangEnumBridge("URI\u8def\u5f84", "OPAMetaDataTemplate_4", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b\u7684\u8fde\u63a5\u5730\u5740\uff0c\u4f8b\u5982 https://IP:Port/frontend/channel/branch/bank-api-2\uff0cURI\u8def\u5f84\u53d6frontend/channel/branch/bank-api-2\u3002", "OPAMetaDataTemplate_15", "ebg-aqap-common"), (String)this.uri, (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "OPAMetaDataTemplate_5", "ebg-aqap-common"), (String)this.protocol, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"timeout", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d85\u65f6\u8bbe\u7f6e(\u5355\u4f4d\uff1a\u5206\u949f)", "OPAMetaDataTemplate_6", "ebg-aqap-common"), (String)String.valueOf(this.timeout), (boolean)false, (boolean)false).set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "OPAMetaDataTemplate_7", "ebg-aqap-common"), (String)this.charset, (boolean)true, (boolean)false)});
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        if (this.isUseBankPGPConfig()) {
            return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)PrivateKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u79c1\u94a5\u6587\u4ef6", "OPAMetaDataTemplate_10", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getMlBankLoginConfig((String)PrivateKeySecret, (MultiLangEnumBridge)new MultiLangEnumBridge("\u79c1\u94a5\u5bc6\u7801", "OPAMetaDataTemplate_11", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)PublicKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u516c\u94a5\u6587\u4ef6", "OPAMetaDataTemplate_12", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getMlBankLoginConfig((String)PublicKeySecret, (MultiLangEnumBridge)new MultiLangEnumBridge("\u516c\u94a5\u5bc6\u7801", "OPAMetaDataTemplate_13", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)ZBankPD, (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u4fe1\u5bc6\u7801", "OPAMetaDataTemplate_14", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)true)});
        }
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList();
    }

    public boolean isUseBankPGPConfig() {
        return true;
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return true;
    }

    public List<BankLoginConfig> getDeviceInfo() {
        return Lists.newArrayList();
    }
}

