/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.match;

import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.repository.DetailFieldConfRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailFieldUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailFieldUtil.class);
    public static final String INTERFACE_NAME = "interface_name";
    private DetailFieldConfRepository detailFieldConfRepository = SpringContextUtil.getBean(DetailFieldConfRepository.class);
    private static DetailFieldUtil instance;

    public static synchronized DetailFieldUtil getInstance() {
        if (instance == null) {
            instance = new DetailFieldUtil();
        }
        return instance;
    }

    public DetailFieldConf getDetailField(String bankVersion, String detailInterface) {
        String key = "eb_detail_field_" + bankVersion + "_" + detailInterface;
        String value = CosmicCache.get((String)key);
        DetailFieldConf detailFieldConf = null;
        if (StringUtils.isEmpty((String)value)) {
            detailFieldConf = this.detailFieldConfRepository.findByBankVersionAndInterface(bankVersion, detailInterface);
            if (detailFieldConf != null) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)SerializationUtils.toJsonString((Object)detailFieldConf), (int)1, (TimeUnit)TimeUnit.HOURS);
            }
        } else {
            detailFieldConf = (DetailFieldConf)SerializationUtils.fromJsonString((String)value, DetailFieldConf.class);
        }
        return detailFieldConf;
    }
}

