/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.PropertyChecker;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.properties.PropertyName;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.framework.lang.MultiLang;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

@Component
public class BankAcntPropertyConfig
implements PropertyConfig {
    static final PropertyConfigItem ACC_NO_TYPE = PropertyConfigItem.builder().key("bank_accType").mlName(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b", "BankAcntPropertyConfig_0", "ebg-aqap-common")).mlDesc(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b(\u666e\u901a\u7c7b\u3001\u8d22\u8d44\u7c7b\u3001\u5b9a\u671f\u6237\u7b49)", "BankAcntPropertyConfig_1", "ebg-aqap-common")).sourceNames(BankAcntPropertyConfig.getAccountTypeNameList(BankAcntPropertyConfig.getAccountTypeList())).sourceValues(BankAcntPropertyConfig.getAccountTypeList()).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).minValueNum(1).maxValueNum(1).mustInput(true).build();
    static final PropertyConfigItem HAS_RECEIPT = PropertyConfigItem.builder().key("has_receipt").mlName(new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u8d26\u53f7", "BankAcntPropertyConfig_2", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u542f\u7528\u8be5\u8d26\u53f7\u7684\u56de\u5355\u529f\u80fd", "BankAcntPropertyConfig_3", "ebg-aqap-common")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultFalse).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{trueFalseChecker})).mustInput(true).build();
    static final PropertyConfigItem COMPNO = PropertyConfigItem.builder().key("compNo").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684'\u5355\u4f4d\u7f16\u53f7'\uff08\u94f6\u884c\u63d0\u4f9b\uff09", "BankAcntPropertyConfig_4", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684'\u5355\u4f4d\u7f16\u53f7'\uff08\u94f6\u884c\u63d0\u4f9b\uff09", "BankAcntPropertyConfig_4", "ebg-aqap-common")})).defaultValues(null).build();
    public static PropertyConfigItem[] CONFIG_ITEMS = new PropertyConfigItem[]{ACC_NO_TYPE, HAS_RECEIPT, COMPNO};

    public static List<String> getAccountTypeNameList(List<String> itemList) {
        ArrayList<String> accountTypeList = new ArrayList<String>(16);
        for (String item : itemList) {
            accountTypeList.add(MultiLang.getAccountType((String)item));
        }
        return accountTypeList;
    }

    private static List<String> getAccountTypeList() {
        return Lists.newArrayList((Object[])new String[]{"normal", "caizi", "vcp", "fixed", "cash_pool", "notice", "vitual", "multilevel"});
    }

    @Override
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        return Lists.newArrayList((Object[])CONFIG_ITEMS);
    }

    @Override
    public String getPropertyConfigID() {
        return "NAN";
    }

    @Override
    public PropertyName getPropertyName() {
        return PropertyName.BANK_BUSINESS;
    }

    @Override
    public String getConfigName() {
        return ResManager.loadKDString((String)"\u8d26\u53f7\u914d\u7f6e", (String)"BankAcntPropertyConfig_5", (String)"ebg-aqap-common", (Object[])new Object[0]);
    }

    @Override
    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u8d26\u53f7\u901a\u7528\u914d\u7f6e", (String)"BankAcntPropertyConfig_6", (String)"ebg-aqap-common", (Object[])new Object[0]);
    }

    public static String getAccType(String accNo) {
        try {
            String objectID = ACC_NO_TYPE.getCurrentValueWithObjectID(accNo);
            if ("cash_pool".equalsIgnoreCase(objectID)) {
                objectID = "cashpool";
            }
            return objectID;
        }
        catch (Exception e) {
            return "normal";
        }
    }

    public static boolean isReceiptAccNo(String accNo) {
        try {
            boolean aTrue = HAS_RECEIPT.getCurrentValueWithObjectID(accNo).equalsIgnoreCase("true");
            return aTrue;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static String getCompNO(String accNo) {
        try {
            String currentValueWithObjectID = COMPNO.getCurrentValueWithObjectID(accNo);
            return currentValueWithObjectID;
        }
        catch (Exception e) {
            return null;
        }
    }
}

