/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.properties.PropertyChecker;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.properties.PropertyName;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lang.MultiLang;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.string.StrUtil;

public abstract class BankPropertyConfig
implements PropertyConfig {
    public static final String EnterpriseCode = "EnterpriseCode";
    public static final String bankAccType = "bank_accType";
    public static final String bankIsReceipt = "bank_isReceipt";
    public static final String bankAreaCode = "bank_area_code";
    public static final String bankCnap = "bank_cnap";
    public static final String bankSwiftCode = "bank_swift_code";
    public static final String detailSearchDate = "detail_search_date";
    public static final String detailUniqueRuleShow = "detail_unique_rule_show";
    public static final String accnoSearchLimit = "accno_search_limit";
    public static final String detailNoteSelect = "detail_note_select";
    public static final String detailNoteSelectDetail = "detail_note_select_detail";
    public static final String LINK_PAY_CONFIG = "LINK_PAY_CONFIG";
    public static final String bankIsNote = "bank_isNote";
    public static final String accEcnyType = "bank_ecny_type";
    public static final String accEcnyLevel = "bank_ecny_level";
    public static final String IS_OPEN_PAY_FOR_SALARY = "IS_OPEN_PAY_FOR_SALARY";
    public static final String SALARY_SELECT = "SALARY_SELECT";
    public static final String SALARY_SAME_BANK = "SALARY_SAME_BANK";
    public static final String SALARY_OTHER_BANK = "SALARY_OTHER_BANK";
    public static final String SALARY_BATCH_SIZE = "SALARY_BATCH_SIZE";
    public static final String SALARY_DETAIL = "SALARY_DETAIL";
    public static final String SALARY_DETAIL_BANK = "SALARY_DETAIL_BANK";
    public static final String CLOUD_TYPE = "CLOUD_TYPE";
    public static final String CLOUD_TYPE_S = "SAAS";
    public static final String CLOUD_TYPE_N = "NORMAL";
    public static final String CLOUD_TYPE_Y = "PRE";
    public static final MultiLangEnumBridge CLOUD_TYPE_KEY_S = BankPropertyConfig.getCLOUD_TYPE_KEY_S();
    public static final MultiLangEnumBridge CLOUD_TYPE_KEY_N = BankPropertyConfig.getCLOUD_TYPE_KEY_N();
    public static final MultiLangEnumBridge CLOUD_TYPE_KEY_Y = BankPropertyConfig.getCLOUD_TYPE_KEY_Y();
    public static final MultiLangEnumBridge CLOUD_TYPE_KEY_F = BankPropertyConfig.getCLOUD_TYPE_KEY_F();
    public static final MultiLangEnumBridge CLOUD_TYPE_KEY_A = BankPropertyConfig.getCLOUD_TYPE_KEY_A();
    public static List<String> readOnlyBankConfigKeys = Lists.newArrayList((Object[])new String[]{"bank_accType", "bank_isReceipt", "bank_cnap", "bank_swift_code", "bank_isNote"});
    private String bankVersionID;
    public static final PropertyConfigItem BANK_SHARE_DLOCK = PropertyConfigItem.builder().key("bank_share_dlock").mlName(new MultiLangEnumBridge("\u94f6\u884c\u524d\u7f6e\u673a\u5171\u7528\u5f00\u5173", "BankPropertyConfig_4", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u524d\u7f6e\u673a\u5171\u7528\u5f00\u5173\uff0c\u7528\u4e8e\u76f8\u540c\u96c6\u7fa4\u4e0b\u4e0d\u540c\u6570\u636e\u4e2d\u5fc3\u7684\u94f6\u884c\u524d\u7f6e\u673a\u5171\u7528\uff1a", "BankPropertyConfig_62", "ebg-aqap-common"), new MultiLangEnumBridge("1)\u5f00\u542f\uff1a\u7fa4\u96c6\u5185\u94f6\u884c\u524d\u7f6e\u673a\u5171\u7528\u5f00\u542f\uff1b ", "BankPropertyConfig_63", "ebg-aqap-common"), new MultiLangEnumBridge("2)\u5173\u95ed\uff1a\u7fa4\u96c6\u5185\u94f6\u884c\u524d\u7f6e\u673a\u5171\u7528\u5173\u95ed\u3002", "BankPropertyConfig_7", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00\u542f", "BankPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u5173\u95ed", "BankPropertyConfig_9", "ebg-aqap-common")})).sourceValues(trueFalseEN).defaultValues(defaultFalse).mustInput(Boolean.TRUE).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).build();
    private static final PropertyConfigItem BANK_PAY_ALLOW = PropertyConfigItem.builder().key("bank_pay_allow").mlName(new MultiLangEnumBridge("\u94f6\u884c\u652f\u4ed8\u901a\u9053\u5f00\u5173", "BankPropertyConfig_10", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u652f\u4ed8\u901a\u9053\u5f00\u5173\uff0c\u7528\u4e8e\u652f\u4ed8\u3001\u5883\u5916\u652f\u4ed8\u548c\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\uff1a", "BankPropertyConfig_64", "ebg-aqap-common"), new MultiLangEnumBridge("1)\u5f00\u542f\uff1a\u5141\u8bb8\u63a5\u6536\u4e1a\u52a1\u7aef\u53d1\u8d77\u7684\u652f\u4ed8\u548c\u67e5\u8be2\u652f\u4ed8\u6307\u4ee4\uff0c\u5e76\u5141\u8bb8\u63d0\u4ea4\u5230\u94f6\u884c\uff1b", "BankPropertyConfig_65", "ebg-aqap-common"), new MultiLangEnumBridge("2)\u5173\u95ed\uff1a\u62d2\u7edd\u63a5\u6536\u4e1a\u52a1\u7aef\u53d1\u8d77\u7684\u652f\u4ed8\u548c\u67e5\u8be2\u652f\u4ed8\u6307\u4ee4\uff0c\u5e76\u7981\u6b62\u63d0\u4ea4\u5230\u94f6\u884c\u3002", "BankPropertyConfig_66", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00\u542f", "BankPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u5173\u95ed", "BankPropertyConfig_9", "ebg-aqap-common")})).sourceValues(trueFalseEN).defaultValues(defaultTrue).mustInput(Boolean.TRUE).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).type(BankPropertyConfigType.SAFE_PREVENT_DUP.getName()).build();
    private static final PropertyConfigItem BANK_QUERY_ALLOW = PropertyConfigItem.builder().key("bank_query_allow").mlName(new MultiLangEnumBridge("\u94f6\u884c\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173", "BankPropertyConfig_14", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173\uff0c\u7528\u4e8e\u975e\u652f\u4ed8\u7c7b\u578b\u4e1a\u52a1\uff1a", "BankPropertyConfig_67", "ebg-aqap-common"), new MultiLangEnumBridge("1)\u5f00\u542f\uff1a\u5141\u8bb8\u63a5\u6536\u4e1a\u52a1\u7aef\u53d1\u8d77\u7684\u975e\u652f\u4ed8\u7c7b\u578b\u6307\u4ee4\uff0c\u5e76\u5141\u8bb8\u63d0\u4ea4\u5230\u94f6\u884c\uff1b", "BankPropertyConfig_68", "ebg-aqap-common"), new MultiLangEnumBridge("2)\u5173\u95ed\uff1a\u62d2\u7edd\u63a5\u6536\u4e1a\u52a1\u7aef\u53d1\u8d77\u7684\u975e\u652f\u4ed8\u7c7b\u578b\u6307\u4ee4\uff0c\u5e76\u7981\u6b62\u63d0\u4ea4\u5230\u94f6\u884c\u3002", "BankPropertyConfig_69", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00\u542f", "BankPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u5173\u95ed", "BankPropertyConfig_9", "ebg-aqap-common")})).sourceValues(trueFalseEN).defaultValues(defaultTrue).mustInput(Boolean.TRUE).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).type(BankPropertyConfigType.SAFE_PREVENT_DUP.getName()).build();
    private static final PropertyConfigItem ANTI_DUPLICATION_PAYMENT = PropertyConfigItem.builder().key("anti_duplication_payment").mlName(new MultiLangEnumBridge("\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173", "BankPropertyConfig_230523_1", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4e1a\u52a1\u5355\u636e\u63d0\u4ea4\u94f6\u4f01\u9632\u91cd\u590d\u9a8c\u8bc1\u5f00\u5173\uff1a\u5728\u540c\u4e00\u5929\u5185\uff0c\u5355\u636e\u5728\u63d0\u4ea4\u94f6\u4f01\u4ed8\u6b3e\u65f6\uff0c\u94f6\u4f01\u4f1a\u5bf9\u5df2\u7ecf\u5b58\u5728\u7684\u5e76\u4e14\u72b6\u6001\u4e3a\u975e\u5931\u8d25\u72b6\u6001\u7684\u5168\u90e8\u4ed8\u6b3e\u8bf7\u6c42\u8fdb\u884c\u91cd\u590d\u6027\u6821\u9a8c\uff0c\u5982\u679c\u5b58\u5728\u4ed8\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u5e01\u79cd\u3001\u4ed8\u6b3e\u91d1\u989d\u3001\u6536\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u9644\u8a00\u4e94\u4e2a\u4fe1\u606f\u5b8c\u5168\u76f8\u540c\u7684\u4ed8\u6b3e\u8bf7\u6c42\uff0c\u4f46\u662f\u4ed8\u6b3e\u6279\u6b21\u53f7\u4e0d\u4e00\u81f4\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u7cfb\u7edf\u5224\u65ad\u4e24\u7b14\u4ed8\u6b3e\u8bf7\u6c42\u91cd\u590d\u3002", "BankPropertyConfig_230523_2", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00\u542f", "BankPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u5173\u95ed", "BankPropertyConfig_9", "ebg-aqap-common")})).sourceValues(trueFalseEN).defaultValues(defaultFalse).mustInput(Boolean.TRUE).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).type(BankPropertyConfigType.SAFE_PREVENT_DUP.getName()).build();
    private static final PropertyConfigItem ANTI_DUPLICATION_FOREIGN_PAYMENT = PropertyConfigItem.builder().key("anti_duplication_foreign_payment").mlName(new MultiLangEnumBridge("\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173", "BankPropertyConfig_230523_1", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4e1a\u52a1\u5355\u636e\u63d0\u4ea4\u94f6\u4f01\u9632\u91cd\u590d\u9a8c\u8bc1\u5f00\u5173\uff1a\u5728\u540c\u4e00\u5929\u5185\uff0c\u5355\u636e\u5728\u63d0\u4ea4\u94f6\u4f01\u4ed8\u6b3e\u65f6\uff0c\u94f6\u4f01\u4f1a\u5bf9\u5df2\u7ecf\u5b58\u5728\u7684\u5e76\u4e14\u72b6\u6001\u4e3a\u975e\u5931\u8d25\u72b6\u6001\u7684\u5168\u90e8\u4ed8\u6b3e\u8bf7\u6c42\u8fdb\u884c\u91cd\u590d\u6027\u6821\u9a8c\uff0c\u5982\u679c\u5b58\u5728\u4ed8\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u5e01\u79cd\u3001\u4ed8\u6b3e\u91d1\u989d\u3001\u6536\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u9644\u8a00\u4e94\u4e2a\u4fe1\u606f\u5b8c\u5168\u76f8\u540c\u7684\u4ed8\u6b3e\u8bf7\u6c42\uff0c\u4f46\u662f\u4ed8\u6b3e\u6279\u6b21\u53f7\u4e0d\u4e00\u81f4\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u7cfb\u7edf\u5224\u65ad\u4e24\u7b14\u4ed8\u6b3e\u8bf7\u6c42\u91cd\u590d\u3002", "BankPropertyConfig_230523_2", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00\u542f", "BankPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u5173\u95ed", "BankPropertyConfig_9", "ebg-aqap-common")})).sourceValues(trueFalseEN).defaultValues(defaultTrue).mustInput(Boolean.TRUE).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).type(BankPropertyConfigType.SAFE_PREVENT_DUP.getName()).build();
    private static final PropertyConfigItem ANTI_DUPLICATION_PAYMENT_AMOUNT = PropertyConfigItem.builder().key("anti_duplication_payment_amount").mlName(new MultiLangEnumBridge("\u9632\u91cd\u590d\u9a8c\u8bc1\u5355\u636e\u91d1\u989d", "BankPropertyConfig_230523_3", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f53\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u9a8c\u8bc1\u5f00\u5173\u4e3a\u662f\uff0c\u5219\u5728\u6821\u9a8c\u662f\u5426\u91cd\u590d\u65f6\uff0c\u9700\u8981\u5224\u65ad\u4ed8\u6b3e\u8bf7\u6c42\u7684\u91d1\u989d\u662f\u5426\u5728\u8be5\u914d\u7f6e\u9879\u8303\u56f4\u5185\uff0c\u5982\u679c\u5728\u8be5\u914d\u7f6e\u9879\u8303\u56f4\u5185\u5219\u4e0d\u8fdb\u884c\u5355\u636e\u9632\u91cd\u6821\u9a8c\uff0c\u5982\u679c\u5927\u4e8e\u8be5\u91d1\u989d\u5219\u8fdb\u884c\u5355\u636e\u9632\u91cd\u6821\u9a8c\uff1b", "BankPropertyConfig_230523_5", "ebg-aqap-common"), new MultiLangEnumBridge("\u9ed8\u8ba4\u9632\u91cd\u4ed8\u6821\u9a8c\u91d1\u989d\u4e3a\u7a7a\uff0c\u53730\uff0c\u6240\u6709\u4ed8\u6b3e\u5355\u636e\u63d0\u4ea4\u90fd\u9700\u8981\u8fdb\u884c\u6821\u9a8c\u3002", "BankPropertyConfig_230523_6", "ebg-aqap-common")})).set2Integer().set2MinValueNum(0).defaultValues(Lists.newArrayList((Object[])new String[]{"0"})).type(BankPropertyConfigType.SAFE_PREVENT_DUP.getName()).build();
    private static final PropertyConfigItem EXPLANATION_SPECIAL_CHAR_POOL = PropertyConfigItem.builder().key("explanation_special_char_pool").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6458\u8981\u7279\u6b8a\u5b57\u7b26\u6c60\u3002", "BankPropertyConfig_18", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f53\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u4f01\u65f6\uff0c\u5982\u679c\u6458\u8981\u5b57\u6bb5\u5185\u5305\u542b\u914d\u7f6e\u7684\u7279\u6b8a\u5b57\u7b26\uff0c\u5219\u63d0\u4ea4\u94f6\u4f01\u65f6\u76f4\u63a5\u7f6e\u4e3a\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\u72b6\u6001\u3002\u8bf7\u8c28\u614e\u914d\u7f6e\u3002", "BankPropertyConfig_70", "ebg-aqap-common"), new MultiLangEnumBridge("\u6ce8\u610f\uff1a\u591a\u4e2a\u7279\u6b8a\u5b57\u7b26\uff0c\u8bf7\u7528\u82f1\u6587\u5206\u53f7;\u9694\u5f00\u3002", "BankPropertyConfig_71", "ebg-aqap-common"), new MultiLangEnumBridge("\u89c4\u5219\u8bf4\u660e\uff1a\u652f\u6301\u914d\u7f6e\u7279\u6b8a\u5b57\u7b26\u53ca\u5b57\u6bcd\u3002", "BankPropertyConfig_72", "ebg-aqap-common")})).build();
    private static final PropertyConfigItem ALL_BANK_ACC_TYPE = PropertyConfigItem.builder().key("bank_accType").name(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u522b", (String)"BankPropertyConfig_22", (String)"ebg-aqap-common", (Object[])new Object[0])).mlName(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b", "BankPropertyConfig_22", "ebg-aqap-common")).desc(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7c7b\u522b\u3002", (String)"BankPropertyConfig_23", (String)"ebg-aqap-common", (Object[])new Object[0])).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u8d26\u6237\u7c7b\u522b\u3002", "BankPropertyConfig_23", "ebg-aqap-common")})).sourceNames(BankPropertyConfig.getAccountTypeNameList(BankPropertyConfig.getAccountTypeList())).mlSourceNames(BankPropertyConfig.getAccountTypeMlNameList(BankPropertyConfig.getAccountTypeList())).sourceValues(BankPropertyConfig.getAccountTypeList()).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(true).mustInput(true).build();
    private static final PropertyConfigItem BANK_ACC_TYPE = PropertyConfigItem.builder().key("bank_accType").name(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u522b", (String)"BankPropertyConfig_22", (String)"ebg-aqap-common", (Object[])new Object[0])).mlName(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b", "BankPropertyConfig_22", "ebg-aqap-common")).desc(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7c7b\u522b\u3002", (String)"BankPropertyConfig_23", (String)"ebg-aqap-common", (Object[])new Object[0])).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u8d26\u6237\u7c7b\u522b\u3002", "BankPropertyConfig_23", "ebg-aqap-common")})).sourceNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u666e\u901a\u7c7b", (String)"BankPropertyConfig_24", (String)"ebg-aqap-common", (Object[])new Object[0])})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankPropertyConfig_24", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"normal"})).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(true).mustInput(true).build();
    private static final PropertyConfigItem BANK_IS_RECEIPT = PropertyConfigItem.builder().key("bank_isReceipt").mlName(new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u8d26\u53f7", "BankPropertyConfig_25", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u8d26\u53f7\uff1a\u914d\u7f6e\u4e3a\u7535\u5b50\u56de\u5355\u8d26\u53f7\uff0c\u67e5\u8be2\u56de\u5355\u65f6\u4f1a\u5360\u7528\u94f6\u4f01\u63a5\u53e3\u8bb8\u53ef", "BankPropertyConfig_87", "ebg-aqap-common"), new MultiLangEnumBridge("1\uff09\u662f\uff0c\u5219\u8be5\u8d26\u53f7\u4e3a\u652f\u6301\u7535\u5b50\u56de\u5355\u8d26\u53f7\uff0c\u4f1a\u6839\u636e\u8c03\u5ea6\u6267\u884c\u7535\u5b50\u56de\u5355\u67e5\u8be2", "BankPropertyConfig_88", "ebg-aqap-common"), new MultiLangEnumBridge("2\uff09\u5426\uff0c\u5219\u8be5\u8d26\u53f7\u4e3a\u975e\u7535\u5b50\u56de\u5355\u8d26\u53f7\uff0c\u4e0d\u8fdb\u884c\u7535\u5b50\u56de\u5355\u67e5\u8be2", "BankPropertyConfig_89", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankPropertyConfig_27", "ebg-aqap-common"), new MultiLangEnumBridge("\u5426", "BankPropertyConfig_28", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues(Lists.newArrayList((Object[])new String[]{"false"})).isAccNo(true).mustInput(true).isHideForForeignBank(true).build();
    private static final PropertyConfigItem BANK_AREA_CODE = PropertyConfigItem.builder().key("bank_area_code").mlName(new MultiLangEnumBridge("\u5730\u533a\u7801", "BankPropertyConfig_29", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8bbe\u7f6e\u5730\u533a\u7801", "BankPropertyConfig_30", "ebg-aqap-common")})).isAccNo(true).isHideForForeignBank(true).build();
    private static final PropertyConfigItem BANK_CNAP = PropertyConfigItem.builder().key("bank_cnap").mlName(new MultiLangEnumBridge("\u8054\u884c\u53f7", "BankPropertyConfig_31", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8054\u884c\u53f7\uff0c\u8054\u52a8\u652f\u4ed8\u4e1a\u52a1\u4f7f\u7528\u3002", "BankPropertyConfig_32", "ebg-aqap-common"), new MultiLangEnumBridge("\u4e24\u6b65\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u6b64\u4fe1\u606f\u4f5c\u4e3a\u5b50\u8d26\u53f7\u65b9\u6536\u6b3e\u8054\u884c\u53f7\u4fe1\u606f\u3002", "BankPropertyConfig_321", "ebg-aqap-common")})).isAccNo(true).isHideForForeignBank(true).build();
    public static final PropertyConfigItem BANK_SWIFT_CODE = PropertyConfigItem.builder().key("bank_swift_code").mlName(new MultiLangEnumBridge("SWIFT Code", "BankPropertyConfig_33", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWFIT Code\uff1a\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff0c\u5e38\u7528\u4e8e\u94f6\u884c\u4ed8\u6b3e\u4e1a\u52a1\u3002", "BankPropertyConfig_34", "ebg-aqap-common")})).isAccNo(true).isHideForForeignBank(true).build();
    static final PropertyConfigItem COMPNO = PropertyConfigItem.builder().key("compNo").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u5355\u4f4d\u7f16\u53f7\u3002", "BankPropertyConfig_35", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684'\u5355\u4f4d\u7f16\u53f7'\uff08\u94f6\u884c\u63d0\u4f9b\uff09", "BankPropertyConfig_36", "ebg-aqap-common")})).isAccNo(true).isHideForForeignBank(true).build();
    public static final PropertyConfigItem ACCNO_SEARCH_LIMIT = PropertyConfigItem.builder().key("accno_search_limit").mlName(new MultiLangEnumBridge("\u5168\u65b0\u82cd\u7a79\u94f6\u4f01\u4e91\u8d26\u6237\u3002", "BankPropertyConfig_37", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("1)\u65e7\u94f6\u4f01\u4e91\u5207\u6362\u82cd\u7a79\u94f6\u4f01\u4e91\u65f6\uff0c\u5bf9\u4e8e\u539f\u672c\u4e0d\u5728\u65e7\u7248\u94f6\u4f01\u4e91\uff0c\u4f46\u662f\u9700\u8981\u5728\u82cd\u7a79\u7248\u94f6\u4f01\u4e91\u65b0\u589e\u7684\u8d26\u6237\uff0c\u4e0d\u9650\u5236\u6b64\u8d26\u6237\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u67e5\u8be2\u3002", "BankPropertyConfig_38", "ebg-aqap-common"), new MultiLangEnumBridge("2)\u5bf9\u4e8e\u539f\u672c\u5c31\u5728\u65e7\u7248\u94f6\u4f01\u4e91\u7684\u8d26\u6237\uff0c\u4e3a\u907f\u514d\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u67e5\u8be2\u5207\u6362\u65e5\u671f\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u3002", "BankPropertyConfig_73", "ebg-aqap-common"), new MultiLangEnumBridge("3)\u975e\u65b0\u65e7\u5207\u6362\u5ffd\u7565\u6b64\u914d\u7f6e\u3002", "BankPropertyConfig_74", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankPropertyConfig_27", "ebg-aqap-common"), new MultiLangEnumBridge("\u5426", "BankPropertyConfig_28", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues(Lists.newArrayList((Object[])new String[]{"false"})).readonly(true).isAccNo(true).isHide(true).build();
    public static final PropertyConfigItem DETAIL_SEARCH_DATE = PropertyConfigItem.builder().key("detail_search_date").mlName(new MultiLangEnumBridge("\u56de\u5355\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f\u3002", "BankPropertyConfig_41", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u65e7\u94f6\u4f01\u4e91\u5207\u6362\u82cd\u7a79\u94f6\u4f01\u4e91\u65f6\u8bbe\u7f6e\uff0c\u907f\u514d\u4e1a\u52a1\u7cfb\u7edf\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u91cd\u590d\u3002", "BankPropertyConfig_42", "ebg-aqap-common"), new MultiLangEnumBridge("1)\u4e3a\u7a7a\u65f6\u4e0d\u9650\u5236\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u67e5\u8be2\uff0c\u5f53\u6709\u503c\u65f6\uff0c\u9650\u5236\u5f53\u524d\u8bbe\u7f6e\u65e5\u671f\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u4e0d\u518d\u67e5\u8be2\u3002", "BankPropertyConfig_75", "ebg-aqap-common"), new MultiLangEnumBridge("2)\u6b64\u914d\u7f6e\u5373\u65b0\u65e7\u94f6\u4f01\u4e91\u5207\u6362\u65e5\u671f\uff0c\u9700\u4e0e\u65e7\u7248\u94f6\u4f01\u4e91\u7684\u503c\u4fdd\u6301\u4e00\u81f4\uff0c\u5e76\u4e14\u9700\u63d0\u524d\u914d\u7f6e\u597d\u3002", "BankPropertyConfig_76", "ebg-aqap-common"), new MultiLangEnumBridge("3)\u4e00\u822c\u5efa\u8bae\u51cc\u6668\u5207\u6362\uff0c\u5bf9\u4ea4\u6613\u660e\u7ec6\u5ef6\u65f6\u6027\u5f71\u54cd\u8f83\u5c0f\u3002", "BankPropertyConfig_77", "ebg-aqap-common"), new MultiLangEnumBridge("4)\u5efa\u8bae\u5207\u6362\u5f53\u5929\u5c06\u6240\u6709\u65e7\u8d26\u6237\u90fd\u540c\u6b65\u8fdb\u65b0\u7248\u94f6\u4f01\u4e91\uff0c\u5207\u6362\u5f53\u5929\u540e\u65b0\u589e\u5230\u94f6\u4f01\u4e91\u7684\u8d26\u6237\u88ab\u8ba4\u4e3a\u662f\u65b0\u8d26\u6237\uff0c\u5c06\u4e0d\u53d7\u6b64\u914d\u7f6e\u9879\u9650\u5236\uff0c\u5141\u8bb8\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u53ca\u56de\u5355\u3002", "BankPropertyConfig_78", "ebg-aqap-common")})).isAccNo(false).inputType(ConfigInputType.DATE.getInputType()).build();
    public static final PropertyConfigItem DETAIL_UNIQUE_RULE_SHOW = PropertyConfigItem.builder().key("detail_unique_rule_show").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u552f\u4e00\u4e3b\u952e\u7ec4\u6210\u89c4\u5219\u3002", "BankPropertyConfig_47", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u552f\u4e00\u4e3b\u952e\u7684\u89c4\u5219\u662f\u4e0e\u94f6\u884c\u65b9\u786e\u8ba4\u5e76\u534f\u5546\u540e\u786e\u5b9a\u7684\uff0c\u901a\u8fc7\u4fdd\u969c\u4ea4\u6613\u660e\u7ec6\u7684\u552f\u4e00\u6027\u6765\u63d0\u9ad8\u4ea4\u6613\u660e\u7ec6\u7684\u6570\u636e\u51c6\u786e\u6027\uff1a", "BankPropertyConfig_48", "ebg-aqap-common"), new MultiLangEnumBridge(" 1\u3001\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\u552f\u4e00\u4e3b\u952e\u7684\u94f6\u884c\uff0c\u5176\u7ec4\u6210\u89c4\u5219\u90fd\u4f1a\u5305\u542b\u4ed8\u6b3e\u8d26\u53f7\uff08\u5747\u4e3a[accNo]\u5b57\u6bb5\uff09\u548c\u4ea4\u6613\u65e5\u671f\uff1b", "BankPropertyConfig_79", "ebg-aqap-common"), new MultiLangEnumBridge(" 2\u3001\u90e8\u5206\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u683c\u5f0f\u4e3a\u975ejson\u6216xml\u7b49\u683c\u5f0f\u5316\u62a5\u6587\uff0c\u56e0\u4e3a\u6ca1\u6709\u5b57\u6bb5\u540d\u79f0\uff0c\u6240\u4ee5\u5b57\u6bb5\u540d\u79f0\u5747\u4e3a\u6211\u65b9\u81ea\u5b9a\u4e49\uff1b", "BankPropertyConfig_80", "ebg-aqap-common"), new MultiLangEnumBridge(" 3\u3001\u591a\u4e2a\u5b57\u6bb5\u4e4b\u95f4\u7528\u5206\u9694\u7b26'|'\u9694\u65ad\u3002", "BankPropertyConfig_81", "ebg-aqap-common")})).isAccNo(false).inputType(ConfigInputType.TEXT.getInputType()).readonly(true).build();
    public static final PropertyConfigItem IS_OPEN_PAY_FOR_SALARY_CONFIG = PropertyConfigItem.builder().key("IS_OPEN_PAY_FOR_SALARY").mlName(new MultiLangEnumBridge("\u662f\u5426\u542f\u7528\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u3002", "BankPropertyConfig_56", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\uff1a\u5141\u8bb8\u4e1a\u52a1\u7cfb\u7edf\u63d0\u4ea4\u4ee3\u53d1\u5de5\u8d44 \uff1b\u5426\uff1a\u62d2\u7edd\u4e1a\u52a1\u7cfb\u7edf\u63d0\u4ea4\u4ee3\u53d1\u5de5\u8d44\u3002", "BankPropertyConfig_57", "ebg-aqap-common")})).mlSourceNames(mlFalseTrueCN).sourceValues(falseTrueEN).defaultValues(defaultFalse).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).mustInput(true).build();
    private static final PropertyConfigItem detail_Note_Select_Detail = PropertyConfigItem.builder().key("detail_note_select_detail").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c\u8be6\u60c5\u3002", "BankPropertyConfig_58", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c\u8be6\u60c5\u3002", "BankPropertyConfig_58", "ebg-aqap-common")})).isHide(true).inputType(ConfigInputType.TEXT.getInputType()).build();
    public final PropertyConfigItem LINK_PAY_CONFIG_ITEM = PropertyConfigItem.builder().key("LINK_PAY_CONFIG").mlName(new MultiLangEnumBridge("\u8054\u52a8\u652f\u4ed8\u65b9\u5f0f\u9009\u62e9\u3002", "BankPropertyConfig_59", "ebg-aqap-common")).mlDesc(this.getLinkPayConfigMlDesc()).mlSourceNames(this.getLinkPayConfigMlNames()).sourceValues(this.getLinkPayConfigValues()).defaultValues(this.getLinkPayConfigDefaultValue()).type(BankPropertyConfigType.LINK_PAY_PARAM.getName()).mustInput(true).build();
    private static final PropertyConfigItem BANK_IS_NOTE = PropertyConfigItem.builder().key("bank_isNote").mlName(new MultiLangEnumBridge("\u7535\u5b50\u7968\u636e\u8d26\u53f7", "BankPropertyConfig_60", "ebg-aqap-common")).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankPropertyConfig_27", "ebg-aqap-common"), new MultiLangEnumBridge("\u5426", "BankPropertyConfig_28", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues(Lists.newArrayList((Object[])new String[]{"false"})).isAccNo(true).mustInput(true).isHideForForeignBank(true).build();
    static final PropertyConfigItem ACC_ECNY_TYPE = PropertyConfigItem.builder().key("bank_ecny_type").mlName(new MultiLangEnumBridge("\u94b1\u5305\u7c7b\u578b", "BankPropertyConfig_90", "ebg-aqap-common")).mlDesc(Lists.newArrayList()).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5bf9\u516c\u94b1\u5305", "BankPropertyConfig_91", "ebg-aqap-common"), new MultiLangEnumBridge("\u5bf9\u516c\u5b50\u94b1\u5305", "BankPropertyConfig_92", "ebg-aqap-common")})).sourceValues(BankPropertyConfig.getAccEcnyTypeList()).defaultValues(Lists.newArrayList((Object[])new String[]{"WT09"})).isAccNo(true).mustInput(true).build();
    static final PropertyConfigItem ACC_ECNY_LEVEL = PropertyConfigItem.builder().key("bank_ecny_level").mlName(new MultiLangEnumBridge("\u94b1\u5305\u7b49\u7ea7", "BankPropertyConfig_93", "ebg-aqap-common")).mlDesc(Lists.newArrayList()).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4e00\u7c7b\u94b1\u5305", "BankPropertyConfig_94", "ebg-aqap-common"), new MultiLangEnumBridge("\u4e8c\u7c7b\u94b1\u5305", "BankPropertyConfig_95", "ebg-aqap-common"), new MultiLangEnumBridge("\u4e09\u7c7b\u94b1\u5305", "BankPropertyConfig_96", "ebg-aqap-common"), new MultiLangEnumBridge("\u56db\u7c7b\u94b1\u5305", "BankPropertyConfig_97", "ebg-aqap-common"), new MultiLangEnumBridge("\u4e94\u7c7b\u94b1\u5305", "BankPropertyConfig_98", "ebg-aqap-common")})).sourceValues(BankPropertyConfig.getAccEcnyLevelList()).defaultValues(Lists.newArrayList((Object[])new String[]{"WL01"})).isAccNo(true).mustInput(true).build();

    public static boolean isReadOnlyWhenBillEdit(String key) {
        for (String bankConfigKey : readOnlyBankConfigKeys) {
            if (!bankConfigKey.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static MultiLangEnumBridge getCLOUD_TYPE_KEY_S() {
        return new MultiLangEnumBridge("saas\u6a21\u5f0f\u4e91\u76f4\u8054", "BankPropertyConfig_0", "ebg-aqap-common");
    }

    private static MultiLangEnumBridge getCLOUD_TYPE_KEY_F() {
        return new MultiLangEnumBridge("\u6709\u524d\u7f6e\u673a\u6a21\u5f0f", "BankPropertyConfig_15", "ebg-aqap-common");
    }

    private static MultiLangEnumBridge getCLOUD_TYPE_KEY_A() {
        return new MultiLangEnumBridge("openapi\u6a21\u5f0f", "BankPropertyConfig_16", "ebg-aqap-common");
    }

    private static MultiLangEnumBridge getCLOUD_TYPE_KEY_N() {
        return new MultiLangEnumBridge("\u6807\u51c6\u6a21\u5f0f\u4e91\u76f4\u8054\u3002", "BankPropertyConfig_1", "ebg-aqap-common");
    }

    private static MultiLangEnumBridge getCLOUD_TYPE_KEY_Y() {
        return new MultiLangEnumBridge("\u6709\u524d\u7f6e\u673a\u6a21\u5f0f\u4e91\u76f4\u8fde", "BankPropertyConfig_2", "ebg-aqap-common");
    }

    @Override
    public void setBankVersionID(String bankVersionID) {
        this.bankVersionID = bankVersionID;
    }

    public String getBankVersionID() {
        return this.bankVersionID;
    }

    @Override
    public final PropertyName getPropertyName() {
        return PropertyName.BANK_BUSINESS;
    }

    @Override
    public final String getPropertyConfigID() {
        EBContext context = EBContext.getContext();
        return context != null ? context.getBankVersionID() : this.getBankVersionID();
    }

    @Override
    public String getConfigName() {
        return String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\uff0c\u94f6\u884c\u7248\u672c\u53f7:%s\u3002", (String)"BankPropertyConfig_61", (String)"ebg-aqap-common", (Object[])new Object[0]), this.getBankVersionID());
    }

    @Override
    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5c42\u9762\u4e1a\u52a1\u914d\u7f6e\u3002", (String)"BankPropertyConfig_3", (String)"ebg-aqap-common", (Object[])new Object[0]);
    }

    @Override
    public boolean isForeignBank() {
        return false;
    }

    public static List<MultiLangEnumBridge> getAccountTypeMlNameList(List<String> itemList) {
        ArrayList<MultiLangEnumBridge> accountTypeList = new ArrayList<MultiLangEnumBridge>(16);
        for (String item : itemList) {
            accountTypeList.add(MultiLang.getMlAccountType((String)item));
        }
        return accountTypeList;
    }

    public static List<String> getAccountTypeNameList(List<String> itemList) {
        ArrayList<String> accountTypeList = new ArrayList<String>(16);
        for (String item : itemList) {
            accountTypeList.add(MultiLang.getAccountType((String)item));
        }
        return accountTypeList;
    }

    private static List<String> getAccountTypeList() {
        return Lists.newArrayList((Object[])new String[]{"normal", "caizi", "vcp", "fixed", "cashpool", "notice", "vitual", "mutilevel"});
    }

    public static PropertyConfigItem buildPOP(List<MultiLangEnumBridge> descList, List<MultiLangEnumBridge> sourceList, List<String> valList, List<String> defaultList) {
        return PropertyConfigItem.builder().key("postscript_or_purpose").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u65f6\u9644\u8a00/\u6458\u8981\u4e0a\u9001\u89c4\u5219\u9009\u62e9", "BankPropertyConfig_100", "ebg-aqap-common")).mlDesc(descList).mlSourceNames(sourceList).sourceValues(valList).defaultValues(defaultList).type(BankPropertyConfigType.PAY_BIZ_PARAM.getName()).mustInput(true).build();
    }

    private static List<String> getAccEcnyLevelList() {
        return Lists.newArrayList((Object[])new String[]{"WL01", "WL02", "WL03", "WL04", "WL05"});
    }

    private static List<String> getAccEcnyTypeList() {
        return Lists.newArrayList((Object[])new String[]{"WT09", "WT10"});
    }

    private boolean isUseLinkPayConfig() {
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        boolean flag = linkPayConfigList == null || linkPayConfigList.isEmpty();
        return !flag;
    }

    private String getLinkPayConfigDesc() {
        StringBuilder sb = new StringBuilder();
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            for (int i = 0; i < linkPayConfigList.size(); ++i) {
                sb.append(i + 1).append(')').append(linkPayConfigList.get(i).getDesc()).append("\r\n");
            }
        }
        return sb.toString();
    }

    private List<MultiLangEnumBridge> getLinkPayConfigMlDesc() {
        ArrayList<MultiLangEnumBridge> result = new ArrayList<MultiLangEnumBridge>(16);
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            result.add(new MultiLangEnumBridge("\u8054\u52a8\u652f\u4ed8\u65b9\u5f0f\u9009\u62e9:\u3002", "BankPropertyConfig_82", "ebg-aqap-common"));
            for (int i = 0; i < linkPayConfigList.size(); ++i) {
                result.add(linkPayConfigList.get(i).getMlDesc());
            }
        }
        return result;
    }

    private List<String> getLinkPayConfigNames() {
        ArrayList<String> result = new ArrayList<String>(1);
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            for (LinkPayConfig linkPayConfig : linkPayConfigList) {
                result.add(linkPayConfig.getName());
            }
        }
        return result;
    }

    private List<MultiLangEnumBridge> getLinkPayConfigMlNames() {
        ArrayList<MultiLangEnumBridge> result = new ArrayList<MultiLangEnumBridge>(16);
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            for (LinkPayConfig linkPayConfig : linkPayConfigList) {
                result.add(linkPayConfig.getMlName());
            }
        }
        return result;
    }

    private List<String> getLinkPayConfigValues() {
        ArrayList<String> result = new ArrayList<String>(1);
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            for (LinkPayConfig linkPayConfig : linkPayConfigList) {
                result.add(linkPayConfig.getKey());
            }
        }
        return result;
    }

    private List<String> getLinkPayConfigDefaultValue() {
        ArrayList<String> result = new ArrayList<String>(1);
        List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
        if (linkPayConfigList != null) {
            result.add(linkPayConfigList.get(0).getKey());
        }
        return result;
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems() {
        return this.getBankAddtionalPropertyConfigItems(true, false, false, true);
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems(boolean hasAreaCode) {
        return this.getBankAddtionalPropertyConfigItems(true, false, true, true);
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems(boolean hasReceiptNo, boolean zdyBankAccType) {
        return this.getBankAddtionalPropertyConfigItems(hasReceiptNo, zdyBankAccType, false, true);
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems(boolean hasReceiptNo, boolean zdyBankAccType, boolean supportSalary) {
        return this.getBankAddtionalPropertyConfigItems(hasReceiptNo, zdyBankAccType, false, supportSalary);
    }

    public List<PropertyConfigItem> getEcnyBankAddtionalPropertyConfigItems(boolean hasReceiptNo, boolean supportSalary, boolean isEcny) {
        boolean foreignBank;
        ArrayList propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{BANK_SHARE_DLOCK, BANK_PAY_ALLOW, BANK_QUERY_ALLOW, ANTI_DUPLICATION_PAYMENT, ANTI_DUPLICATION_FOREIGN_PAYMENT, ANTI_DUPLICATION_PAYMENT_AMOUNT, EXPLANATION_SPECIAL_CHAR_POOL, BANK_IS_RECEIPT, DETAIL_UNIQUE_RULE_SHOW, IS_OPEN_PAY_FOR_SALARY_CONFIG, detail_Note_Select_Detail, ACC_ECNY_TYPE, ACC_ECNY_LEVEL});
        if (!hasReceiptNo) {
            propertyConfigItems.remove(BANK_IS_RECEIPT);
        }
        if (!supportSalary) {
            propertyConfigItems.remove(IS_OPEN_PAY_FOR_SALARY_CONFIG);
        }
        if (foreignBank = this.isForeignBank()) {
            propertyConfigItems.remove(ANTI_DUPLICATION_PAYMENT);
        } else {
            propertyConfigItems.remove(ANTI_DUPLICATION_FOREIGN_PAYMENT);
        }
        return propertyConfigItems;
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems(boolean hasReceiptNo, boolean zdyBankAccType, boolean hasAreaCode, boolean supportSalary) {
        boolean foreignBank;
        List<Object> propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{BANK_SHARE_DLOCK, BANK_PAY_ALLOW, BANK_QUERY_ALLOW, ANTI_DUPLICATION_PAYMENT, ANTI_DUPLICATION_FOREIGN_PAYMENT, ANTI_DUPLICATION_PAYMENT_AMOUNT, EXPLANATION_SPECIAL_CHAR_POOL, BANK_ACC_TYPE, BANK_IS_RECEIPT, ACCNO_SEARCH_LIMIT, DETAIL_SEARCH_DATE, DETAIL_UNIQUE_RULE_SHOW, IS_OPEN_PAY_FOR_SALARY_CONFIG, detail_Note_Select_Detail, BANK_IS_NOTE});
        if (hasAreaCode) {
            propertyConfigItems.add(BANK_AREA_CODE);
        }
        propertyConfigItems = propertyConfigItems.stream().filter(propertyConfigItem -> !Objects.equals(propertyConfigItem.getKey(), BANK_IS_NOTE.getKey())).collect(Collectors.toList());
        if (!supportSalary) {
            propertyConfigItems = propertyConfigItems.stream().filter(propertyConfigItem -> !Objects.equals(propertyConfigItem.getKey(), IS_OPEN_PAY_FOR_SALARY_CONFIG.getKey())).collect(Collectors.toList());
        }
        if (this.isUseLinkPayConfig()) {
            propertyConfigItems.add(this.LINK_PAY_CONFIG_ITEM);
            propertyConfigItems.add(BANK_CNAP);
        }
        if (foreignBank = this.isForeignBank()) {
            propertyConfigItems.remove(ANTI_DUPLICATION_PAYMENT);
            List<PropertyConfigItem> collect = hasReceiptNo ? propertyConfigItems.stream().filter(propertyConfigItem -> !propertyConfigItem.isHideForForeignBank() || Objects.equals(propertyConfigItem.getKey(), BANK_IS_RECEIPT.getKey())).collect(Collectors.toList()) : propertyConfigItems.stream().filter(propertyConfigItem -> !propertyConfigItem.isHideForForeignBank()).collect(Collectors.toList());
            return collect;
        }
        propertyConfigItems.remove(ANTI_DUPLICATION_FOREIGN_PAYMENT);
        if (!hasReceiptNo) {
            propertyConfigItems.remove(BANK_IS_RECEIPT);
        }
        if (zdyBankAccType) {
            propertyConfigItems.remove(BANK_ACC_TYPE);
        }
        return propertyConfigItems;
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems(boolean hasReceiptNo, boolean zdyBankAccType, boolean hasAreaCode, boolean supportSalary, boolean hasNote) {
        boolean foreignBank;
        List<Object> propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{BANK_SHARE_DLOCK, BANK_PAY_ALLOW, BANK_QUERY_ALLOW, ANTI_DUPLICATION_PAYMENT, ANTI_DUPLICATION_FOREIGN_PAYMENT, ANTI_DUPLICATION_PAYMENT_AMOUNT, EXPLANATION_SPECIAL_CHAR_POOL, BANK_ACC_TYPE, BANK_IS_RECEIPT, ACCNO_SEARCH_LIMIT, DETAIL_SEARCH_DATE, DETAIL_UNIQUE_RULE_SHOW, IS_OPEN_PAY_FOR_SALARY_CONFIG, detail_Note_Select_Detail, BANK_IS_NOTE});
        if (hasAreaCode) {
            propertyConfigItems.add(BANK_AREA_CODE);
        }
        if (!hasNote) {
            propertyConfigItems = propertyConfigItems.stream().filter(propertyConfigItem -> !Objects.equals(propertyConfigItem.getKey(), BANK_IS_NOTE.getKey())).collect(Collectors.toList());
        }
        if (!supportSalary) {
            propertyConfigItems = propertyConfigItems.stream().filter(propertyConfigItem -> !Objects.equals(propertyConfigItem.getKey(), IS_OPEN_PAY_FOR_SALARY_CONFIG.getKey())).collect(Collectors.toList());
        }
        if (this.isUseLinkPayConfig()) {
            propertyConfigItems.add(this.LINK_PAY_CONFIG_ITEM);
            propertyConfigItems.add(BANK_CNAP);
        }
        if (foreignBank = this.isForeignBank()) {
            propertyConfigItems.remove(ANTI_DUPLICATION_PAYMENT);
            List<PropertyConfigItem> collect = hasReceiptNo ? propertyConfigItems.stream().filter(propertyConfigItem -> !propertyConfigItem.isHideForForeignBank() || Objects.equals(propertyConfigItem.getKey(), BANK_IS_RECEIPT.getKey())).collect(Collectors.toList()) : propertyConfigItems.stream().filter(propertyConfigItem -> !propertyConfigItem.isHideForForeignBank()).collect(Collectors.toList());
            return collect;
        }
        propertyConfigItems.remove(ANTI_DUPLICATION_FOREIGN_PAYMENT);
        if (!hasReceiptNo) {
            propertyConfigItems.remove(BANK_IS_RECEIPT);
        }
        if (zdyBankAccType) {
            propertyConfigItems.remove(BANK_ACC_TYPE);
        }
        return propertyConfigItems;
    }

    public static String getAccnoSearchLimit(String accNo) {
        return ACCNO_SEARCH_LIMIT.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankDetailSearchDate(String bankVersionID) {
        return DETAIL_SEARCH_DATE.getCurrentValueWithObjectID(bankVersionID);
    }

    public static boolean isBankShareLock(String bankVersionID) {
        return "true".equalsIgnoreCase(BANK_SHARE_DLOCK.getCurrentValueWithObjectID(bankVersionID));
    }

    public static boolean isBankPayAllow(String bankVersionID) {
        return "true".equalsIgnoreCase(BANK_PAY_ALLOW.getCurrentValueWithObjectID(bankVersionID));
    }

    public static boolean isBankQueryAllow(String bankVersionID) {
        return "true".equalsIgnoreCase(BANK_QUERY_ALLOW.getCurrentValueWithObjectID(bankVersionID));
    }

    public static boolean isAntiDuplicationPayment(String bankVersionID) {
        return Boolean.parseBoolean(ANTI_DUPLICATION_PAYMENT.getCurrentValueWithObjectID(bankVersionID));
    }

    public static boolean isAntiDuplicationForeignPayment(String bankVersionID) {
        return Boolean.parseBoolean(ANTI_DUPLICATION_FOREIGN_PAYMENT.getCurrentValueWithObjectID(bankVersionID));
    }

    public static String getAntiDuplicationPaymentAmount(String bankVersionID) {
        return ANTI_DUPLICATION_PAYMENT_AMOUNT.getCurrentValueWithObjectID(bankVersionID);
    }

    public static List<String> getExplanationSpecialCharPool(String bankVersionID) {
        return EXPLANATION_SPECIAL_CHAR_POOL.getCurrentValuesWithObjectID(bankVersionID);
    }

    public static boolean isFixedAcnt(String accNo) {
        String acntType = BankAcntPropertyConfig.getAccType(accNo);
        if (StrUtil.isEmpty((String)acntType)) {
            return false;
        }
        return "fixed".equalsIgnoreCase(acntType.trim());
    }

    public static String getAccNoType(String accNo) {
        return BANK_ACC_TYPE.getCurrentValueWithObjectID(accNo);
    }

    public static void specialAccNoTypeMl(List<PropertyConfigItem> list, List<MultiLangEnumBridge> sourceNames, List<String> sourceValues) {
        PropertyConfigItem BANK_ACC_TYPE_COPY = PropertyConfigItem.builder().key(BANK_ACC_TYPE.getKey()).mlName(BANK_ACC_TYPE.getMlName()).mlDesc(BANK_ACC_TYPE.getMlDesc()).mlSourceNames(sourceNames).sourceValues(sourceValues).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(BANK_ACC_TYPE.isAccNo()).mustInput(BANK_ACC_TYPE.isMustInput()).build();
        list.remove(BANK_ACC_TYPE);
        list.add(0, BANK_ACC_TYPE_COPY);
    }

    public static void specialAccNoType(List<PropertyConfigItem> list, List<String> sourceNames, List<String> sourceValues) {
        PropertyConfigItem BANK_ACC_TYPE_COPY = PropertyConfigItem.builder().key(BANK_ACC_TYPE.getKey()).name(BANK_ACC_TYPE.getName()).desc(BANK_ACC_TYPE.getDesc()).sourceNames(sourceNames).sourceValues(sourceValues).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(BANK_ACC_TYPE.isAccNo()).mustInput(BANK_ACC_TYPE.isMustInput()).build();
        list.remove(BANK_ACC_TYPE);
        list.add(0, BANK_ACC_TYPE_COPY);
    }

    public static void removePropertyConfigItemByKey(List<PropertyConfigItem> list, String name) {
        Iterator<PropertyConfigItem> iterator = list.iterator();
        while (iterator.hasNext()) {
            PropertyConfigItem propertyConfigItem = iterator.next();
            if (!Objects.equals(propertyConfigItem.getKey(), name)) continue;
            iterator.remove();
        }
    }
}

